/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.launchpad.controller;

import de.mossgrabers.controller.launchpad.LaunchpadConfiguration;
import de.mossgrabers.controller.launchpad.controller.LaunchpadPadGrid;
import de.mossgrabers.framework.controller.AbstractControlSurface;
import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.midi.IMidiInput;
import de.mossgrabers.framework.daw.midi.IMidiOutput;
import de.mossgrabers.framework.utils.StringUtils;

public class LaunchpadControlSurface
extends AbstractControlSurface<LaunchpadConfiguration> {
    public static final int LAUNCHPAD_BUTTON_SHIFT = 80;
    public static final int LAUNCHPAD_BUTTON_CLICK = 70;
    public static final int LAUNCHPAD_BUTTON_UNDO = 60;
    public static final int LAUNCHPAD_BUTTON_DELETE = 50;
    public static final int LAUNCHPAD_BUTTON_QUANTIZE = 40;
    public static final int LAUNCHPAD_BUTTON_DUPLICATE = 30;
    public static final int LAUNCHPAD_BUTTON_DOUBLE = 20;
    public static final int LAUNCHPAD_BUTTON_RECORD = 10;
    public static final int LAUNCHPAD_BUTTON_REC_ARM = 1;
    public static final int LAUNCHPAD_BUTTON_TRACK = 2;
    public static final int LAUNCHPAD_BUTTON_MUTE = 3;
    public static final int LAUNCHPAD_BUTTON_SOLO = 4;
    public static final int LAUNCHPAD_BUTTON_VOLUME = 5;
    public static final int LAUNCHPAD_BUTTON_PAN = 6;
    public static final int LAUNCHPAD_BUTTON_SENDS = 7;
    public static final int LAUNCHPAD_BUTTON_STOP_CLIP = 8;
    public static final int LAUNCHPAD_BUTTON_SCENE1 = 89;
    public static final int LAUNCHPAD_BUTTON_SCENE2 = 79;
    public static final int LAUNCHPAD_BUTTON_SCENE3 = 69;
    public static final int LAUNCHPAD_BUTTON_SCENE4 = 59;
    public static final int LAUNCHPAD_BUTTON_SCENE5 = 49;
    public static final int LAUNCHPAD_BUTTON_SCENE6 = 39;
    public static final int LAUNCHPAD_BUTTON_SCENE7 = 29;
    public static final int LAUNCHPAD_BUTTON_SCENE8 = 19;
    public static final int LAUNCHPAD_FADER_1 = 21;
    public static final int LAUNCHPAD_FADER_2 = 22;
    public static final int LAUNCHPAD_FADER_3 = 23;
    public static final int LAUNCHPAD_FADER_4 = 24;
    public static final int LAUNCHPAD_FADER_5 = 25;
    public static final int LAUNCHPAD_FADER_6 = 26;
    public static final int LAUNCHPAD_FADER_7 = 27;
    public static final int LAUNCHPAD_FADER_8 = 28;
    public static final int LAUNCHPAD_PRO_BUTTON_UP = 91;
    public static final int LAUNCHPAD_PRO_BUTTON_DOWN = 92;
    public static final int LAUNCHPAD_PRO_BUTTON_LEFT = 93;
    public static final int LAUNCHPAD_PRO_BUTTON_RIGHT = 94;
    public static final int LAUNCHPAD_PRO_BUTTON_SESSION = 95;
    public static final int LAUNCHPAD_PRO_BUTTON_NOTE = 96;
    public static final int LAUNCHPAD_PRO_BUTTON_DEVICE = 97;
    public static final int LAUNCHPAD_PRO_BUTTON_USER = 98;
    public static final int LAUNCHPAD_MKII_BUTTON_UP = 104;
    public static final int LAUNCHPAD_MKII_BUTTON_DOWN = 105;
    public static final int LAUNCHPAD_MKII_BUTTON_LEFT = 106;
    public static final int LAUNCHPAD_MKII_BUTTON_RIGHT = 107;
    public static final int LAUNCHPAD_MKII_BUTTON_SESSION = 108;
    public static final int LAUNCHPAD_MKII_BUTTON_NOTE = 109;
    public static final int LAUNCHPAD_MKII_BUTTON_DEVICE = 110;
    public static final int LAUNCHPAD_MKII_BUTTON_USER = 111;
    public static final int LAUNCHPAD_BUTTON_STATE_OFF = 0;
    public static final int LAUNCHPAD_BUTTON_STATE_ON = 1;
    public static final int LAUNCHPAD_BUTTON_STATE_HI = 4;
    private static final int[] LAUNCHPAD_PRO_BUTTONS_ALL = new int[]{93, 94, 91, 92, 95, 96, 97, 98, 80, 70, 60, 50, 40, 30, 20, 10, 1, 2, 3, 4, 5, 6, 7, 8, 89, 79, 69, 59, 49, 39, 29, 19};
    private static final int[] LAUNCHPAD_MKII_BUTTONS_ALL = new int[]{106, 107, 104, 105, 108, 109, 110, 111, 80, 70, 60, 50, 40, 30, 20, 10, 1, 2, 3, 4, 5, 6, 7, 8, 89, 79, 69, 59, 49, 39, 29, 19};
    public static final int CONTROL_MODE_OFF = 0;
    public static final int CONTROL_MODE_REC_ARM = 1;
    public static final int CONTROL_MODE_TRACK_SELECT = 2;
    public static final int CONTROL_MODE_MUTE = 3;
    public static final int CONTROL_MODE_SOLO = 4;
    public static final int CONTROL_MODE_STOP_CLIP = 5;
    public static final String LAUNCHPAD_PRO_SYSEX_HEADER = "F0 00 20 29 02 10 ";
    public static final String LAUNCHPAD_PRO_PRG_MODE = "2C 03";
    public static final String LAUNCHPAD_PRO_FADER_MODE = "2C 02";
    public static final String LAUNCHPAD_PRO_PAN_MODE = "2C 02";
    public static final String LAUNCHPAD_MKII_SYSEX_HEADER = "F0 00 20 29 02 18 ";
    public static final String LAUNCHPAD_MKII_PRG_MODE = "22 00";
    public static final String LAUNCHPAD_MKII_FADER_MODE = "22 04";
    public static final String LAUNCHPAD_MKII_PAN_MODE = "22 05";
    private boolean isPro;

    public LaunchpadControlSurface(IHost host, ColorManager colorManager, LaunchpadConfiguration configuration, IMidiOutput output, IMidiInput input, boolean isPro) {
        super(host, configuration, colorManager, output, input, isPro ? LAUNCHPAD_PRO_BUTTONS_ALL : LAUNCHPAD_MKII_BUTTONS_ALL);
        this.isPro = isPro;
        this.shiftButtonId = 80;
        this.deleteButtonId = 50;
        this.soloButtonId = 4;
        this.muteButtonId = 3;
        this.leftButtonId = this.isPro ? 93 : 106;
        this.rightButtonId = this.isPro ? 94 : 107;
        this.upButtonId = this.isPro ? 91 : 104;
        this.downButtonId = this.isPro ? 92 : 105;
        this.pads = new LaunchpadPadGrid(colorManager, this);
        this.output.sendIdentityRequest();
    }

    public boolean isUserPressed() {
        return this.isPressed(this.isPro ? 98 : 111);
    }

    public void setLaunchpadToStandalone() {
        this.sendLaunchpadSysEx("21 01");
    }

    public void setLaunchpadToPrgMode() {
        this.sendLaunchpadSysEx(this.isPro ? LAUNCHPAD_PRO_PRG_MODE : LAUNCHPAD_MKII_PRG_MODE);
        this.host.scheduleTask(this.getPadGrid()::forceFlush, 200L);
    }

    public void setLaunchpadToFaderMode() {
        this.sendLaunchpadSysEx(this.isPro ? "2C 02" : LAUNCHPAD_MKII_FADER_MODE);
        this.host.scheduleTask(this.getPadGrid()::forceFlush, 200L);
    }

    public void setLaunchpadToPanMode() {
        this.sendLaunchpadSysEx(this.isPro ? "2C 02" : LAUNCHPAD_MKII_PAN_MODE);
        this.host.scheduleTask(this.getPadGrid()::forceFlush, 200L);
    }

    public void setupFader(int number, int color) {
        this.sendLaunchpadSysEx("2B 0" + Integer.toString(number) + " 00 " + StringUtils.toHexStr(color) + " 00");
    }

    public void setupPanFader(int number, int color) {
        this.sendLaunchpadSysEx("2B 0" + Integer.toString(number) + " 01 " + StringUtils.toHexStr(color) + " 00");
    }

    @Override
    public void shutdown() {
        this.sendLaunchpadSysEx("0A 63 00");
        this.pads.turnOff();
        for (int button : this.getButtons()) {
            this.setButton(button, 0);
        }
    }

    @Override
    public void setButtonEx(int button, int channel, int state) {
        if (!(this.isPro || button != 89 && button != 79 && button != 69 && button != 59 && button != 49 && button != 39 && button != 29 && button != 19)) {
            this.output.sendNote(button, state);
        }
        this.output.sendCC(button, state);
    }

    public void sendLaunchpadSysEx(String data) {
        this.output.sendSysex((this.isPro ? LAUNCHPAD_PRO_SYSEX_HEADER : LAUNCHPAD_MKII_SYSEX_HEADER) + data + " F7");
    }

    public int getNoteButton() {
        return this.isPro ? 96 : 109;
    }

    public int getSessionButton() {
        return this.isPro ? 95 : 108;
    }

    public int getDeviceButton() {
        return this.isPro ? 97 : 110;
    }

    public int getUserButton() {
        return this.isPro ? 98 : 111;
    }

    @Override
    public int getSceneButton(int index) {
        return 89 - 10 * index;
    }

    @Override
    protected void handleGridNote(int note, int velocity) {
        super.handleGridNote(this.pads.translateToGrid(note), velocity);
    }

    @Override
    public boolean isGridNote(int note) {
        return super.isGridNote(this.pads.translateToGrid(note));
    }

    public boolean isPro() {
        return this.isPro;
    }
}

