/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.launchpad.command.trigger;

import de.mossgrabers.controller.launchpad.LaunchpadConfiguration;
import de.mossgrabers.controller.launchpad.controller.LaunchpadControlSurface;
import de.mossgrabers.controller.launchpad.view.Views;
import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.command.trigger.ViewMultiSelectCommand;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.ViewManager;

public class SelectNoteViewCommand
extends AbstractTriggerCommand<LaunchpadControlSurface, LaunchpadConfiguration> {
    private final ViewMultiSelectCommand<LaunchpadControlSurface, LaunchpadConfiguration> playSelect;
    private final ViewMultiSelectCommand<LaunchpadControlSurface, LaunchpadConfiguration> seqSelect;

    public SelectNoteViewCommand(IModel model, LaunchpadControlSurface surface) {
        super(model, surface);
        if (this.model.getHost().hasClips()) {
            this.playSelect = new ViewMultiSelectCommand(model, surface, Views.VIEW_PLAY, Views.VIEW_PIANO, Views.VIEW_DRUM, Views.VIEW_DRUM4, Views.VIEW_DRUM8, Views.VIEW_DRUM64);
            this.seqSelect = new ViewMultiSelectCommand(model, surface, Views.VIEW_SEQUENCER, Views.VIEW_RAINDROPS);
        } else {
            this.playSelect = new ViewMultiSelectCommand(model, surface, Views.VIEW_PLAY, Views.VIEW_PIANO, Views.VIEW_DRUM64);
            this.seqSelect = this.playSelect;
        }
    }

    @Override
    public void execute(ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        ViewManager viewManager = ((LaunchpadControlSurface)this.surface).getViewManager();
        ITrack sel = this.model.getSelectedTrack();
        if (sel == null) {
            viewManager.setActiveView(Views.VIEW_SESSION);
            return;
        }
        boolean isShifted = ((LaunchpadControlSurface)this.surface).isShiftPressed();
        if (Views.isNoteView(isShifted ? viewManager.getPreviousViewId() : viewManager.getActiveViewId())) {
            if (isShifted) {
                this.seqSelect.executeNormal(event);
            } else {
                this.playSelect.executeNormal(event);
            }
        } else {
            Integer viewID = viewManager.getPreferredView(sel.getPosition());
            if (viewID == null) {
                this.seqSelect.executeNormal(event);
            } else {
                viewManager.setActiveView(viewID);
            }
        }
        viewManager.setPreferredView(sel.getPosition(), viewManager.getActiveViewId());
        ((LaunchpadControlSurface)this.surface).getDisplay().notify(viewManager.getActiveView().getName());
    }
}

