/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.launchpad.command.trigger;

import de.mossgrabers.controller.launchpad.LaunchpadConfiguration;
import de.mossgrabers.controller.launchpad.controller.LaunchpadControlSurface;
import de.mossgrabers.controller.launchpad.view.Views;
import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.ViewManager;

public class SelectDeviceViewCommand
extends AbstractTriggerCommand<LaunchpadControlSurface, LaunchpadConfiguration> {
    protected int startRetries;

    public SelectDeviceViewCommand(IModel model, LaunchpadControlSurface surface) {
        super(model, surface);
    }

    @Override
    public void execute(ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        ViewManager viewManager = ((LaunchpadControlSurface)this.surface).getViewManager();
        if (viewManager.isActiveView(Views.VIEW_BROWSER)) {
            this.model.getBrowser().stopBrowsing(false);
            viewManager.setActiveView(Views.VIEW_DEVICE);
            return;
        }
        if (viewManager.isActiveView(Views.VIEW_DEVICE)) {
            if (((LaunchpadControlSurface)this.surface).isShiftPressed() || !this.model.getCursorDevice().hasSelectedDevice()) {
                this.model.getBrowser().browseToInsertAfterDevice();
            } else {
                this.model.getBrowser().browseForPresets();
            }
            this.startRetries = 0;
            this.activateBrowserView();
            return;
        }
        viewManager.setActiveView(Views.VIEW_DEVICE);
    }

    protected void activateBrowserView() {
        if (this.model.getBrowser().isActive()) {
            ((LaunchpadControlSurface)this.surface).getViewManager().setActiveView(Views.VIEW_BROWSER);
        } else if (this.startRetries < 20) {
            ++this.startRetries;
            ((LaunchpadControlSurface)this.surface).scheduleTask(this::activateBrowserView, 200L);
        }
    }
}

