/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.launchpad.command.trigger;

import de.mossgrabers.controller.launchpad.LaunchpadConfiguration;
import de.mossgrabers.controller.launchpad.controller.LaunchpadControlSurface;
import de.mossgrabers.controller.launchpad.view.DrumView;
import de.mossgrabers.controller.launchpad.view.DrumView64;
import de.mossgrabers.controller.launchpad.view.PlayView;
import de.mossgrabers.controller.launchpad.view.RaindropsView;
import de.mossgrabers.controller.launchpad.view.SequencerView;
import de.mossgrabers.controller.launchpad.view.Views;
import de.mossgrabers.framework.command.trigger.CursorCommand;
import de.mossgrabers.framework.daw.IBrowser;
import de.mossgrabers.framework.daw.IChannelBank;
import de.mossgrabers.framework.daw.ICursorDevice;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.scale.Scale;
import de.mossgrabers.framework.scale.Scales;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.AbstractSequencerView;
import de.mossgrabers.framework.view.View;
import de.mossgrabers.framework.view.ViewManager;

public class LaunchpadCursorCommand
extends CursorCommand<LaunchpadControlSurface, LaunchpadConfiguration> {
    public LaunchpadCursorCommand(CursorCommand.Direction direction, IModel model, LaunchpadControlSurface surface) {
        super(direction, model, surface);
    }

    @Override
    protected void updateArrowStates() {
        IChannelBank tb = this.model.getCurrentTrackBank();
        ViewManager viewManager = ((LaunchpadControlSurface)this.surface).getViewManager();
        if (viewManager.isActiveView(Views.VIEW_PLAY)) {
            Scales scales = this.model.getScales();
            int octave = scales.getOctave();
            this.canScrollUp = octave < 3;
            this.canScrollDown = octave > -3;
            int scale = scales.getScale().ordinal();
            this.canScrollLeft = scale > 0;
            this.canScrollRight = scale < Scale.values().length - 1;
            return;
        }
        if (viewManager.isActiveView(Views.VIEW_PIANO)) {
            Scales scales = this.model.getScales();
            int octave = scales.getOctave();
            this.canScrollUp = octave < 3;
            this.canScrollDown = octave > -3;
            this.canScrollLeft = false;
            this.canScrollRight = false;
            return;
        }
        if (viewManager.isActiveView(Views.VIEW_DRUM)) {
            int octave = this.model.getScales().getDrumOctave();
            this.canScrollUp = octave < 5;
            this.canScrollDown = octave > -3;
            this.canScrollLeft = this.model.getCursorClip().getEditPage() > 0;
            this.canScrollRight = true;
            return;
        }
        if (viewManager.isActiveView(Views.VIEW_DRUM64)) {
            DrumView64 drumView64 = (DrumView64)viewManager.getView(Views.VIEW_DRUM64);
            int octave = drumView64.getDrumOctave();
            this.canScrollUp = octave < 1;
            this.canScrollDown = octave > -2;
            this.canScrollLeft = false;
            this.canScrollRight = false;
            return;
        }
        if (viewManager.isActiveView(Views.VIEW_SEQUENCER) || viewManager.isActiveView(Views.VIEW_RAINDROPS)) {
            int octave = this.model.getScales().getOctave();
            this.canScrollUp = octave < 4;
            this.canScrollDown = octave > -4;
            this.canScrollLeft = this.model.getCursorClip().getEditPage() > 0;
            this.canScrollRight = true;
            return;
        }
        if (viewManager.isActiveView(Views.VIEW_DEVICE)) {
            ICursorDevice cursorDevice = this.model.getCursorDevice();
            this.canScrollUp = cursorDevice.canSelectNextFX();
            this.canScrollDown = cursorDevice.canSelectPreviousFX();
            this.canScrollLeft = cursorDevice.hasPreviousParameterPage();
            this.canScrollRight = cursorDevice.hasNextParameterPage();
            return;
        }
        if (viewManager.isActiveView(Views.VIEW_BROWSER)) {
            IBrowser browser = this.model.getBrowser();
            this.canScrollUp = false;
            this.canScrollDown = false;
            this.canScrollLeft = browser.hasPreviousContentType();
            this.canScrollRight = browser.hasNextContentType();
            return;
        }
        if (viewManager.isActiveView(Views.VIEW_SHIFT) || viewManager.isActiveView(Views.VIEW_DRUM4) || viewManager.isActiveView(Views.VIEW_DRUM8)) {
            this.canScrollUp = false;
            this.canScrollDown = false;
            this.canScrollLeft = false;
            this.canScrollRight = false;
            return;
        }
        ITrack sel = tb.getSelectedTrack();
        int selIndex = sel != null ? sel.getIndex() : -1;
        this.canScrollLeft = selIndex > 0 || tb.canScrollTracksUp();
        this.canScrollRight = selIndex >= 0 && selIndex < 7 && tb.getTrack(selIndex + 1).doesExist() || tb.canScrollTracksDown();
        this.canScrollUp = tb.canScrollScenesUp();
        this.canScrollDown = tb.canScrollScenesDown();
    }

    @Override
    protected int getButtonOnColor() {
        ViewManager viewManager = ((LaunchpadControlSurface)this.surface).getViewManager();
        if (viewManager.isActiveView(Views.VIEW_SESSION) || viewManager.isActiveView(Views.VIEW_VOLUME) || viewManager.isActiveView(Views.VIEW_PAN) || viewManager.isActiveView(Views.VIEW_SENDS)) {
            return 18;
        }
        if (viewManager.isActiveView(Views.VIEW_RAINDROPS)) {
            return 22;
        }
        if (viewManager.isActiveView(Views.VIEW_SEQUENCER)) {
            return 46;
        }
        if (viewManager.isActiveView(Views.VIEW_DEVICE)) {
            return 10;
        }
        if (viewManager.isActiveView(Views.VIEW_DRUM) || viewManager.isActiveView(Views.VIEW_DRUM4) || viewManager.isActiveView(Views.VIEW_DRUM8) || viewManager.isActiveView(Views.VIEW_DRUM64)) {
            return 14;
        }
        if (viewManager.isActiveView(Views.VIEW_BROWSER)) {
            return 30;
        }
        return 41;
    }

    @Override
    protected void scrollLeft() {
        ViewManager viewManager = ((LaunchpadControlSurface)this.surface).getViewManager();
        if (viewManager.isActiveView(Views.VIEW_PLAY)) {
            Scales scales = this.model.getScales();
            scales.prevScale();
            String name = scales.getScale().getName();
            ((LaunchpadConfiguration)((LaunchpadControlSurface)this.surface).getConfiguration()).setScale(name);
            ((LaunchpadControlSurface)this.surface).getDisplay().notify(name);
            return;
        }
        if (viewManager.isActiveView(Views.VIEW_DEVICE)) {
            ICursorDevice cursorDevice = this.model.getCursorDevice();
            cursorDevice.previousParameterPage();
            ((LaunchpadControlSurface)this.surface).getDisplay().notify(cursorDevice.getSelectedParameterPageName());
            return;
        }
        if (viewManager.isActiveView(Views.VIEW_BROWSER)) {
            this.model.getBrowser().previousContentType();
            return;
        }
        if (viewManager.isActiveView(Views.VIEW_SHIFT) || viewManager.isActiveView(Views.VIEW_DRUM64)) {
            return;
        }
        View activeView = viewManager.getActiveView();
        if (activeView instanceof AbstractSequencerView) {
            ((AbstractSequencerView)activeView).onLeft(ButtonEvent.DOWN);
            return;
        }
        this.scrollTracksLeft();
    }

    @Override
    protected void scrollRight() {
        ViewManager viewManager = ((LaunchpadControlSurface)this.surface).getViewManager();
        if (viewManager.isActiveView(Views.VIEW_PLAY)) {
            Scales scales = this.model.getScales();
            scales.nextScale();
            String name = scales.getScale().getName();
            ((LaunchpadConfiguration)((LaunchpadControlSurface)this.surface).getConfiguration()).setScale(name);
            ((LaunchpadControlSurface)this.surface).getDisplay().notify(name);
            return;
        }
        if (viewManager.isActiveView(Views.VIEW_DEVICE)) {
            ICursorDevice cursorDevice = this.model.getCursorDevice();
            cursorDevice.nextParameterPage();
            ((LaunchpadControlSurface)this.surface).getDisplay().notify(cursorDevice.getSelectedParameterPageName());
            return;
        }
        if (viewManager.isActiveView(Views.VIEW_BROWSER)) {
            this.model.getBrowser().nextContentType();
            return;
        }
        if (viewManager.isActiveView(Views.VIEW_SHIFT) || viewManager.isActiveView(Views.VIEW_DRUM64)) {
            return;
        }
        View activeView = viewManager.getActiveView();
        if (activeView instanceof AbstractSequencerView) {
            ((AbstractSequencerView)activeView).onRight(ButtonEvent.DOWN);
            return;
        }
        this.scrollTracksRight();
    }

    @Override
    protected void scrollUp() {
        ViewManager viewManager = ((LaunchpadControlSurface)this.surface).getViewManager();
        if (viewManager.isActiveView(Views.VIEW_PLAY) || viewManager.isActiveView(Views.VIEW_PIANO)) {
            ((PlayView)viewManager.getView(Views.VIEW_PLAY)).onOctaveUp(ButtonEvent.DOWN);
            return;
        }
        if (viewManager.isActiveView(Views.VIEW_DRUM)) {
            ((DrumView)viewManager.getView(Views.VIEW_DRUM)).onOctaveUp(ButtonEvent.DOWN);
            return;
        }
        if (viewManager.isActiveView(Views.VIEW_DRUM64)) {
            ((DrumView64)viewManager.getView(Views.VIEW_DRUM64)).onOctaveUp(ButtonEvent.DOWN);
            return;
        }
        if (viewManager.isActiveView(Views.VIEW_SEQUENCER)) {
            ((SequencerView)viewManager.getView(Views.VIEW_SEQUENCER)).onOctaveUp(ButtonEvent.DOWN);
            return;
        }
        if (viewManager.isActiveView(Views.VIEW_RAINDROPS)) {
            ((RaindropsView)viewManager.getView(Views.VIEW_RAINDROPS)).onOctaveUp(ButtonEvent.DOWN);
            return;
        }
        if (viewManager.isActiveView(Views.VIEW_DEVICE)) {
            this.model.getCursorDevice().selectNext();
            return;
        }
        if (viewManager.isActiveView(Views.VIEW_BROWSER) || viewManager.isActiveView(Views.VIEW_SHIFT) || viewManager.isActiveView(Views.VIEW_DRUM4) || viewManager.isActiveView(Views.VIEW_DRUM8)) {
            return;
        }
        super.scrollUp();
    }

    @Override
    protected void scrollDown() {
        ViewManager viewManager = ((LaunchpadControlSurface)this.surface).getViewManager();
        if (viewManager.isActiveView(Views.VIEW_PLAY) || viewManager.isActiveView(Views.VIEW_PIANO)) {
            ((PlayView)viewManager.getView(Views.VIEW_PLAY)).onOctaveDown(ButtonEvent.DOWN);
            return;
        }
        if (viewManager.isActiveView(Views.VIEW_DRUM)) {
            ((DrumView)viewManager.getView(Views.VIEW_DRUM)).onOctaveDown(ButtonEvent.DOWN);
            return;
        }
        if (viewManager.isActiveView(Views.VIEW_DRUM64)) {
            ((DrumView64)viewManager.getView(Views.VIEW_DRUM64)).onOctaveDown(ButtonEvent.DOWN);
            return;
        }
        if (viewManager.isActiveView(Views.VIEW_SEQUENCER)) {
            ((SequencerView)viewManager.getView(Views.VIEW_SEQUENCER)).onOctaveDown(ButtonEvent.DOWN);
            return;
        }
        if (viewManager.isActiveView(Views.VIEW_RAINDROPS)) {
            ((RaindropsView)viewManager.getView(Views.VIEW_RAINDROPS)).onOctaveDown(ButtonEvent.DOWN);
            return;
        }
        if (viewManager.isActiveView(Views.VIEW_DEVICE)) {
            this.model.getCursorDevice().selectPrevious();
            return;
        }
        if (viewManager.isActiveView(Views.VIEW_BROWSER) || viewManager.isActiveView(Views.VIEW_SHIFT) || viewManager.isActiveView(Views.VIEW_DRUM4) || viewManager.isActiveView(Views.VIEW_DRUM8)) {
            return;
        }
        super.scrollDown();
    }

    @Override
    protected void delayedUpdateArrows() {
        if (((LaunchpadControlSurface)this.surface).isPro()) {
            ((LaunchpadControlSurface)this.surface).setButton(((LaunchpadControlSurface)this.surface).getLeftButtonId(), this.canScrollLeft ? this.getButtonOnColor() : this.getButtonOffColor());
            ((LaunchpadControlSurface)this.surface).setButton(((LaunchpadControlSurface)this.surface).getRightButtonId(), this.canScrollRight ? this.getButtonOnColor() : this.getButtonOffColor());
            ((LaunchpadControlSurface)this.surface).setButton(((LaunchpadControlSurface)this.surface).getUpButtonId(), this.canScrollUp ? this.getButtonOnColor() : this.getButtonOffColor());
            ((LaunchpadControlSurface)this.surface).setButton(((LaunchpadControlSurface)this.surface).getDownButtonId(), this.canScrollDown ? this.getButtonOnColor() : this.getButtonOffColor());
        } else {
            ((LaunchpadControlSurface)this.surface).updateButton(((LaunchpadControlSurface)this.surface).getLeftButtonId(), this.canScrollLeft ? this.getButtonOnColor() : this.getButtonOffColor());
            ((LaunchpadControlSurface)this.surface).updateButton(((LaunchpadControlSurface)this.surface).getRightButtonId(), this.canScrollRight ? this.getButtonOnColor() : this.getButtonOffColor());
            ((LaunchpadControlSurface)this.surface).updateButton(((LaunchpadControlSurface)this.surface).getUpButtonId(), this.canScrollUp ? this.getButtonOnColor() : this.getButtonOffColor());
            ((LaunchpadControlSurface)this.surface).updateButton(((LaunchpadControlSurface)this.surface).getDownButtonId(), this.canScrollDown ? this.getButtonOnColor() : this.getButtonOffColor());
        }
    }
}

