/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.launchpad.command.trigger;

import de.mossgrabers.controller.launchpad.LaunchpadConfiguration;
import de.mossgrabers.controller.launchpad.controller.LaunchpadControlSurface;
import de.mossgrabers.controller.launchpad.view.Views;
import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.mode.ModeManager;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.ViewManager;

public class AbstractTrackCommand
extends AbstractTriggerCommand<LaunchpadControlSurface, LaunchpadConfiguration> {
    private boolean firstRowUsed;
    private boolean temporaryView;

    public AbstractTrackCommand(IModel model, LaunchpadControlSurface surface) {
        super(model, surface);
    }

    protected void onModeButton(ButtonEvent event, Integer controlMode, String notification) {
        ModeManager modeManager = ((LaunchpadControlSurface)this.surface).getModeManager();
        switch (event) {
            case DOWN: {
                this.firstRowUsed = false;
                if (modeManager.isActiveMode(controlMode)) {
                    modeManager.setActiveMode(null);
                    return;
                }
                modeManager.setActiveMode(controlMode);
                ((LaunchpadControlSurface)this.surface).getViewManager().setActiveView(Views.VIEW_SESSION);
                ((LaunchpadControlSurface)this.surface).getDisplay().notify(notification);
                break;
            }
            case LONG: {
                this.firstRowUsed = true;
                break;
            }
            case UP: {
                if (!this.firstRowUsed) break;
                modeManager.setActiveMode(null);
            }
        }
    }

    protected void onFaderModeButton(ButtonEvent event, Integer view, String notification) {
        ViewManager viewManager = ((LaunchpadControlSurface)this.surface).getViewManager();
        switch (event) {
            case DOWN: {
                if (viewManager.isActiveView(view)) {
                    viewManager.restoreView();
                    return;
                }
                this.temporaryView = false;
                ((LaunchpadControlSurface)this.surface).getModeManager().setActiveMode(null);
                viewManager.setActiveView(view);
                ((LaunchpadControlSurface)this.surface).getDisplay().notify(notification);
                break;
            }
            case LONG: {
                this.temporaryView = true;
                break;
            }
            case UP: {
                if (!this.temporaryView) break;
                viewManager.restoreView();
            }
        }
    }
}

