/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.launchpad;

import de.mossgrabers.controller.launchpad.LaunchpadConfiguration;
import de.mossgrabers.controller.launchpad.command.continuous.FaderCommand;
import de.mossgrabers.controller.launchpad.command.trigger.ClickCommand;
import de.mossgrabers.controller.launchpad.command.trigger.DoubleCommand;
import de.mossgrabers.controller.launchpad.command.trigger.LPSceneCommand;
import de.mossgrabers.controller.launchpad.command.trigger.LaunchpadCursorCommand;
import de.mossgrabers.controller.launchpad.command.trigger.LaunchpadDuplicateCommand;
import de.mossgrabers.controller.launchpad.command.trigger.MuteCommand;
import de.mossgrabers.controller.launchpad.command.trigger.PanCommand;
import de.mossgrabers.controller.launchpad.command.trigger.RecordArmCommand;
import de.mossgrabers.controller.launchpad.command.trigger.SelectDeviceViewCommand;
import de.mossgrabers.controller.launchpad.command.trigger.SelectNoteViewCommand;
import de.mossgrabers.controller.launchpad.command.trigger.SelectSessionViewCommand;
import de.mossgrabers.controller.launchpad.command.trigger.SendsCommand;
import de.mossgrabers.controller.launchpad.command.trigger.ShiftCommand;
import de.mossgrabers.controller.launchpad.command.trigger.SoloCommand;
import de.mossgrabers.controller.launchpad.command.trigger.StopClipCommand;
import de.mossgrabers.controller.launchpad.command.trigger.TrackSelectCommand;
import de.mossgrabers.controller.launchpad.command.trigger.VolumeCommand;
import de.mossgrabers.controller.launchpad.controller.LaunchpadColors;
import de.mossgrabers.controller.launchpad.controller.LaunchpadControlSurface;
import de.mossgrabers.controller.launchpad.controller.LaunchpadScales;
import de.mossgrabers.controller.launchpad.mode.Modes;
import de.mossgrabers.controller.launchpad.mode.MuteMode;
import de.mossgrabers.controller.launchpad.mode.PanMode;
import de.mossgrabers.controller.launchpad.mode.RecArmMode;
import de.mossgrabers.controller.launchpad.mode.SendMode;
import de.mossgrabers.controller.launchpad.mode.SoloMode;
import de.mossgrabers.controller.launchpad.mode.StopClipMode;
import de.mossgrabers.controller.launchpad.mode.TrackMode;
import de.mossgrabers.controller.launchpad.mode.VolumeMode;
import de.mossgrabers.controller.launchpad.view.BrowserView;
import de.mossgrabers.controller.launchpad.view.DeviceView;
import de.mossgrabers.controller.launchpad.view.DrumView;
import de.mossgrabers.controller.launchpad.view.DrumView4;
import de.mossgrabers.controller.launchpad.view.DrumView64;
import de.mossgrabers.controller.launchpad.view.DrumView8;
import de.mossgrabers.controller.launchpad.view.PanView;
import de.mossgrabers.controller.launchpad.view.PianoView;
import de.mossgrabers.controller.launchpad.view.PlayView;
import de.mossgrabers.controller.launchpad.view.RaindropsView;
import de.mossgrabers.controller.launchpad.view.SendsView;
import de.mossgrabers.controller.launchpad.view.SequencerView;
import de.mossgrabers.controller.launchpad.view.SessionView;
import de.mossgrabers.controller.launchpad.view.ShiftView;
import de.mossgrabers.controller.launchpad.view.Views;
import de.mossgrabers.controller.launchpad.view.VolumeView;
import de.mossgrabers.framework.command.Commands;
import de.mossgrabers.framework.command.aftertouch.AftertouchAbstractPlayViewCommand;
import de.mossgrabers.framework.command.trigger.CursorCommand;
import de.mossgrabers.framework.command.trigger.NopCommand;
import de.mossgrabers.framework.command.trigger.application.DeleteCommand;
import de.mossgrabers.framework.command.trigger.application.UndoCommand;
import de.mossgrabers.framework.command.trigger.clip.NewCommand;
import de.mossgrabers.framework.command.trigger.clip.QuantizeCommand;
import de.mossgrabers.framework.command.trigger.transport.PlayCommand;
import de.mossgrabers.framework.command.trigger.transport.RecordCommand;
import de.mossgrabers.framework.configuration.ISettingsUI;
import de.mossgrabers.framework.controller.AbstractControllerSetup;
import de.mossgrabers.framework.controller.DefaultValueChanger;
import de.mossgrabers.framework.controller.ISetupFactory;
import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.controller.display.DummyDisplay;
import de.mossgrabers.framework.daw.DAWColors;
import de.mossgrabers.framework.daw.IChannelBank;
import de.mossgrabers.framework.daw.ICursorDevice;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.ITrackBank;
import de.mossgrabers.framework.daw.ITransport;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.midi.IMidiAccess;
import de.mossgrabers.framework.daw.midi.IMidiInput;
import de.mossgrabers.framework.daw.midi.IMidiOutput;
import de.mossgrabers.framework.mode.ModeManager;
import de.mossgrabers.framework.utils.StringUtils;
import de.mossgrabers.framework.view.SceneView;
import de.mossgrabers.framework.view.View;
import de.mossgrabers.framework.view.ViewManager;

public class LaunchpadControllerSetup
extends AbstractControllerSetup<LaunchpadControlSurface, LaunchpadConfiguration> {
    private final boolean isPro;
    private int frontColor = -1;

    public LaunchpadControllerSetup(IHost host, ISetupFactory factory, ISettingsUI settings, boolean isPro) {
        super(factory, host, settings);
        this.isPro = isPro;
        this.colorManager = new ColorManager();
        LaunchpadColors.addColors(this.colorManager);
        this.valueChanger = new DefaultValueChanger(128, 1, 0.5);
        this.configuration = new LaunchpadConfiguration(this.valueChanger, isPro);
    }

    @Override
    public void flush() {
        this.flushSurfaces();
        this.updateButtons();
    }

    @Override
    protected void createScales() {
        this.scales = new LaunchpadScales(this.valueChanger, 36, 100, 8, 8);
    }

    @Override
    protected void createModel() {
        this.model = this.factory.createModel(this.colorManager, this.valueChanger, this.scales, 8, 8, 8, 16, 16, true, -1, -1, -1, -1);
        ITrackBank trackBank = this.model.getTrackBank();
        trackBank.addTrackSelectionObserver(this::handleTrackChange);
    }

    @Override
    protected void createSurface() {
        IMidiAccess midiAccess = this.factory.createMidiAccess();
        IMidiOutput output = midiAccess.createOutput();
        IMidiInput input = midiAccess.createInput(this.isPro ? "Novation Launchpad Pro" : "Novation Launchpad MkII", "80????", "90????");
        LaunchpadControlSurface surface = new LaunchpadControlSurface(this.model.getHost(), this.colorManager, (LaunchpadConfiguration)this.configuration, output, input, this.isPro);
        this.surfaces.add(surface);
        surface.setDisplay(new DummyDisplay(this.host));
        surface.setLaunchpadToStandalone();
    }

    @Override
    protected void createObservers() {
        ((LaunchpadControlSurface)this.getSurface()).getViewManager().addViewChangeListener((previousViewId, activeViewId) -> this.updateIndication());
        this.createScaleObservers(this.configuration);
    }

    @Override
    protected void createModes() {
        LaunchpadControlSurface surface = (LaunchpadControlSurface)this.getSurface();
        ModeManager modeManager = surface.getModeManager();
        modeManager.registerMode(Modes.MODE_REC_ARM, new RecArmMode(surface, this.model));
        modeManager.registerMode(Modes.MODE_TRACK_SELECT, new TrackMode(surface, this.model));
        modeManager.registerMode(Modes.MODE_MUTE, new MuteMode(surface, this.model));
        modeManager.registerMode(Modes.MODE_SOLO, new SoloMode(surface, this.model));
        modeManager.registerMode(Modes.MODE_VOLUME, new VolumeMode(surface, this.model));
        modeManager.registerMode(Modes.MODE_PAN, new PanMode(surface, this.model));
        modeManager.registerMode(Modes.MODE_SENDS, new SendMode(surface, this.model));
        modeManager.registerMode(Modes.MODE_STOP_CLIP, new StopClipMode(surface, this.model));
    }

    @Override
    protected void createViews() {
        LaunchpadControlSurface surface = (LaunchpadControlSurface)this.getSurface();
        ViewManager viewManager = surface.getViewManager();
        viewManager.registerView(Views.VIEW_BROWSER, new BrowserView(surface, this.model));
        viewManager.registerView(Views.VIEW_DEVICE, new DeviceView(surface, this.model));
        viewManager.registerView(Views.VIEW_DRUM, new DrumView(surface, this.model));
        viewManager.registerView(Views.VIEW_DRUM4, new DrumView4(surface, this.model));
        viewManager.registerView(Views.VIEW_DRUM8, new DrumView8(surface, this.model));
        viewManager.registerView(Views.VIEW_PAN, new PanView(surface, this.model));
        viewManager.registerView(Views.VIEW_DRUM64, new DrumView64(surface, this.model));
        viewManager.registerView(Views.VIEW_PLAY, new PlayView(surface, this.model));
        viewManager.registerView(Views.VIEW_PIANO, new PianoView(surface, this.model));
        viewManager.registerView(Views.VIEW_RAINDROPS, new RaindropsView(surface, this.model));
        viewManager.registerView(Views.VIEW_SENDS, new SendsView(surface, this.model));
        viewManager.registerView(Views.VIEW_SEQUENCER, new SequencerView(surface, this.model));
        viewManager.registerView(Views.VIEW_SESSION, new SessionView(surface, this.model));
        viewManager.registerView(Views.VIEW_VOLUME, new VolumeView(surface, this.model));
        viewManager.registerView(Views.VIEW_SHIFT, new ShiftView(surface, this.model));
    }

    @Override
    protected void registerTriggerCommands() {
        LaunchpadControlSurface surface = (LaunchpadControlSurface)this.getSurface();
        ViewManager viewManager = surface.getViewManager();
        viewManager.registerTriggerCommand(Commands.COMMAND_SHIFT, new ShiftCommand(this.model, surface));
        surface.assignTriggerCommand(80, Commands.COMMAND_SHIFT);
        surface.assignTriggerCommand(111, Commands.COMMAND_SHIFT);
        this.addTriggerCommand(Commands.COMMAND_METRONOME, 70, new ClickCommand(this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_UNDO, 60, new UndoCommand(this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_DELETE, 50, new DeleteCommand(this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_QUANTIZE, 40, new QuantizeCommand(this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_DUPLICATE, 30, new LaunchpadDuplicateCommand(this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_DOUBLE, 20, new DoubleCommand(this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_RECORD, 10, new RecordCommand(this.model, surface));
        viewManager.registerTriggerCommand(Commands.COMMAND_PLAY, new PlayCommand(this.model, surface));
        viewManager.registerTriggerCommand(Commands.COMMAND_NEW, new NewCommand(this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_SELECT_SESSION_VIEW, surface.getSessionButton(), new SelectSessionViewCommand(this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_SELECT_PLAY_VIEW, surface.getNoteButton(), new SelectNoteViewCommand(this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_DEVICE, surface.getDeviceButton(), new SelectDeviceViewCommand(this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_REC_ARM, 1, new RecordArmCommand(this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_TRACK, 2, new TrackSelectCommand(this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_MUTE, 3, new MuteCommand(this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_SOLO, 4, new SoloCommand(this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_VOLUME, 5, new VolumeCommand(this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_PAN_SEND, 6, new PanCommand(this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_SENDS, 7, new SendsCommand(this.model, surface));
        if (this.host.hasClips()) {
            this.addTriggerCommand(Commands.COMMAND_STOP_CLIP, 8, new StopClipCommand(this.model, surface));
        } else {
            this.addTriggerCommand(Commands.COMMAND_STOP_CLIP, 8, new NopCommand(this.model, surface));
        }
        this.addTriggerCommand(Commands.COMMAND_ARROW_DOWN, surface.getDownButtonId(), new LaunchpadCursorCommand(CursorCommand.Direction.DOWN, this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_ARROW_UP, surface.getUpButtonId(), new LaunchpadCursorCommand(CursorCommand.Direction.UP, this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_ARROW_LEFT, surface.getLeftButtonId(), new LaunchpadCursorCommand(CursorCommand.Direction.LEFT, this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_ARROW_RIGHT, surface.getRightButtonId(), new LaunchpadCursorCommand(CursorCommand.Direction.RIGHT, this.model, surface));
        if (this.isPro) {
            this.addTriggerCommand(Commands.COMMAND_SCENE1, 89, new LPSceneCommand(7, this.model, surface));
            this.addTriggerCommand(Commands.COMMAND_SCENE2, 79, new LPSceneCommand(6, this.model, surface));
            this.addTriggerCommand(Commands.COMMAND_SCENE3, 69, new LPSceneCommand(5, this.model, surface));
            this.addTriggerCommand(Commands.COMMAND_SCENE4, 59, new LPSceneCommand(4, this.model, surface));
            this.addTriggerCommand(Commands.COMMAND_SCENE5, 49, new LPSceneCommand(3, this.model, surface));
            this.addTriggerCommand(Commands.COMMAND_SCENE6, 39, new LPSceneCommand(2, this.model, surface));
            this.addTriggerCommand(Commands.COMMAND_SCENE7, 29, new LPSceneCommand(1, this.model, surface));
            this.addTriggerCommand(Commands.COMMAND_SCENE8, 19, new LPSceneCommand(0, this.model, surface));
        } else {
            this.addNoteCommand(Commands.COMMAND_SCENE1, 89, new LPSceneCommand(7, this.model, surface));
            this.addNoteCommand(Commands.COMMAND_SCENE2, 79, new LPSceneCommand(6, this.model, surface));
            this.addNoteCommand(Commands.COMMAND_SCENE3, 69, new LPSceneCommand(5, this.model, surface));
            this.addNoteCommand(Commands.COMMAND_SCENE4, 59, new LPSceneCommand(4, this.model, surface));
            this.addNoteCommand(Commands.COMMAND_SCENE5, 49, new LPSceneCommand(3, this.model, surface));
            this.addNoteCommand(Commands.COMMAND_SCENE6, 39, new LPSceneCommand(2, this.model, surface));
            this.addNoteCommand(Commands.COMMAND_SCENE7, 29, new LPSceneCommand(1, this.model, surface));
            this.addNoteCommand(Commands.COMMAND_SCENE8, 19, new LPSceneCommand(0, this.model, surface));
        }
    }

    @Override
    protected void registerContinuousCommands() {
        LaunchpadControlSurface surface = (LaunchpadControlSurface)this.getSurface();
        for (int i = 0; i < 8; ++i) {
            this.addContinuousCommand(Commands.CONT_COMMAND_KNOB1 + i, 21 + i, new FaderCommand(i, this.model, surface));
        }
        ViewManager viewManager = surface.getViewManager();
        PlayView playView = (PlayView)viewManager.getView(Views.VIEW_PLAY);
        playView.registerAftertouchCommand(new AftertouchAbstractPlayViewCommand<LaunchpadControlSurface, LaunchpadConfiguration>(playView, this.model, surface));
        PianoView pianoView = (PianoView)viewManager.getView(Views.VIEW_PIANO);
        pianoView.registerAftertouchCommand(new AftertouchAbstractPlayViewCommand<LaunchpadControlSurface, LaunchpadConfiguration>(pianoView, this.model, surface));
    }

    @Override
    public void startup() {
        ((LaunchpadControlSurface)this.getSurface()).getViewManager().setActiveView(Views.VIEW_PLAY);
    }

    private void updateButtons() {
        int color;
        LaunchpadControlSurface surface = (LaunchpadControlSurface)this.getSurface();
        ViewManager viewManager = surface.getViewManager();
        View activeView = viewManager.getActiveView();
        if (activeView != null) {
            ((LaunchpadCursorCommand)activeView.getTriggerCommand(Commands.COMMAND_ARROW_DOWN)).updateArrows();
            ((SceneView)((Object)activeView)).updateSceneButtons();
        }
        if (!this.isPro) {
            surface.setButton(111, surface.isUserPressed() ? 3 : 1);
            return;
        }
        surface.setButton(98, 0);
        boolean isShift = surface.isShiftPressed();
        ITrack selTrack = this.model.getSelectedTrack();
        int index = selTrack == null ? -1 : selTrack.getIndex();
        ModeManager modeManager = surface.getModeManager();
        ITransport transport = this.model.getTransport();
        surface.setButton(80, isShift ? 3 : 1);
        surface.setButton(70, isShift ? 24 : (transport.isMetronomeOn() ? 21 : 23));
        surface.setButton(60, isShift ? 24 : 23);
        surface.setButton(50, isShift ? 0 : 23);
        surface.setButton(40, isShift ? 0 : 23);
        surface.setButton(30, isShift ? 24 : 23);
        surface.setButton(20, isShift ? 24 : 23);
        boolean flipRecord = ((LaunchpadConfiguration)surface.getConfiguration()).isFlipRecord();
        surface.setButton(10, isShift && !flipRecord || !isShift && flipRecord ? (transport.isLauncherOverdub() ? 4 : 8) : (transport.isRecording() ? 5 : 7));
        surface.setButton(1, modeManager.isActiveMode(Modes.MODE_REC_ARM) ? 6 : (index == 0 ? 3 : 1));
        surface.setButton(2, modeManager.isActiveMode(Modes.MODE_TRACK_SELECT) ? 22 : (index == 1 ? 3 : 1));
        surface.setButton(3, modeManager.isActiveMode(Modes.MODE_MUTE) ? 14 : (index == 2 ? 3 : 1));
        surface.setButton(4, modeManager.isActiveMode(Modes.MODE_SOLO) ? 46 : (index == 3 ? 3 : 1));
        surface.setButton(5, viewManager.isActiveView(Views.VIEW_VOLUME) ? 34 : (index == 4 ? 3 : 1));
        surface.setButton(6, viewManager.isActiveView(Views.VIEW_PAN) ? 38 : (index == 5 ? 3 : 1));
        surface.setButton(7, viewManager.isActiveView(Views.VIEW_SENDS) ? 50 : (index == 6 ? 3 : 1));
        surface.setButton(8, modeManager.isActiveMode(Modes.MODE_STOP_CLIP) ? 4 : (index == 7 ? 3 : 1));
        ITrack track = index == -1 ? null : this.model.getCurrentTrackBank().getTrack(index);
        int n = color = track != null && track.doesExist() ? this.colorManager.getColor(DAWColors.getColorIndex(track.getColor())) : 0;
        if (color != this.frontColor) {
            surface.sendLaunchpadSysEx("0A 63 " + StringUtils.toHexStr(color));
            this.frontColor = color;
        }
    }

    private void updateIndication() {
        ViewManager viewManager = ((LaunchpadControlSurface)this.getSurface()).getViewManager();
        boolean isVolume = viewManager.isActiveView(Views.VIEW_VOLUME);
        boolean isPan = viewManager.isActiveView(Views.VIEW_PAN);
        boolean isSends = viewManager.isActiveView(Views.VIEW_SENDS);
        boolean isDevice = viewManager.isActiveView(Views.VIEW_DEVICE);
        ITrackBank tb = this.model.getTrackBank();
        IChannelBank tbe = this.model.getEffectTrackBank();
        ICursorDevice cursorDevice = this.model.getCursorDevice();
        View view = viewManager.getActiveView();
        int selSend = view instanceof SendsView ? ((SendsView)view).getSelectedSend() : -1;
        boolean isSession = view instanceof SessionView && !isVolume && !isPan && !isSends;
        boolean isEffect = this.model.isEffectTrackBankActive();
        tb.setIndication(!isEffect && isSession);
        if (tbe != null) {
            tbe.setIndication(isEffect && isSession);
        }
        for (int i = 0; i < 8; ++i) {
            ITrack track = tb.getTrack(i);
            track.setVolumeIndication(!isEffect && isVolume);
            track.setPanIndication(!isEffect && isPan);
            for (int j = 0; j < 8; ++j) {
                track.getSend(j).setIndication(!isEffect && isSends && selSend == j);
            }
            if (tbe != null) {
                ITrack fxTrack = tbe.getTrack(i);
                fxTrack.setVolumeIndication(isEffect && isVolume);
                fxTrack.setPanIndication(isEffect && isPan);
            }
            cursorDevice.indicateParameter(i, isDevice);
        }
    }

    private void handleTrackChange(int index, boolean isSelected) {
        ITrack selectedTrack;
        if (!isSelected) {
            return;
        }
        ViewManager viewManager = ((LaunchpadControlSurface)this.getSurface()).getViewManager();
        if (!viewManager.isActiveView(Views.VIEW_SESSION) && (selectedTrack = this.model.getSelectedTrack()) != null) {
            Integer preferredView = viewManager.getPreferredView(selectedTrack.getPosition());
            viewManager.setActiveView(preferredView == null ? Views.VIEW_PLAY : preferredView);
        }
        if (viewManager.isActiveView(Views.VIEW_PLAY)) {
            viewManager.getActiveView().updateNoteMapping();
        }
        this.scales.setDrumOctave(0);
        if (viewManager.isActiveView(Views.VIEW_DRUM)) {
            viewManager.getView(Views.VIEW_DRUM).updateNoteMapping();
        }
    }
}

