/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.kontrol.usb.mkii.mode;

import de.mossgrabers.controller.kontrol.usb.mkii.Kontrol2Configuration;
import de.mossgrabers.controller.kontrol.usb.mkii.controller.Kontrol2ControlSurface;
import de.mossgrabers.controller.kontrol.usb.mkii.controller.Kontrol2Display;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.mode.AbstractMode;
import de.mossgrabers.framework.scale.Scales;
import de.mossgrabers.framework.utils.ButtonEvent;

public class ScaleMode
extends AbstractMode<Kontrol2ControlSurface, Kontrol2Configuration> {
    final Scales scales;

    public ScaleMode(Kontrol2ControlSurface surface, IModel model) {
        super(surface, model);
        this.isTemporary = true;
        this.scales = this.model.getScales();
    }

    @Override
    public void updateDisplay() {
        Kontrol2Display d = (Kontrol2Display)((Kontrol2ControlSurface)this.surface).getDisplay();
        d.clear();
        d.setCell(0, 0, "SCALE");
        Scales scales = this.model.getScales();
        d.setCell(0, 1, "SCALE").setCell(1, 1, scales.getScale().getName().toUpperCase());
        d.setCell(0, 2, "BASE").setCell(1, 2, Scales.BASES[scales.getScaleOffset()]);
        d.setCell(0, 3, "CHROMATC").setCell(1, 3, scales.isChromatic() ? "On" : "Off");
        d.allDone();
    }

    @Override
    public void onValueKnob(int index, int value) {
        boolean isInc = value <= 63;
        switch (index) {
            case 0: {
                if (isInc) {
                    this.scales.nextScale();
                } else {
                    this.scales.prevScale();
                }
                this.updateScalePreferences();
                break;
            }
            case 1: {
                if (isInc) {
                    this.scales.setScaleOffset(this.scales.getScaleOffset() + 1);
                } else {
                    this.scales.setScaleOffset(this.scales.getScaleOffset() - 1);
                }
                this.updateScalePreferences();
                break;
            }
            case 2: {
                if (isInc) {
                    this.scales.setChromatic(true);
                } else {
                    this.scales.setChromatic(false);
                }
                this.updateScalePreferences();
            }
        }
    }

    @Override
    public void onRowButton(int row, int index, ButtonEvent event) {
    }

    private void updateScalePreferences() {
        Kontrol2Configuration config = (Kontrol2Configuration)((Kontrol2ControlSurface)this.surface).getConfiguration();
        config.setScale(this.scales.getScale().getName());
        config.setScaleBase(Scales.BASES[this.scales.getScaleOffset()]);
        config.setScaleInKey(!this.scales.isChromatic());
    }
}

