/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.kontrol.usb.mkii.controller;

import de.mossgrabers.controller.kontrol.usb.mkii.controller.UIChangeCallback;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.IMemoryBlock;
import de.mossgrabers.framework.usb.IUSBDevice;
import de.mossgrabers.framework.usb.IUSBEndpoint;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class Kontrol2USBDevice {
    private static final int[] BYTE_0 = new int[]{1, 2, 3, 4, 5, 6, 7, 8};
    private static final int[] BYTE_1 = new int[]{9, 10, 11, 12, 13, 14, 15, 16};
    private static final int[] BYTE_2 = new int[]{17, 18, 19, 20, 21, 22, 23, 24};
    private static final int[] BYTE_3 = new int[]{25, 26, 27, 28, 29, 30, 31, 32};
    private static final int[] BYTE_4 = new int[]{33};
    private static final int[] TEST_BITS = new int[]{1, 2, 4, 8, 16, 32, 64, 128};
    private static final int DATA_SZ = 249;
    private static final int TIMEOUT = 1000;
    private static final int MESSAGE_SIZE = 49;
    private static final Map<Integer, Integer> LED_MAPPING = new HashMap<Integer, Integer>(21);
    private IHost host;
    private IUSBDevice usbDevice;
    private IUSBEndpoint usbEndpointDisplay;
    private IUSBEndpoint usbEndpointUI;
    private IMemoryBlock initBlock;
    private IMemoryBlock displayBlock;
    private IMemoryBlock uiBlock;
    private IMemoryBlock ledBlock;
    private IMemoryBlock keyLedBlock;
    private boolean busySendingDisplay = false;
    private boolean busySendingLEDs = false;
    private boolean busySendingKeyLEDs = false;
    private int mainEncoderValue;
    private int[] encoderValues = new int[8];
    private byte[] buttonStates = new byte[21];
    private byte[] oldButtonStates = new byte[21];
    private byte[] keyColors = new byte[264];
    private byte[] oldKeyColors = new byte[264];
    private boolean isFirstStateMsg = true;
    private UIChangeCallback callback;

    public Kontrol2USBDevice(IHost host) {
        this.host = host;
        try {
            this.usbDevice = host.getUsbDevice(0);
            this.usbEndpointUI = this.usbDevice.getEndpoint(0, 0);
            this.usbEndpointDisplay = this.usbDevice.getEndpoint(1, 0);
        }
        catch (RuntimeException ex) {
            this.usbDevice = null;
            this.usbEndpointDisplay = null;
            this.usbEndpointUI = null;
            host.error("Could not open USB connection: " + ex.getMessage());
        }
        this.displayBlock = host.createMemoryBlock(249);
        this.uiBlock = host.createMemoryBlock(1024);
        this.ledBlock = host.createMemoryBlock(26);
        this.keyLedBlock = host.createMemoryBlock(267);
        this.initBlock = host.createMemoryBlock(3);
        ByteBuffer initBuffer = this.initBlock.createByteBuffer();
        initBuffer.put((byte)-96);
        initBuffer.put((byte)0);
        initBuffer.put((byte)0);
        this.oldKeyColors[0] = -1;
    }

    public void setCallback(UIChangeCallback callback) {
        this.callback = callback;
    }

    public void init() {
        if (this.usbEndpointDisplay != null) {
            this.usbEndpointDisplay.send(this.initBlock, 1000);
        }
    }

    public void pollUI() {
        if (this.usbEndpointUI == null) {
            return;
        }
        this.usbEndpointUI.sendAsync(this.uiBlock, resultLength -> {
            if (resultLength > 0) {
                this.processMessage(resultLength);
            }
            this.uiBlock.createByteBuffer().clear();
            this.host.scheduleTask(this::pollUI, 10L);
        }, 1000);
    }

    public void sendDisplayData() {
        if (this.busySendingDisplay || this.usbEndpointDisplay == null) {
            return;
        }
    }

    public void shutdown() {
        this.usbEndpointDisplay = null;
    }

    public void setButtonLED(int buttonID, int intensity) {
        Integer pos = LED_MAPPING.get(buttonID);
        if (pos == null) {
            this.host.error("Illegal button LED: " + buttonID);
            return;
        }
        this.buttonStates[pos.intValue()] = (byte)intensity;
    }

    public void updateButtonLEDs() {
        if (this.usbEndpointDisplay == null) {
            return;
        }
        if (this.busySendingLEDs || Arrays.equals(this.oldButtonStates, this.buttonStates)) {
            return;
        }
        System.arraycopy(this.buttonStates, 0, this.oldButtonStates, 0, this.oldButtonStates.length);
        ByteBuffer ledBuffer = this.ledBlock.createByteBuffer();
        ledBuffer.clear();
        ledBuffer.put((byte)-128);
        ledBuffer.put(this.buttonStates);
        ledBuffer.put((byte)0);
        ledBuffer.put((byte)0);
        ledBuffer.put((byte)0);
        ledBuffer.put((byte)0);
        this.busySendingLEDs = true;
        this.usbEndpointDisplay.send(this.ledBlock, 1000);
        this.busySendingLEDs = false;
    }

    public void setKeyLED(int key, int red, int green, int blue) {
        if (key < 0 || key >= 88) {
            return;
        }
        int pos = 3 * key;
        this.keyColors[pos] = (byte)red;
        this.keyColors[pos + 1] = (byte)green;
        this.keyColors[pos + 2] = (byte)blue;
    }

    public void updateKeyLEDs() {
        if (this.usbEndpointDisplay == null) {
            return;
        }
        if (this.busySendingKeyLEDs || Arrays.equals(this.oldKeyColors, this.keyColors)) {
            return;
        }
        System.arraycopy(this.keyColors, 0, this.oldKeyColors, 0, this.oldKeyColors.length);
        ByteBuffer keyLedBuffer = this.keyLedBlock.createByteBuffer();
        keyLedBuffer.clear();
        keyLedBuffer.put((byte)-126);
        keyLedBuffer.put(this.keyColors);
        keyLedBuffer.put((byte)0);
        keyLedBuffer.put((byte)0);
        this.busySendingKeyLEDs = true;
        this.usbEndpointDisplay.send(this.keyLedBlock, 1000);
        this.busySendingKeyLEDs = false;
    }

    private void processMessage(int received) {
        ByteBuffer uiBuffer = this.uiBlock.createByteBuffer();
        byte[] dst = new byte[49];
        for (int i = 0; i < received / 49; ++i) {
            uiBuffer.get(dst);
            boolean encoderChange = false;
            int currentEncoderValue = Byte.toUnsignedInt(dst[6]);
            if (currentEncoderValue != this.mainEncoderValue) {
                boolean valueIncreased = (this.mainEncoderValue < currentEncoderValue || this.mainEncoderValue == 15 && currentEncoderValue == 0) && (this.mainEncoderValue != 0 || currentEncoderValue != 15);
                this.mainEncoderValue = currentEncoderValue;
                if (!this.isFirstStateMsg) {
                    this.callback.mainEncoderChanged(valueIncreased);
                }
                encoderChange = true;
            }
            int start = 7;
            for (int encIndex = 0; encIndex < 8; ++encIndex) {
                int pos = 7 + 2 * encIndex;
                int value = Byte.toUnsignedInt(dst[pos]) | Byte.toUnsignedInt(dst[pos + 1]) << 8;
                int hValue = Byte.toUnsignedInt(dst[pos + 1]);
                if (this.encoderValues[encIndex] == value) continue;
                int prevHValue = (this.encoderValues[encIndex] & 0xF00) >> 8;
                boolean valueIncreased = (this.encoderValues[encIndex] < value || prevHValue == 3 && hValue == 0) && (prevHValue != 0 || hValue != 3);
                this.encoderValues[encIndex] = value;
                if (!this.isFirstStateMsg) {
                    this.callback.encoderChanged(encIndex, valueIncreased);
                }
                encoderChange = true;
            }
            this.isFirstStateMsg = false;
            this.testByteForButtons(dst[1], BYTE_0);
            this.testByteForButtons(dst[2], BYTE_1);
            this.testByteForButtons(dst[3], BYTE_2);
            if (encoderChange) continue;
            this.testByteForButtons(dst[4], BYTE_3);
            this.testByteForButtons(dst[5], BYTE_4);
        }
    }

    private void testByteForButtons(byte b, int[] buttons) {
        if (this.callback == null) {
            return;
        }
        int t = Byte.toUnsignedInt(b);
        for (int i = 0; i < buttons.length; ++i) {
            this.callback.buttonChange(buttons[i], (t & TEST_BITS[i]) > 0);
        }
    }

    public void turnOffButtonLEDs() {
        for (Integer buttonLED : LED_MAPPING.values()) {
            this.buttonStates[buttonLED.intValue()] = 0;
        }
        this.updateButtonLEDs();
    }

    static {
        LED_MAPPING.put(17, 0);
        LED_MAPPING.put(18, 1);
        LED_MAPPING.put(19, 2);
        LED_MAPPING.put(20, 3);
        LED_MAPPING.put(23, 4);
        LED_MAPPING.put(24, 5);
        LED_MAPPING.put(11, 6);
        LED_MAPPING.put(10, 7);
        LED_MAPPING.put(9, 8);
        LED_MAPPING.put(22, 9);
        LED_MAPPING.put(21, 10);
        LED_MAPPING.put(5, 11);
        LED_MAPPING.put(2, 12);
        LED_MAPPING.put(6, 13);
        LED_MAPPING.put(4, 14);
        LED_MAPPING.put(15, 15);
        LED_MAPPING.put(16, 16);
        LED_MAPPING.put(3, 17);
        LED_MAPPING.put(14, 18);
        LED_MAPPING.put(13, 19);
        LED_MAPPING.put(12, 20);
    }
}

