/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.kontrol.usb.mkii.controller;

import de.mossgrabers.controller.kontrol.usb.mkii.Kontrol2Configuration;
import de.mossgrabers.controller.kontrol.usb.mkii.controller.Kontrol2USBDevice;
import de.mossgrabers.framework.controller.display.AbstractDisplay;
import de.mossgrabers.framework.controller.display.Display;
import de.mossgrabers.framework.controller.display.Format;
import de.mossgrabers.framework.daw.IHost;

public class Kontrol2Display
extends AbstractDisplay {
    private static final String[] SPACES = new String[]{"", " ", "  ", "   ", "    ", "     ", "      ", "       ", "        ", "         ", "          ", "           ", "            ", "             "};
    private Kontrol2USBDevice usbDevice;

    public Kontrol2Display(IHost host, Kontrol2Configuration configuration, Kontrol2USBDevice usbDevice) {
        super(host, null, 2, 9, 72);
        this.usbDevice = usbDevice;
    }

    @Override
    public void shutdown() {
        this.usbDevice.shutdown();
    }

    @Override
    public void flush() {
        super.flush();
        this.usbDevice.sendDisplayData();
    }

    @Override
    public AbstractDisplay clear() {
        return super.clear();
    }

    @Override
    public Kontrol2Display clearRow(int row) {
        for (int i = 0; i < this.noOfCells; ++i) {
            this.clearCell(row, i);
        }
        return this;
    }

    @Override
    public Kontrol2Display clearCell(int row, int cell) {
        this.cells[row * this.noOfCells + cell] = "        ";
        return this;
    }

    @Override
    public Kontrol2Display setBlock(int row, int block, String value) {
        int cell = 2 * block;
        if (value.length() > 9) {
            this.cells[row * this.noOfCells + cell] = value.substring(0, 9);
            this.cells[row * this.noOfCells + cell + 1] = Kontrol2Display.pad(value.substring(9), 8);
        } else {
            this.cells[row * this.noOfCells + cell] = Kontrol2Display.pad(value, 9);
            this.clearCell(row, cell + 1);
        }
        return this;
    }

    @Override
    public Display setCell(int row, int column, int value, Format format) {
        this.setCell(row, column, Integer.toString(value));
        return this;
    }

    @Override
    public Kontrol2Display setCell(int row, int cell, String value) {
        this.cells[row * this.noOfCells + cell] = Kontrol2Display.pad(value, 8);
        return this;
    }

    public static String pad(String str, int length) {
        String text = str == null ? "" : str;
        int diff = length - text.length();
        if (diff < 0) {
            return text.substring(0, length);
        }
        if (diff > 0) {
            return text + SPACES[diff];
        }
        return text;
    }

    @Override
    public void writeLine(int row, String text) {
    }
}

