/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.kontrol.usb.mkii.command.continuous;

import de.mossgrabers.controller.kontrol.usb.mkii.Kontrol2Configuration;
import de.mossgrabers.controller.kontrol.usb.mkii.controller.Kontrol2ControlSurface;
import de.mossgrabers.controller.kontrol.usb.mkii.mode.Modes;
import de.mossgrabers.controller.kontrol.usb.mkii.mode.device.BrowseMode;
import de.mossgrabers.framework.command.Commands;
import de.mossgrabers.framework.command.continuous.MasterVolumeCommand;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.mode.ModeManager;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.View;

public class MainEncoderCommand
extends MasterVolumeCommand<Kontrol2ControlSurface, Kontrol2Configuration> {
    public MainEncoderCommand(IModel model, Kontrol2ControlSurface surface) {
        super(model, surface);
    }

    @Override
    public void execute(int value) {
        if (((Kontrol2ControlSurface)this.surface).isShiftPressed()) {
            super.execute(value);
            return;
        }
        ModeManager modeManager = ((Kontrol2ControlSurface)this.surface).getModeManager();
        if (modeManager.isActiveMode(Modes.MODE_BROWSER)) {
            BrowseMode mode = (BrowseMode)modeManager.getMode(Modes.MODE_BROWSER);
            if (value > 64) {
                mode.selectPrevious(1);
            } else {
                mode.selectNext(1);
            }
            return;
        }
        View activeView = ((Kontrol2ControlSurface)this.surface).getViewManager().getActiveView();
        if (activeView == null) {
            return;
        }
        if (this.model.getValueChanger().calcKnobSpeed(value) > 0.0) {
            activeView.getTriggerCommand(Commands.COMMAND_ARROW_RIGHT).execute(ButtonEvent.DOWN);
        } else {
            activeView.getTriggerCommand(Commands.COMMAND_ARROW_LEFT).execute(ButtonEvent.DOWN);
        }
    }
}

