/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.kontrol.usb.mkii;

import de.mossgrabers.framework.controller.DefaultControllerDefinition;
import de.mossgrabers.framework.usb.USBMatcher;
import de.mossgrabers.framework.utils.OperatingSystem;
import de.mossgrabers.framework.utils.Pair;
import java.util.Collections;
import java.util.List;
import java.util.UUID;

public class Kontrol2ControllerDefinition
extends DefaultControllerDefinition {
    private static final UUID[] EXTENSION_ID = new UUID[]{UUID.fromString("845377d1-89d5-4d54-9df7-b7a2d4c26db2"), UUID.fromString("9adc174c-5957-4a5c-9698-83a91bd2b18b")};
    private static final String[] HARDWARE_MODEL = new String[]{"Komplete Kontrol S49 mk II (USB)", "Komplete Kontrol S61 mk II (USB)"};
    private static final short VENDOR_ID = 6092;
    private static final short[] PRODUCT_ID = new short[]{5648, 5664};
    private static final byte INTERFACE_NUMBER_HID = 2;
    private static final byte INTERFACE_NUMBER_DISPLAY = 3;
    private static final byte ENDPOINT_ADDRESS_HID = -126;
    private static final byte ENDPOINT_ADDRESS_DISPLAY = 3;
    private short productID;

    public Kontrol2ControllerDefinition(int modelIndex) {
        super("", "J\u00fcrgen Mo\u00dfgraber", "1.00", EXTENSION_ID[modelIndex], HARDWARE_MODEL[modelIndex], "Native Instruments", 1, 0);
        this.productID = PRODUCT_ID[modelIndex];
    }

    @Override
    public List<Pair<String[], String[]>> getMidiDiscoveryPairs(OperatingSystem os) {
        return Collections.singletonList(this.addDeviceDiscoveryPair("Komplete Kontrol - 2", null));
    }

    @Override
    public USBMatcher claimUSBDevice() {
        USBMatcher usbMatcher = new USBMatcher(6092, this.productID);
        usbMatcher.addEndpoint((byte)2, (byte)-126, false);
        usbMatcher.addEndpoint((byte)3, (byte)3, true);
        return usbMatcher;
    }
}

