/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.kontrol.usb.mkii;

import de.mossgrabers.framework.configuration.AbstractConfiguration;
import de.mossgrabers.framework.configuration.IEnumSetting;
import de.mossgrabers.framework.configuration.ISettingsUI;
import de.mossgrabers.framework.controller.IValueChanger;

public class Kontrol2Configuration
extends AbstractConfiguration {
    private static final Integer SCALE_IS_ACTIVE = 40;
    private IEnumSetting scaleIsActiveSetting;
    private boolean scaleIsActive;

    public Kontrol2Configuration(IValueChanger valueChanger) {
        super(valueChanger);
    }

    @Override
    public void init(ISettingsUI settingsUI) {
        this.scaleIsActiveSetting = settingsUI.getEnumSetting("Is active", "Scales", ON_OFF_OPTIONS, ON_OFF_OPTIONS[0]);
        this.scaleIsActiveSetting.addValueObserver(value -> {
            this.scaleIsActive = "On".equals(value);
            this.notifyObservers(SCALE_IS_ACTIVE);
        });
        this.activateScaleSetting(settingsUI);
        this.activateScaleBaseSetting(settingsUI);
        this.activateScaleInScaleSetting(settingsUI);
        this.activateBehaviourOnStopSetting(settingsUI);
        this.activateFlipRecordSetting(settingsUI);
        this.activateEnableVUMetersSetting(settingsUI);
    }

    public boolean isScaleIsActive() {
        return this.scaleIsActive;
    }

    public void toggleScaleIsActive() {
        this.scaleIsActiveSetting.set(ON_OFF_OPTIONS[this.scaleIsActive ? 0 : 1]);
    }
}

