/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.kontrol.usb.mki.view;

import de.mossgrabers.controller.kontrol.usb.mki.Kontrol1Configuration;
import de.mossgrabers.controller.kontrol.usb.mki.command.trigger.Kontrol1CursorCommand;
import de.mossgrabers.controller.kontrol.usb.mki.controller.Kontrol1ControlSurface;
import de.mossgrabers.controller.kontrol.usb.mki.mode.Modes;
import de.mossgrabers.framework.command.Commands;
import de.mossgrabers.framework.daw.IChannelBank;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.ITransport;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.mode.ModeManager;
import de.mossgrabers.framework.scale.Scale;
import de.mossgrabers.framework.view.AbstractView;
import de.mossgrabers.framework.view.View;

public class ControlView
extends AbstractView<Kontrol1ControlSurface, Kontrol1Configuration> {
    public ControlView(Kontrol1ControlSurface surface, IModel model) {
        super("Control", surface, model);
        this.scales = model.getScales();
    }

    @Override
    public void updateButtons() {
        double[] dArray;
        ModeManager modeManager = ((Kontrol1ControlSurface)this.surface).getModeManager();
        boolean isBrowseMode = modeManager.isActiveMode(Modes.MODE_BROWSER);
        ITransport transport = this.model.getTransport();
        IChannelBank currentTrackBank = this.model.getCurrentTrackBank();
        ITrack t = currentTrackBank.getSelectedTrack();
        Kontrol1Configuration configuration = (Kontrol1Configuration)((Kontrol1ControlSurface)this.surface).getConfiguration();
        ((Kontrol1ControlSurface)this.surface).updateButton(17, ((Kontrol1ControlSurface)this.surface).isShiftPressed() ? 255 : 6);
        ((Kontrol1ControlSurface)this.surface).updateButton(18, configuration.isScaleIsActive() ? 255 : 6);
        ((Kontrol1ControlSurface)this.surface).updateButton(19, ((Kontrol1ControlSurface)this.surface).isShiftPressed() && transport.isMetronomeTicksOn() || !((Kontrol1ControlSurface)this.surface).isShiftPressed() && transport.isMetronomeOn() ? 255 : 6);
        ((Kontrol1ControlSurface)this.surface).updateButton(20, transport.isLoop() ? 255 : 6);
        ((Kontrol1ControlSurface)this.surface).updateButton(23, ((Kontrol1ControlSurface)this.surface).isPressed(23) ? 255 : 6);
        ((Kontrol1ControlSurface)this.surface).updateButton(24, ((Kontrol1ControlSurface)this.surface).isPressed(24) ? 255 : 6);
        ((Kontrol1ControlSurface)this.surface).updateButton(11, transport.isPlaying() ? 255 : 6);
        ((Kontrol1ControlSurface)this.surface).updateButton(10, transport.isRecording() ? 255 : 6);
        ((Kontrol1ControlSurface)this.surface).updateButton(9, ((Kontrol1ControlSurface)this.surface).isPressed(9) ? 255 : 6);
        ((Kontrol1ControlSurface)this.surface).updateButton(22, 6);
        ((Kontrol1ControlSurface)this.surface).updateButton(21, 6);
        ((Kontrol1ControlSurface)this.surface).updateButton(16, isBrowseMode ? 0 : 6);
        ((Kontrol1ControlSurface)this.surface).updateButton(13, isBrowseMode ? 0 : 6);
        View activeView = ((Kontrol1ControlSurface)this.surface).getViewManager().getActiveView();
        if (activeView != null) {
            ((Kontrol1CursorCommand)activeView.getTriggerCommand(Commands.COMMAND_ARROW_DOWN)).updateArrows();
        }
        if (modeManager.isActiveMode(Modes.MODE_TRACK) || modeManager.isActiveMode(Modes.MODE_VOLUME)) {
            ((Kontrol1ControlSurface)this.surface).updateButton(15, t != null && t.isMute() ? 255 : 6);
            ((Kontrol1ControlSurface)this.surface).updateButton(3, t != null && t.isSolo() ? 255 : 6);
        } else if (isBrowseMode) {
            ((Kontrol1ControlSurface)this.surface).updateButton(15, 6);
            ((Kontrol1ControlSurface)this.surface).updateButton(3, 6);
        } else {
            ((Kontrol1ControlSurface)this.surface).updateButton(15, 0);
            ((Kontrol1ControlSurface)this.surface).updateButton(3, 0);
        }
        ((Kontrol1ControlSurface)this.surface).updateButton(5, isBrowseMode ? 255 : 6);
        ((Kontrol1ControlSurface)this.surface).updateButtonLEDs();
        if (t == null) {
            double[] dArray2 = new double[3];
            dArray2[0] = 0.0;
            dArray2[1] = 0.0;
            dArray = dArray2;
            dArray2[2] = 0.0;
        } else {
            dArray = t.getColor();
        }
        this.updateKeyLEDs(dArray);
    }

    @Override
    public void drawGrid() {
    }

    @Override
    public void onGridNote(int note, int velocity) {
    }

    private void updateKeyLEDs(double[] color) {
        int red = 0;
        int green = 0;
        int blue = 0;
        boolean isActive = ((Kontrol1Configuration)((Kontrol1ControlSurface)this.surface).getConfiguration()).isScaleIsActive();
        if (isActive) {
            red = (int)Math.round(color[0] * 127.0);
            green = (int)Math.round(color[1] * 127.0);
            blue = (int)Math.round(color[2] * 127.0);
        }
        if (this.scales.isChromatic() || !isActive) {
            for (int i = 0; i < 88; ++i) {
                ((Kontrol1ControlSurface)this.surface).setKeyLED(i, red, green, blue);
            }
        } else {
            Scale scale = this.scales.getScale();
            int scaleOffset = this.scales.getScaleOffset();
            for (int i = 0; i < 88; ++i) {
                int key = i % 12;
                boolean inScale = scale.isInScale(key);
                int brighter = scaleOffset == key ? 10 : 0;
                ((Kontrol1ControlSurface)this.surface).setKeyLED(i, inScale ? Math.min(red + brighter, 127) : 0, inScale ? Math.min(green + brighter, 127) : 0, inScale ? Math.min(blue + brighter, 127) : 0);
            }
        }
        ((Kontrol1ControlSurface)this.surface).updateKeyLEDs();
    }
}

