/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.kontrol.usb.mki.mode.track;

import de.mossgrabers.controller.kontrol.usb.mki.Kontrol1Configuration;
import de.mossgrabers.controller.kontrol.usb.mki.controller.Kontrol1ControlSurface;
import de.mossgrabers.controller.kontrol.usb.mki.controller.Kontrol1Display;
import de.mossgrabers.framework.daw.IChannelBank;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.mode.AbstractMode;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.utils.StringUtils;

public class VolumeMode
extends AbstractMode<Kontrol1ControlSurface, Kontrol1Configuration> {
    public VolumeMode(Kontrol1ControlSurface surface, IModel model) {
        super(surface, model);
        this.isTemporary = false;
    }

    @Override
    public void updateDisplay() {
        Kontrol1Display d = (Kontrol1Display)((Kontrol1ControlSurface)this.surface).getDisplay();
        d.clear();
        IChannelBank tb = this.model.getCurrentTrackBank();
        StringBuilder sb = new StringBuilder();
        int positionFirst = tb.getTrackPositionFirst();
        if (positionFirst >= 0) {
            sb.append(Integer.toString(positionFirst + 1));
            int positionLast = tb.getTrackPositionLast();
            if (positionLast >= 0) {
                sb.append(" - ").append(Integer.toString(positionLast + 1));
            }
        }
        d.setCell(0, 0, this.model.isEffectTrackBankActive() ? "VOL-FX" : "VOLUME").setCell(1, 0, sb.toString());
        ITrack selTrack = tb.getSelectedTrack();
        int selIndex = selTrack == null ? -1 : selTrack.getIndex();
        for (int i = 0; i < 8; ++i) {
            boolean isSel = i == selIndex;
            ITrack t = tb.getTrack(i);
            String n = StringUtils.shortenAndFixASCII(t.getName(), isSel ? 7 : 8).toUpperCase();
            d.setCell(0, 1 + i, isSel ? ">" + n : n).setCell(1, 1 + i, t.isMute() ? "-MUTED-" : (t.isSolo() ? "-SOLO-" : t.getVolumeStr(8)));
            d.setBar(1 + i, ((Kontrol1ControlSurface)this.surface).isPressed(25 + i) && t.doesExist(), t.getVolume());
        }
        d.allDone();
    }

    @Override
    public void onValueKnob(int index, int value) {
        this.model.getCurrentTrackBank().getTrack(index).changeVolume(value);
    }

    @Override
    public void onRowButton(int row, int index, ButtonEvent event) {
    }
}

