/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.kontrol.usb.mki.mode.track;

import de.mossgrabers.controller.kontrol.usb.mki.Kontrol1Configuration;
import de.mossgrabers.controller.kontrol.usb.mki.controller.Kontrol1ControlSurface;
import de.mossgrabers.controller.kontrol.usb.mki.controller.Kontrol1Display;
import de.mossgrabers.framework.daw.IChannelBank;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ISend;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.mode.AbstractMode;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.utils.StringUtils;

public class TrackMode
extends AbstractMode<Kontrol1ControlSurface, Kontrol1Configuration> {
    public TrackMode(Kontrol1ControlSurface surface, IModel model) {
        super(surface, model);
        this.isTemporary = false;
    }

    @Override
    public void updateDisplay() {
        IChannelBank currentTrackBank = this.model.getCurrentTrackBank();
        ITrack t = currentTrackBank.getSelectedTrack();
        Kontrol1Display d = (Kontrol1Display)((Kontrol1ControlSurface)this.surface).getDisplay();
        d.clear();
        if (t == null) {
            d.setCell(0, 3, "  PLEASE").setCell(0, 4, "SELECT A").setCell(0, 5, "TRACK").allDone();
            return;
        }
        boolean isEffectTrackBankActive = this.model.isEffectTrackBankActive();
        d.setCell(0, 0, (isEffectTrackBankActive ? "TR-FX " : "TRACK ") + (t.getPosition() + 1)).setCell(1, 0, StringUtils.shortenAndFixASCII(t.getName(), 8).toUpperCase());
        d.setCell(0, 1, "VOLUME").setCell(1, 1, t.isMute() ? "-MUTED-" : (t.isSolo() ? "-SOLO-" : t.getVolumeStr(8))).setCell(0, 2, "PAN").setCell(1, 2, t.getPanStr(8));
        d.setBar(1, ((Kontrol1ControlSurface)this.surface).isPressed(25), t.getVolume());
        d.setPanBar(2, ((Kontrol1ControlSurface)this.surface).isPressed(26), t.getPan());
        if (!isEffectTrackBankActive) {
            for (int i = 0; i < 6; ++i) {
                int pos = 3 + i;
                ISend sendData = t.getSend(i);
                d.setCell(0, pos, StringUtils.shortenAndFixASCII(sendData.getName(8), 8).toUpperCase()).setCell(1, pos, sendData.getDisplayedValue(8));
                d.setBar(pos, ((Kontrol1ControlSurface)this.surface).isPressed(27 + i) && sendData.doesExist(), sendData.getValue());
            }
        }
        d.allDone();
    }

    @Override
    public void onValueKnob(int index, int value) {
        IChannelBank tb = this.model.getCurrentTrackBank();
        ITrack selectedTrack = tb.getSelectedTrack();
        if (selectedTrack == null) {
            return;
        }
        switch (index) {
            case 0: {
                selectedTrack.changeVolume(value);
                return;
            }
            case 1: {
                selectedTrack.changePan(value);
                return;
            }
        }
        selectedTrack.getSend(index - 2).changeValue(value);
    }

    @Override
    public void onRowButton(int row, int index, ButtonEvent event) {
    }
}

