/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.kontrol.usb.mki.mode.device;

import de.mossgrabers.controller.kontrol.usb.mki.Kontrol1Configuration;
import de.mossgrabers.controller.kontrol.usb.mki.controller.Kontrol1ControlSurface;
import de.mossgrabers.controller.kontrol.usb.mki.controller.Kontrol1Display;
import de.mossgrabers.framework.daw.ICursorDevice;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IParameter;
import de.mossgrabers.framework.mode.AbstractMode;
import de.mossgrabers.framework.utils.ButtonEvent;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class ParamsMode
extends AbstractMode<Kontrol1ControlSurface, Kontrol1Configuration> {
    private static final Set<Character> ILLEGAL_LOWER_CHARS = new HashSet<Character>();

    public ParamsMode(Kontrol1ControlSurface surface, IModel model) {
        super(surface, model);
        this.isTemporary = false;
    }

    @Override
    public void updateDisplay() {
        Kontrol1Display d = (Kontrol1Display)((Kontrol1ControlSurface)this.surface).getDisplay();
        d.clear();
        if (this.model.hasSelectedDevice()) {
            ICursorDevice cursorDevice = this.model.getCursorDevice();
            d.setCell(0, 0, cursorDevice.getName(8).toUpperCase()).setCell(1, 0, cursorDevice.getSelectedParameterPageName().toUpperCase());
            for (int i = 0; i < 8; ++i) {
                IParameter p = cursorDevice.getFXParam(i);
                String name = p.getName(8).toUpperCase();
                if (!name.isEmpty()) {
                    d.setCell(0, 1 + i, name).setCell(1, 1 + i, ParamsMode.checkForUpperCase(p.getDisplayedValue(8)));
                }
                d.setBar(1 + i, ((Kontrol1ControlSurface)this.surface).isPressed(25 + i) && p.doesExist(), p.getValue());
            }
        } else {
            d.setCell(0, 3, "  PLEASE").setCell(0, 4, "SELECT A").setCell(0, 5, "DEVICE").allDone();
        }
        d.allDone();
    }

    @Override
    public void onValueKnob(int index, int value) {
        this.model.getCursorDevice().changeParameter(index, value);
    }

    public void previousPage() {
        this.model.getCursorDevice().previousParameterPage();
    }

    public void nextPage() {
        this.model.getCursorDevice().nextParameterPage();
    }

    public boolean canSelectPreviousPage() {
        return this.model.getCursorDevice().hasPreviousParameterPage();
    }

    public boolean canSelectNextPage() {
        return this.model.getCursorDevice().hasNextParameterPage();
    }

    public void selectPreviousPage() {
        this.model.getCursorDevice().previousParameterPage();
    }

    public void selectNextPage() {
        this.model.getCursorDevice().nextParameterPage();
    }

    public void selectPreviousPageBank() {
        this.model.getCursorDevice().previousParameterPageBank();
    }

    public void selectNextPageBank() {
        this.model.getCursorDevice().nextParameterPageBank();
    }

    @Override
    public void onRowButton(int row, int index, ButtonEvent event) {
    }

    private static String checkForUpperCase(String displayedValue) {
        for (int i = 0; i < displayedValue.length(); ++i) {
            if (!ILLEGAL_LOWER_CHARS.contains(Character.valueOf(displayedValue.charAt(i)))) continue;
            return displayedValue.toUpperCase();
        }
        return displayedValue;
    }

    static {
        Collections.addAll(ILLEGAL_LOWER_CHARS, Character.valueOf('a'), Character.valueOf('e'), Character.valueOf('g'), Character.valueOf('j'), Character.valueOf('k'), Character.valueOf('p'), Character.valueOf('q'), Character.valueOf('r'), Character.valueOf('s'), Character.valueOf('x'), Character.valueOf('y'), Character.valueOf('z'));
    }
}

