/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.kontrol.usb.mki.mode.device;

import de.mossgrabers.controller.kontrol.usb.mki.Kontrol1Configuration;
import de.mossgrabers.controller.kontrol.usb.mki.controller.Kontrol1ControlSurface;
import de.mossgrabers.framework.controller.display.Display;
import de.mossgrabers.framework.daw.IBrowser;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IBrowserColumn;
import de.mossgrabers.framework.daw.data.IBrowserColumnItem;
import de.mossgrabers.framework.mode.AbstractMode;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.utils.StringUtils;

public class BrowseMode
extends AbstractMode<Kontrol1ControlSurface, Kontrol1Configuration> {
    public static final int SELECTION_OFF = 0;
    private static final int SELECTION_PRESET = 1;
    private static final int SELECTION_FILTER = 2;
    private int selectionMode;
    private int filterColumn;
    protected int selectedColumn = -1;

    public BrowseMode(Kontrol1ControlSurface surface, IModel model) {
        super(surface, model);
        this.isTemporary = false;
        this.selectionMode = 0;
        this.filterColumn = 0;
    }

    @Override
    public void onValueKnobTouch(int index, boolean isTouched) {
        if (!isTouched) {
            return;
        }
        int n = this.selectedColumn = this.selectedColumn != -1 ? -1 : index;
        if (this.selectedColumn == -1) {
            this.selectionMode = 0;
            return;
        }
        if (index == 7) {
            this.selectionMode = 1;
            this.filterColumn = -1;
        } else {
            IBrowser browser = this.model.getBrowser();
            IBrowserColumn fc = browser.getFilterColumn(index);
            if (fc != null && fc.doesExist()) {
                this.selectionMode = 2;
                this.filterColumn = fc.getIndex();
            }
        }
    }

    @Override
    public void updateDisplay() {
        if (!this.model.hasSelectedDevice()) {
            ((Kontrol1ControlSurface)this.surface).getModeManager().restoreMode();
            return;
        }
        Display d = ((Kontrol1ControlSurface)this.surface).getDisplay();
        IBrowser browser = this.model.getBrowser();
        if (!browser.isActive()) {
            ((Kontrol1ControlSurface)this.surface).getModeManager().restoreMode();
            return;
        }
        d.clear();
        switch (this.selectionMode) {
            case 0: {
                d.setCell(0, 0, "BROWSE").setCell(1, 0, browser.getSelectedContentType().toUpperCase());
                String selectedResult = browser.getSelectedResult();
                d.setCell(0, 8, "SELECTED").setCell(1, 8, selectedResult == null ? "NONE" : selectedResult);
                for (int i = 0; i < 7; ++i) {
                    IBrowserColumn column = browser.getFilterColumn(i);
                    d.setCell(0, 1 + i, StringUtils.shortenAndFixASCII(column.getName() + ":", 8).toUpperCase()).setCell(1, 1 + i, column.doesCursorExist() ? column.getCursorName().toUpperCase() : "");
                }
                break;
            }
            case 1: {
                d.setCell(0, 0, "SELECTED");
                IBrowserColumnItem[] results = browser.getResultColumnItems();
                for (int i = 0; i < 16; ++i) {
                    d.setCell(i % 2, 1 + i / 2, (results[i].isSelected() ? ">" : " ") + results[i].getName().toUpperCase());
                }
                break;
            }
            case 2: {
                IBrowserColumn fc = browser.getFilterColumn(this.filterColumn);
                d.setCell(0, 0, fc.getName().toUpperCase());
                IBrowserColumnItem[] items = fc.getItems();
                for (int i = 0; i < 16; ++i) {
                    String name = items[i].getName().toUpperCase();
                    String text = (items[i].isSelected() ? ">" : " ") + name;
                    d.setCell(i % 2, 1 + i / 2, text);
                }
                break;
            }
        }
        d.allDone();
    }

    public void navigatePresets(boolean moveUp) {
        this.selectionMode = 1;
        IBrowser browser = this.model.getBrowser();
        if (!browser.isActive()) {
            return;
        }
        if (moveUp) {
            browser.selectNextResult();
        } else {
            browser.selectPreviousResult();
        }
    }

    public void navigateFilters(int filterNumber, boolean moveUp) {
        IBrowser browser = this.model.getBrowser();
        if (!browser.isActive()) {
            return;
        }
        if (moveUp) {
            browser.selectNextFilterItem(this.filterColumn);
        } else {
            browser.selectPreviousFilterItem(this.filterColumn);
        }
    }

    public int getSelectionMode() {
        return this.selectionMode;
    }

    public void selectNext(int count) {
        block3: {
            IBrowser browser;
            block2: {
                int index = this.selectedColumn == -1 ? 7 : this.selectedColumn;
                browser = this.model.getBrowser();
                if (index >= 7) break block2;
                IBrowserColumn fc = browser.getFilterColumn(index);
                if (fc == null || !fc.doesExist()) break block3;
                this.filterColumn = fc.getIndex();
                for (int i = 0; i < count; ++i) {
                    browser.selectNextFilterItem(this.filterColumn);
                }
                if (browser.getSelectedFilterItemIndex(this.filterColumn) != -1) break block3;
                browser.nextFilterItemPage(this.filterColumn);
                break block3;
            }
            for (int i = 0; i < count; ++i) {
                browser.selectNextResult();
            }
        }
    }

    public void selectPrevious(int count) {
        int index = this.selectedColumn == -1 ? 7 : this.selectedColumn;
        IBrowser browser = this.model.getBrowser();
        for (int i = 0; i < count; ++i) {
            if (index < 7) {
                IBrowserColumn fc = browser.getFilterColumn(index);
                if (fc == null || !fc.doesExist()) continue;
                this.filterColumn = fc.getIndex();
                for (int j = 0; j < count; ++j) {
                    browser.selectPreviousFilterItem(this.filterColumn);
                }
                if (browser.getSelectedFilterItemIndex(this.filterColumn) != -1) continue;
                browser.previousFilterItemPage(this.filterColumn);
                continue;
            }
            for (int j = 0; j < count; ++j) {
                browser.selectPreviousResult();
            }
        }
    }

    @Override
    public void onRowButton(int row, int index, ButtonEvent event) {
    }
}

