/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.kontrol.usb.mki.mode;

import de.mossgrabers.controller.kontrol.usb.mki.Kontrol1Configuration;
import de.mossgrabers.controller.kontrol.usb.mki.controller.Kontrol1ControlSurface;
import de.mossgrabers.controller.kontrol.usb.mki.controller.Kontrol1Display;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.mode.AbstractMode;
import de.mossgrabers.framework.scale.Scales;
import de.mossgrabers.framework.utils.ButtonEvent;

public class ScaleMode
extends AbstractMode<Kontrol1ControlSurface, Kontrol1Configuration> {
    final Scales scales;

    public ScaleMode(Kontrol1ControlSurface surface, IModel model) {
        super(surface, model);
        this.isTemporary = true;
        this.scales = this.model.getScales();
    }

    @Override
    public void updateDisplay() {
        Kontrol1Display d = (Kontrol1Display)((Kontrol1ControlSurface)this.surface).getDisplay();
        d.clear();
        d.setCell(0, 0, "SCALE");
        Scales scales = this.model.getScales();
        d.setCell(0, 1, "SCALE").setCell(1, 1, scales.getScale().getName().toUpperCase());
        d.setCell(0, 2, "BASE").setCell(1, 2, Scales.BASES[scales.getScaleOffset()]);
        d.setCell(0, 3, "CHROMATC").setCell(1, 3, scales.isChromatic() ? "On" : "Off");
        d.allDone();
    }

    @Override
    public void onValueKnob(int index, int value) {
        boolean isInc = value <= 63;
        switch (index) {
            case 0: {
                if (isInc) {
                    this.scales.nextScale();
                } else {
                    this.scales.prevScale();
                }
                this.updateScalePreferences();
                break;
            }
            case 1: {
                if (isInc) {
                    this.scales.setScaleOffset(this.scales.getScaleOffset() + 1);
                } else {
                    this.scales.setScaleOffset(this.scales.getScaleOffset() - 1);
                }
                this.updateScalePreferences();
                break;
            }
            case 2: {
                if (isInc) {
                    this.scales.setChromatic(true);
                } else {
                    this.scales.setChromatic(false);
                }
                this.updateScalePreferences();
            }
        }
    }

    @Override
    public void onRowButton(int row, int index, ButtonEvent event) {
    }

    private void updateScalePreferences() {
        Kontrol1Configuration config = (Kontrol1Configuration)((Kontrol1ControlSurface)this.surface).getConfiguration();
        config.setScale(this.scales.getScale().getName());
        config.setScaleBase(Scales.BASES[this.scales.getScaleOffset()]);
        config.setScaleInKey(!this.scales.isChromatic());
    }
}

