/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.kontrol.usb.mki.controller;

import de.mossgrabers.controller.kontrol.usb.mki.controller.UIChangeCallback;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.IMemoryBlock;
import de.mossgrabers.framework.usb.IUSBDevice;
import de.mossgrabers.framework.usb.IUSBEndpoint;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class Kontrol1USBDevice {
    private static final byte[][] UPPER_CHARACTERS = new byte[][]{{-49, 24}, {63, 82}, {-13, 0}, {63, 66}, {-13, 24}, {-61, 24}, {-5, 16}, {-52, 24}, {51, 66}, {31, 0}, {-64, -116}, {-16, 0}, {-52, 5}, {-52, -127}, {-1, 0}, {-57, 24}, {-1, -128}, {-57, -104}, {-69, 24}, {3, 66}, {-4, 0}, {-64, 36}, {-52, -96}, {0, -91}, {0, 69}, {51, 36}};
    private static final byte[][] LOWER_CHARACTERS = new byte[][]{{-49, 24}, {-8, 24}, {112, 24}, {124, 24}, {-13, 24}, {-63, 8}, {-5, 16}, {-56, 24}, {0, 64}, {31, 0}, {-64, -116}, {0, 66}, {72, 88}, {64, 72}, {120, 24}, {-57, 24}, {-1, -128}, {-57, -104}, {-69, 24}, {-32, 8}, {120, 0}, {64, 32}, {120, 64}, {0, -91}, {0, 69}, {51, 36}};
    private static final byte[][] NUMBERS = new byte[][]{{-1, 0}, {12, 0}, {119, 24}, {63, 24}, {-116, 24}, {-69, 24}, {-5, 24}, {15, 0}, {-1, 24}, {-65, 24}};
    private static final byte[] MINUS = new byte[]{0, 24};
    private static final byte[] PLUS = new byte[]{0, 90};
    private static final byte[] PERCENT = new byte[]{-103, 126};
    private static final byte[] GREATER = new byte[]{0, 33};
    private static final byte[] APOSTROPH = new byte[]{-128, 0};
    private static final byte[] FWD_SLASH = new byte[]{0, 36};
    private static final byte[] BWD_SLASH = new byte[]{0, -127};
    private static final int[] BYTE_0 = new int[]{1, 2, 3, 4, 5, 6, 7, 8};
    private static final int[] BYTE_1 = new int[]{9, 10, 11, 12, 13, 14, 15, 16};
    private static final int[] BYTE_2 = new int[]{17, 18, 19, 20, 21, 22, 23, 24};
    private static final int[] BYTE_3 = new int[]{25, 26, 27, 28, 29, 30, 31, 32};
    private static final int[] BYTE_4 = new int[]{33};
    private static final int[] TEST_BITS = new int[]{1, 2, 4, 8, 16, 32, 64, 128};
    private static final int DATA_SZ = 249;
    private static final int TIMEOUT = 10000;
    private static final int MESSAGE_SIZE = 49;
    private static final Map<Integer, Integer> LED_MAPPING = new HashMap<Integer, Integer>(21);
    private IHost host;
    private IUSBDevice usbDevice;
    private IUSBEndpoint usbEndpointDisplay;
    private IUSBEndpoint usbEndpointUI;
    private IMemoryBlock initBlock;
    private IMemoryBlock displayBlock;
    private IMemoryBlock uiBlock;
    private IMemoryBlock ledBlock;
    private IMemoryBlock keyLedBlock;
    private final Object busySendingDisplay = new Object();
    private boolean busySendingLEDs = false;
    private boolean busySendingKeyLEDs = false;
    private int mainEncoderValue;
    private int[] encoderValues = new int[8];
    private byte[] buttonStates = new byte[21];
    private byte[] oldButtonStates = new byte[21];
    private byte[] keyColors = new byte[264];
    private byte[] oldKeyColors = new byte[264];
    private final boolean[][] dots = new boolean[2][72];
    private final char[][] texts = new char[2][72];
    private final int[][] bars = new int[9][9];
    private boolean isFirstStateMsg = true;
    private UIChangeCallback callback;

    public Kontrol1USBDevice(IHost host) {
        this.host = host;
        try {
            this.usbDevice = host.getUsbDevice(0);
            this.usbEndpointDisplay = this.usbDevice.getEndpoint(0, 0);
            this.usbEndpointUI = this.usbDevice.getEndpoint(0, 1);
        }
        catch (RuntimeException ex) {
            this.usbDevice = null;
            this.usbEndpointDisplay = null;
            this.usbEndpointUI = null;
            host.error("Could not open USB connection: " + ex.getMessage());
        }
        this.displayBlock = host.createMemoryBlock(249);
        this.uiBlock = host.createMemoryBlock(1024);
        this.ledBlock = host.createMemoryBlock(26);
        this.keyLedBlock = host.createMemoryBlock(267);
        this.initBlock = host.createMemoryBlock(3);
        ByteBuffer initBuffer = this.initBlock.createByteBuffer();
        initBuffer.put((byte)-96);
        initBuffer.put((byte)0);
        initBuffer.put((byte)0);
        this.oldKeyColors[0] = -1;
    }

    public void setCallback(UIChangeCallback callback) {
        this.callback = callback;
    }

    public void init() {
        if (this.usbEndpointDisplay != null) {
            this.usbEndpointDisplay.send(this.initBlock, 10000);
        }
    }

    public void pollUI() {
        if (this.usbEndpointUI == null) {
            return;
        }
        this.usbEndpointUI.sendAsync(this.uiBlock, resultLength -> {
            if (resultLength > 0) {
                this.processMessage(resultLength);
            }
            this.host.scheduleTask(this::pollUI, 10L);
        }, 10000);
    }

    public void setCharacter(int row, int index, char character) {
        if (row < 0 || row > 1 || index < 0 || index > 71) {
            return;
        }
        this.texts[row][index] = character;
    }

    public void setDot(int row, int index, boolean set) {
        if (row < 0 || row > 1 || index < 0 || index > 71) {
            return;
        }
        this.dots[row][index] = set;
    }

    public void setBar(int column, boolean hasBorder, int value, int maxValue) {
        int v = value * 36 / maxValue;
        int full = v / 4;
        for (int i = 0; i < 9; ++i) {
            int n = this.bars[column][i] = i < full ? 3 : 0;
            if (!hasBorder) continue;
            int[] nArray = this.bars[column];
            int n2 = i;
            nArray[n2] = nArray[n2] + 68;
        }
        if (full < 9) {
            int dashes = v % 4;
            if (dashes == 1) {
                dashes = 2;
            } else if (dashes == 2) {
                dashes = 1;
            }
            this.bars[column][full] = dashes;
            if (hasBorder) {
                int[] nArray = this.bars[column];
                int n = full;
                nArray[n] = nArray[n] + 68;
            }
        }
    }

    public void setPanBar(int column, boolean hasBorder, int value, int maxValue) {
        for (int i = 0; i < 9; ++i) {
            this.bars[column][i] = i == 4 ? 3 : 0;
        }
        int middle = maxValue / 2;
        if (value != middle) {
            int i;
            boolean isLeft = value < middle;
            int pos = isLeft ? middle - value : value - middle;
            int noOfBars = 16 * pos / maxValue;
            int half = noOfBars / 2;
            int rest = noOfBars % 2;
            if (isLeft) {
                for (i = 4 - half; i <= 4; ++i) {
                    this.bars[column][i] = 3;
                }
                if (rest > 0 && 4 - half - 1 >= 0) {
                    this.bars[column][4 - half - 1] = 2;
                }
            } else {
                for (i = 0; i <= half; ++i) {
                    this.bars[column][5 + i] = 3;
                }
                if (rest > 0 && 5 + half + 1 <= 8) {
                    this.bars[column][5 + half + 1] = 2;
                }
            }
        }
        if (!hasBorder) {
            return;
        }
        int i = 0;
        while (i < 9) {
            int[] nArray = this.bars[column];
            int n = i++;
            nArray[n] = nArray[n] + 68;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendDisplayData() {
        if (this.usbEndpointDisplay == null) {
            return;
        }
        Object object = this.busySendingDisplay;
        synchronized (object) {
            ByteBuffer displayBuffer = this.displayBlock.createByteBuffer();
            displayBuffer.rewind();
            for (int row = 0; row < 3; ++row) {
                int j;
                Kontrol1USBDevice.fillHeader(displayBuffer, row);
                if (row == 0) {
                    for (j = 0; j < 72; ++j) {
                        int col = j / 8;
                        displayBuffer.put((byte)this.bars[col][j - col * 8]);
                        if (j % 8 == 7) {
                            displayBuffer.put((byte)this.bars[col][8]);
                            continue;
                        }
                        if (this.dots[0][j] && this.dots[1][j]) {
                            displayBuffer.put((byte)-1);
                            continue;
                        }
                        if (this.dots[0][j]) {
                            displayBuffer.put((byte)-3);
                            continue;
                        }
                        if (this.dots[1][j]) {
                            displayBuffer.put((byte)-2);
                            continue;
                        }
                        displayBuffer.put((byte)0);
                    }
                    for (j = 0; j < 96; ++j) {
                        displayBuffer.put((byte)0);
                    }
                } else {
                    for (j = 0; j < 72; ++j) {
                        displayBuffer.put(this.getCharacter(row - 1, j));
                    }
                    for (j = 0; j < 96; ++j) {
                        displayBuffer.put((byte)0);
                    }
                }
                this.usbEndpointDisplay.send(this.displayBlock, 10000);
            }
        }
    }

    public void shutdown() {
        this.usbEndpointDisplay = null;
    }

    public void setButtonLED(int buttonID, int intensity) {
        Integer pos = LED_MAPPING.get(buttonID);
        if (pos == null) {
            this.host.error("Illegal button LED: " + buttonID);
            return;
        }
        this.buttonStates[pos.intValue()] = (byte)intensity;
    }

    public void updateButtonLEDs() {
        if (this.usbEndpointDisplay == null) {
            return;
        }
        if (this.busySendingLEDs || Arrays.equals(this.oldButtonStates, this.buttonStates)) {
            return;
        }
        System.arraycopy(this.buttonStates, 0, this.oldButtonStates, 0, this.oldButtonStates.length);
        ByteBuffer ledBuffer = this.ledBlock.createByteBuffer();
        ledBuffer.clear();
        ledBuffer.put((byte)-128);
        ledBuffer.put(this.buttonStates);
        ledBuffer.put((byte)0);
        ledBuffer.put((byte)0);
        ledBuffer.put((byte)0);
        ledBuffer.put((byte)0);
        this.busySendingLEDs = true;
        this.usbEndpointDisplay.send(this.ledBlock, 10000);
        this.busySendingLEDs = false;
    }

    public void setKeyLED(int key, int red, int green, int blue) {
        if (key < 0 || key >= 88) {
            return;
        }
        int pos = 3 * key;
        this.keyColors[pos] = (byte)red;
        this.keyColors[pos + 1] = (byte)green;
        this.keyColors[pos + 2] = (byte)blue;
    }

    public void updateKeyLEDs() {
        if (this.usbEndpointDisplay == null) {
            return;
        }
        if (this.busySendingKeyLEDs || Arrays.equals(this.oldKeyColors, this.keyColors)) {
            return;
        }
        System.arraycopy(this.keyColors, 0, this.oldKeyColors, 0, this.oldKeyColors.length);
        ByteBuffer leyLedBuffer = this.keyLedBlock.createByteBuffer();
        leyLedBuffer.clear();
        leyLedBuffer.put((byte)-126);
        leyLedBuffer.put(this.keyColors);
        leyLedBuffer.put((byte)0);
        leyLedBuffer.put((byte)0);
        this.busySendingKeyLEDs = true;
        this.usbEndpointDisplay.send(this.keyLedBlock, 10000);
        this.busySendingKeyLEDs = false;
    }

    private static void fillHeader(ByteBuffer displayBuffer, int row) {
        displayBuffer.clear();
        displayBuffer.put((byte)-32);
        displayBuffer.put((byte)0);
        displayBuffer.put((byte)0);
        displayBuffer.put((byte)row);
        displayBuffer.put((byte)0);
        displayBuffer.put((byte)72);
        displayBuffer.put((byte)0);
        displayBuffer.put((byte)1);
        displayBuffer.put((byte)0);
    }

    private void processMessage(int received) {
        ByteBuffer uiBuffer = this.uiBlock.createByteBuffer();
        byte[] dst = new byte[49];
        for (int i = 0; i < received / 49; ++i) {
            uiBuffer.get(dst);
            boolean encoderChange = false;
            int currentEncoderValue = Byte.toUnsignedInt(dst[6]);
            if (currentEncoderValue != this.mainEncoderValue) {
                boolean valueIncreased = (this.mainEncoderValue < currentEncoderValue || this.mainEncoderValue == 15 && currentEncoderValue == 0) && (this.mainEncoderValue != 0 || currentEncoderValue != 15);
                this.mainEncoderValue = currentEncoderValue;
                if (!this.isFirstStateMsg) {
                    this.callback.mainEncoderChanged(valueIncreased);
                }
                encoderChange = true;
            }
            int start = 7;
            for (int encIndex = 0; encIndex < 8; ++encIndex) {
                int pos = 7 + 2 * encIndex;
                int value = Byte.toUnsignedInt(dst[pos]) | Byte.toUnsignedInt(dst[pos + 1]) << 8;
                int hValue = Byte.toUnsignedInt(dst[pos + 1]);
                if (this.encoderValues[encIndex] == value) continue;
                int prevHValue = (this.encoderValues[encIndex] & 0xF00) >> 8;
                boolean valueIncreased = (this.encoderValues[encIndex] < value || prevHValue == 3 && hValue == 0) && (prevHValue != 0 || hValue != 3);
                this.encoderValues[encIndex] = value;
                if (!this.isFirstStateMsg) {
                    this.callback.encoderChanged(encIndex, valueIncreased);
                }
                encoderChange = true;
            }
            this.isFirstStateMsg = false;
            this.testByteForButtons(dst[1], BYTE_0);
            this.testByteForButtons(dst[2], BYTE_1);
            this.testByteForButtons(dst[3], BYTE_2);
            if (encoderChange) continue;
            this.testByteForButtons(dst[4], BYTE_3);
            this.testByteForButtons(dst[5], BYTE_4);
        }
        uiBuffer.clear();
    }

    private void testByteForButtons(byte b, int[] buttons) {
        if (this.callback == null) {
            return;
        }
        int t = Byte.toUnsignedInt(b);
        for (int i = 0; i < buttons.length; ++i) {
            this.callback.buttonChange(buttons[i], (t & TEST_BITS[i]) > 0);
        }
    }

    private byte[] getCharacter(int row, int index) {
        char c = this.texts[row][index];
        if (c >= 'A' && c <= 'Z') {
            return UPPER_CHARACTERS[c - 65];
        }
        if (c >= 'a' && c <= 'z') {
            return LOWER_CHARACTERS[c - 97];
        }
        if (c >= '0' && c <= '9') {
            return NUMBERS[c - 48];
        }
        switch (c) {
            case '-': {
                return MINUS;
            }
            case '+': {
                return PLUS;
            }
            case '%': {
                return PERCENT;
            }
            case '>': {
                return GREATER;
            }
            case '\'': {
                return APOSTROPH;
            }
            case '/': {
                return FWD_SLASH;
            }
            case '\\': {
                return BWD_SLASH;
            }
        }
        return new byte[]{0, 0};
    }

    public void turnOffButtonLEDs() {
        for (Integer buttonLED : LED_MAPPING.values()) {
            this.buttonStates[buttonLED.intValue()] = 0;
        }
        this.updateButtonLEDs();
    }

    static {
        LED_MAPPING.put(17, 0);
        LED_MAPPING.put(18, 1);
        LED_MAPPING.put(19, 2);
        LED_MAPPING.put(20, 3);
        LED_MAPPING.put(23, 4);
        LED_MAPPING.put(24, 5);
        LED_MAPPING.put(11, 6);
        LED_MAPPING.put(10, 7);
        LED_MAPPING.put(9, 8);
        LED_MAPPING.put(22, 9);
        LED_MAPPING.put(21, 10);
        LED_MAPPING.put(5, 11);
        LED_MAPPING.put(2, 12);
        LED_MAPPING.put(6, 13);
        LED_MAPPING.put(4, 14);
        LED_MAPPING.put(15, 15);
        LED_MAPPING.put(16, 16);
        LED_MAPPING.put(3, 17);
        LED_MAPPING.put(14, 18);
        LED_MAPPING.put(13, 19);
        LED_MAPPING.put(12, 20);
    }
}

