/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.kontrol.usb.mki.controller;

import de.mossgrabers.controller.kontrol.usb.mki.Kontrol1Configuration;
import de.mossgrabers.controller.kontrol.usb.mki.controller.Kontrol1USBDevice;
import de.mossgrabers.framework.controller.display.AbstractDisplay;
import de.mossgrabers.framework.controller.display.Display;
import de.mossgrabers.framework.controller.display.Format;
import de.mossgrabers.framework.daw.IHost;

public class Kontrol1Display
extends AbstractDisplay {
    private static final String[] SPACES = new String[]{"", " ", "  ", "   ", "    ", "     ", "      ", "       ", "        ", "         ", "          ", "           ", "            ", "             "};
    private int maxParameterValue;
    private Kontrol1USBDevice usbDevice;

    public Kontrol1Display(IHost host, int maxParameterValue, Kontrol1Configuration configuration, Kontrol1USBDevice usbDevice) {
        super(host, null, 2, 9, 72);
        this.maxParameterValue = maxParameterValue;
        this.usbDevice = usbDevice;
    }

    @Override
    public void shutdown() {
        this.usbDevice.shutdown();
    }

    @Override
    public void flush() {
        super.flush();
        this.usbDevice.sendDisplayData();
    }

    @Override
    public AbstractDisplay clear() {
        for (int i = 0; i < 9; ++i) {
            this.usbDevice.setBar(i, false, 0, 1);
            for (int j = 0; j < 7; ++j) {
                this.usbDevice.setDot(0, j, false);
                this.usbDevice.setDot(1, j, false);
            }
        }
        return super.clear();
    }

    @Override
    public Kontrol1Display clearRow(int row) {
        for (int i = 0; i < this.noOfCells; ++i) {
            this.clearCell(row, i);
        }
        return this;
    }

    @Override
    public Kontrol1Display clearCell(int row, int cell) {
        this.cells[row * this.noOfCells + cell] = "        ";
        return this;
    }

    @Override
    public Kontrol1Display setBlock(int row, int block, String value) {
        int cell = 2 * block;
        if (value.length() > 9) {
            this.cells[row * this.noOfCells + cell] = value.substring(0, 9);
            this.cells[row * this.noOfCells + cell + 1] = Kontrol1Display.pad(value.substring(9), 8);
        } else {
            this.cells[row * this.noOfCells + cell] = Kontrol1Display.pad(value, 9);
            this.clearCell(row, cell + 1);
        }
        return this;
    }

    @Override
    public Display setCell(int row, int column, int value, Format format) {
        this.setCell(row, column, Integer.toString(value));
        return this;
    }

    @Override
    public Kontrol1Display setCell(int row, int cell, String value) {
        this.cells[row * this.noOfCells + cell] = Kontrol1Display.pad(value, 8);
        return this;
    }

    @Override
    public void writeLine(int row, String text) {
        String t = text;
        for (int i = 0; i < t.length(); ++i) {
            boolean isDot;
            char c = t.charAt(i);
            boolean bl = isDot = c == '.';
            if (!isDot || i % 8 == 0) {
                this.usbDevice.setDot(row, i, isDot);
                this.usbDevice.setCharacter(row, i, isDot ? (char)' ' : (char)c);
                continue;
            }
            this.usbDevice.setDot(row, i - 1, true);
            this.usbDevice.setDot(row, i, false);
            int end = (i / 8 + 1) * 8;
            t = t.substring(0, i) + t.substring(i + 1, end) + " " + t.substring(end);
            c = t.charAt(i);
            this.usbDevice.setCharacter(row, i, c == '.' ? (char)' ' : (char)c);
        }
    }

    public void setBar(int column, boolean hasBorder, int value) {
        this.usbDevice.setBar(column, hasBorder, value, this.maxParameterValue);
    }

    public void setPanBar(int column, boolean hasBorder, int value) {
        this.usbDevice.setPanBar(column, hasBorder, value, this.maxParameterValue);
    }

    public static String pad(String str, int length) {
        String text = str == null ? "" : str;
        int diff = length - text.length();
        if (diff < 0) {
            return text.substring(0, length);
        }
        if (diff > 0) {
            return text + SPACES[diff];
        }
        return text;
    }
}

