/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.kontrol.usb.mki.controller;

import de.mossgrabers.controller.kontrol.usb.mki.Kontrol1Configuration;
import de.mossgrabers.controller.kontrol.usb.mki.controller.Kontrol1USBDevice;
import de.mossgrabers.controller.kontrol.usb.mki.controller.UIChangeCallback;
import de.mossgrabers.framework.controller.AbstractControlSurface;
import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.midi.IMidiInput;

public class Kontrol1ControlSurface
extends AbstractControlSurface<Kontrol1Configuration>
implements UIChangeCallback {
    public static final int BUTTON_MAIN_ENCODER = 1;
    public static final int BUTTON_PRESET_UP = 2;
    public static final int BUTTON_ENTER = 3;
    public static final int BUTTON_PRESET_DOWN = 4;
    public static final int BUTTON_BROWSE = 5;
    public static final int BUTTON_INSTANCE = 6;
    public static final int BUTTON_OCTAVE_DOWN = 7;
    public static final int BUTTON_OCTAVE_UP = 8;
    public static final int BUTTON_STOP = 9;
    public static final int BUTTON_REC = 10;
    public static final int BUTTON_PLAY = 11;
    public static final int BUTTON_NAVIGATE_RIGHT = 12;
    public static final int BUTTON_NAVIGATE_DOWN = 13;
    public static final int BUTTON_NAVIGATE_LEFT = 14;
    public static final int BUTTON_BACK = 15;
    public static final int BUTTON_NAVIGATE_UP = 16;
    public static final int BUTTON_SHIFT = 17;
    public static final int BUTTON_SCALE = 18;
    public static final int BUTTON_ARP = 19;
    public static final int BUTTON_LOOP = 20;
    public static final int BUTTON_PAGE_RIGHT = 21;
    public static final int BUTTON_PAGE_LEFT = 22;
    public static final int BUTTON_RWD = 23;
    public static final int BUTTON_FWD = 24;
    public static final int TOUCH_ENCODER_1 = 25;
    public static final int TOUCH_ENCODER_2 = 26;
    public static final int TOUCH_ENCODER_3 = 27;
    public static final int TOUCH_ENCODER_4 = 28;
    public static final int TOUCH_ENCODER_5 = 29;
    public static final int TOUCH_ENCODER_6 = 30;
    public static final int TOUCH_ENCODER_7 = 31;
    public static final int TOUCH_ENCODER_8 = 32;
    public static final int TOUCH_ENCODER_MAIN = 33;
    public static final int ENCODER_1 = 40;
    public static final int ENCODER_2 = 41;
    public static final int ENCODER_3 = 42;
    public static final int ENCODER_4 = 43;
    public static final int ENCODER_5 = 44;
    public static final int ENCODER_6 = 45;
    public static final int ENCODER_7 = 46;
    public static final int ENCODER_8 = 47;
    public static final int MAIN_ENCODER = 48;
    private static final int[] KONTROL1_BUTTONS_ALL = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33};
    public static final int BUTTON_STATE_HI = 255;
    public static final int BUTTON_STATE_ON = 6;
    public static final int BUTTON_STATE_OFF = 0;
    private Kontrol1USBDevice usbDevice;

    public Kontrol1ControlSurface(IHost host, ColorManager colorManager, Kontrol1Configuration configuration, IMidiInput input, Kontrol1USBDevice usbDevice) {
        super(host, configuration, colorManager, null, input, KONTROL1_BUTTONS_ALL);
        this.usbDevice = usbDevice;
        this.colorManager.registerColor("BUTTON_STATE_OFF", 0);
        this.colorManager.registerColor("BUTTON_STATE_ON", 6);
        this.colorManager.registerColor("BUTTON_STATE_HI", 255);
        this.shiftButtonId = 17;
        this.leftButtonId = 14;
        this.rightButtonId = 12;
        this.upButtonId = 16;
        this.downButtonId = 13;
    }

    @Override
    public void shutdown() {
        this.usbDevice.turnOffButtonLEDs();
        for (int i = 0; i < 88; ++i) {
            this.usbDevice.setKeyLED(i, 0, 0, 0);
        }
        this.updateKeyLEDs();
        this.display.clear();
        this.display.notify("START " + this.host.getName().toUpperCase() + " TO PLAY", true, false);
        this.display.shutdown();
    }

    @Override
    public void setButton(int button, int state) {
        this.usbDevice.setButtonLED(button, state);
    }

    @Override
    public void buttonChange(int buttonID, boolean isPressed) {
        if (isPressed) {
            if (!this.isPressed(buttonID)) {
                this.handleCC(0, buttonID, 127);
            }
        } else if (this.isPressed(buttonID)) {
            this.handleCC(0, buttonID, 0);
        }
    }

    @Override
    public void mainEncoderChanged(boolean valueIncreased) {
        this.handleCC(0, 48, valueIncreased ? 1 : 127);
    }

    @Override
    public void encoderChanged(int encIndex, boolean valueIncreased) {
        this.handleCC(0, 40 + encIndex, valueIncreased ? 1 : 127);
    }

    @Override
    protected void handleMidi(int status, int data1, int data2) {
    }

    public void updateButtonLEDs() {
        this.usbDevice.updateButtonLEDs();
    }

    public void setKeyLED(int key, int red, int green, int blue) {
        this.usbDevice.setKeyLED(key, red, green, blue);
    }

    public void updateKeyLEDs() {
        this.usbDevice.updateKeyLEDs();
    }
}

