/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.kontrol.usb.mki.command.trigger;

import de.mossgrabers.controller.kontrol.usb.mki.Kontrol1Configuration;
import de.mossgrabers.controller.kontrol.usb.mki.controller.Kontrol1ControlSurface;
import de.mossgrabers.controller.kontrol.usb.mki.mode.Modes;
import de.mossgrabers.controller.kontrol.usb.mki.mode.device.ParamsMode;
import de.mossgrabers.framework.command.trigger.CursorCommand;
import de.mossgrabers.framework.daw.IBrowser;
import de.mossgrabers.framework.daw.IChannelBank;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.mode.ModeManager;
import de.mossgrabers.framework.scale.Scales;

public class Kontrol1CursorCommand
extends CursorCommand<Kontrol1ControlSurface, Kontrol1Configuration> {
    public Kontrol1CursorCommand(CursorCommand.Direction direction, IModel model, Kontrol1ControlSurface surface) {
        super(direction, model, surface);
    }

    @Override
    protected void updateArrowStates() {
        IChannelBank tb = this.model.getCurrentTrackBank();
        this.canScrollUp = tb.canScrollScenesUp();
        this.canScrollDown = tb.canScrollScenesDown();
        ModeManager modeManager = ((Kontrol1ControlSurface)this.surface).getModeManager();
        if (modeManager.isActiveMode(Modes.MODE_PARAMS)) {
            ParamsMode mode = (ParamsMode)modeManager.getActiveMode();
            this.canScrollLeft = mode.canSelectPreviousPage();
            this.canScrollRight = mode.canSelectNextPage();
            return;
        }
        if (modeManager.isActiveMode(Modes.MODE_BROWSER)) {
            IBrowser browser = this.model.getBrowser();
            this.canScrollLeft = browser.hasPreviousContentType();
            this.canScrollRight = browser.hasNextContentType();
            return;
        }
        ITrack sel = tb.getSelectedTrack();
        int selIndex = sel != null ? sel.getIndex() : -1;
        this.canScrollLeft = selIndex > 0 || tb.canScrollTracksUp();
        this.canScrollRight = selIndex >= 0 && selIndex < 7 && tb.getTrack(selIndex + 1).doesExist() || tb.canScrollTracksDown();
    }

    @Override
    protected void scrollLeft() {
        ModeManager modeManager = ((Kontrol1ControlSurface)this.surface).getModeManager();
        if (modeManager.isActiveMode(Modes.MODE_PARAMS)) {
            ParamsMode paramsMode = (ParamsMode)modeManager.getActiveMode();
            if (((Kontrol1ControlSurface)this.surface).isShiftPressed()) {
                paramsMode.selectPreviousPageBank();
            } else {
                paramsMode.selectPreviousPage();
            }
            return;
        }
        if (modeManager.isActiveMode(Modes.MODE_BROWSER)) {
            this.model.getBrowser().previousContentType();
            return;
        }
        if (modeManager.isActiveMode(Modes.MODE_SCALE)) {
            this.model.getScales().prevScale();
            this.updateScalePreferences();
            return;
        }
        this.scrollTracksLeft();
    }

    @Override
    protected void scrollRight() {
        ModeManager modeManager = ((Kontrol1ControlSurface)this.surface).getModeManager();
        if (modeManager.isActiveMode(Modes.MODE_PARAMS)) {
            ParamsMode activeMode = (ParamsMode)modeManager.getActiveMode();
            if (((Kontrol1ControlSurface)this.surface).isShiftPressed()) {
                activeMode.selectNextPageBank();
            } else {
                activeMode.selectNextPage();
            }
            return;
        }
        if (modeManager.isActiveMode(Modes.MODE_BROWSER)) {
            this.model.getBrowser().nextContentType();
            return;
        }
        if (modeManager.isActiveMode(Modes.MODE_SCALE)) {
            this.model.getScales().nextScale();
            this.updateScalePreferences();
            return;
        }
        this.scrollTracksRight();
    }

    @Override
    protected void scrollUp() {
        ModeManager modeManager = ((Kontrol1ControlSurface)this.surface).getModeManager();
        if (modeManager.isActiveMode(Modes.MODE_PARAMS)) {
            if (((Kontrol1ControlSurface)this.surface).isShiftPressed()) {
                this.model.getCursorDevice().selectNextBank();
            } else {
                this.model.getCursorDevice().selectNext();
            }
            return;
        }
        if (modeManager.isActiveMode(Modes.MODE_BROWSER)) {
            return;
        }
        if (modeManager.isActiveMode(Modes.MODE_SCALE)) {
            Scales scales = this.model.getScales();
            scales.setScaleOffset(scales.getScaleOffset() + 1);
            this.updateScalePreferences();
            return;
        }
        this.scrollTrackBankRight(null, 8);
    }

    @Override
    protected void scrollDown() {
        ModeManager modeManager = ((Kontrol1ControlSurface)this.surface).getModeManager();
        if (modeManager.isActiveMode(Modes.MODE_PARAMS)) {
            if (((Kontrol1ControlSurface)this.surface).isShiftPressed()) {
                this.model.getCursorDevice().selectPreviousBank();
            } else {
                this.model.getCursorDevice().selectPrevious();
            }
            return;
        }
        if (modeManager.isActiveMode(Modes.MODE_BROWSER)) {
            return;
        }
        if (modeManager.isActiveMode(Modes.MODE_SCALE)) {
            Scales scales = this.model.getScales();
            scales.setScaleOffset(scales.getScaleOffset() - 1);
            this.updateScalePreferences();
            return;
        }
        this.scrollTrackBankLeft(null, 8);
    }

    private void updateScalePreferences() {
        Kontrol1Configuration config = (Kontrol1Configuration)((Kontrol1ControlSurface)this.surface).getConfiguration();
        Scales scales = this.model.getScales();
        config.setScale(scales.getScale().getName());
        config.setScaleBase(Scales.BASES[scales.getScaleOffset()]);
        config.setScaleInKey(!scales.isChromatic());
    }
}

