/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.kontrol.usb.mki;

import de.mossgrabers.controller.kontrol.usb.mki.Kontrol1Configuration;
import de.mossgrabers.controller.kontrol.usb.mki.command.continuous.MainEncoderCommand;
import de.mossgrabers.controller.kontrol.usb.mki.command.trigger.BackButtonCommand;
import de.mossgrabers.controller.kontrol.usb.mki.command.trigger.EnterButtonCommand;
import de.mossgrabers.controller.kontrol.usb.mki.command.trigger.Kontrol1CursorCommand;
import de.mossgrabers.controller.kontrol.usb.mki.command.trigger.Kontrol1PlayCommand;
import de.mossgrabers.controller.kontrol.usb.mki.command.trigger.MainEncoderButtonCommand;
import de.mossgrabers.controller.kontrol.usb.mki.command.trigger.ScaleButtonCommand;
import de.mossgrabers.controller.kontrol.usb.mki.controller.Kontrol1ControlSurface;
import de.mossgrabers.controller.kontrol.usb.mki.controller.Kontrol1Display;
import de.mossgrabers.controller.kontrol.usb.mki.controller.Kontrol1USBDevice;
import de.mossgrabers.controller.kontrol.usb.mki.mode.Modes;
import de.mossgrabers.controller.kontrol.usb.mki.mode.ScaleMode;
import de.mossgrabers.controller.kontrol.usb.mki.mode.device.BrowseMode;
import de.mossgrabers.controller.kontrol.usb.mki.mode.device.ParamsMode;
import de.mossgrabers.controller.kontrol.usb.mki.mode.track.TrackMode;
import de.mossgrabers.controller.kontrol.usb.mki.mode.track.VolumeMode;
import de.mossgrabers.controller.kontrol.usb.mki.view.ControlView;
import de.mossgrabers.controller.kontrol.usb.mki.view.Views;
import de.mossgrabers.framework.command.Commands;
import de.mossgrabers.framework.command.continuous.KnobRowModeCommand;
import de.mossgrabers.framework.command.trigger.BrowserCommand;
import de.mossgrabers.framework.command.trigger.CursorCommand;
import de.mossgrabers.framework.command.trigger.KnobRowTouchModeCommand;
import de.mossgrabers.framework.command.trigger.ModeMultiSelectCommand;
import de.mossgrabers.framework.command.trigger.NopCommand;
import de.mossgrabers.framework.command.trigger.transport.MetronomeCommand;
import de.mossgrabers.framework.command.trigger.transport.RecordCommand;
import de.mossgrabers.framework.command.trigger.transport.StopCommand;
import de.mossgrabers.framework.command.trigger.transport.ToggleLoopCommand;
import de.mossgrabers.framework.command.trigger.transport.WindCommand;
import de.mossgrabers.framework.configuration.ISettingsUI;
import de.mossgrabers.framework.controller.AbstractControllerSetup;
import de.mossgrabers.framework.controller.DefaultValueChanger;
import de.mossgrabers.framework.controller.ISetupFactory;
import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.midi.IMidiAccess;
import de.mossgrabers.framework.daw.midi.IMidiInput;
import de.mossgrabers.framework.mode.ModeManager;
import de.mossgrabers.framework.view.ViewManager;

public class Kontrol1ControllerSetup
extends AbstractControllerSetup<Kontrol1ControlSurface, Kontrol1Configuration> {
    private Kontrol1USBDevice usbDevice;

    public Kontrol1ControllerSetup(IHost host, ISetupFactory factory, ISettingsUI settings) {
        super(factory, host, settings);
        this.valueChanger = new DefaultValueChanger(1024, 10, 1.0);
        this.colorManager = new ColorManager();
        this.configuration = new Kontrol1Configuration(this.valueChanger);
    }

    @Override
    protected void createModel() {
        this.model = this.factory.createModel(this.colorManager, this.valueChanger, this.scales, 8, 8, 8, 16, 16, true, -1, -1, -1, -1);
    }

    @Override
    protected void createSurface() {
        IHost host = this.model.getHost();
        this.usbDevice = new Kontrol1USBDevice(host);
        this.usbDevice.init();
        IMidiAccess midiAccess = this.factory.createMidiAccess();
        IMidiInput input = midiAccess.createInput("Komplete Kontrol 1", "80????", "90????", "B040??", "B001??", "D0????", "E0????");
        Kontrol1ControlSurface surface = new Kontrol1ControlSurface(host, this.colorManager, (Kontrol1Configuration)this.configuration, input, this.usbDevice);
        this.usbDevice.setCallback(surface);
        this.surfaces.add(surface);
        Kontrol1Display display = new Kontrol1Display(host, this.valueChanger.getUpperBound(), (Kontrol1Configuration)this.configuration, this.usbDevice);
        surface.setDisplay(display);
        surface.getModeManager().setDefaultMode(Modes.MODE_TRACK);
    }

    @Override
    protected void createModes() {
        Kontrol1ControlSurface surface = (Kontrol1ControlSurface)this.getSurface();
        ModeManager modeManager = surface.getModeManager();
        modeManager.registerMode(Modes.MODE_TRACK, new TrackMode(surface, this.model));
        modeManager.registerMode(Modes.MODE_VOLUME, new VolumeMode(surface, this.model));
        modeManager.registerMode(Modes.MODE_PARAMS, new ParamsMode(surface, this.model));
        modeManager.registerMode(Modes.MODE_BROWSER, new BrowseMode(surface, this.model));
        modeManager.registerMode(Modes.MODE_SCALE, new ScaleMode(surface, this.model));
    }

    @Override
    protected void createViews() {
        Kontrol1ControlSurface surface = (Kontrol1ControlSurface)this.getSurface();
        ViewManager viewManager = surface.getViewManager();
        viewManager.registerView(Views.VIEW_CONTROL, new ControlView(surface, this.model));
    }

    @Override
    protected void createObservers() {
        this.createScaleObservers(this.configuration);
    }

    @Override
    protected void registerTriggerCommands() {
        Kontrol1ControlSurface surface = (Kontrol1ControlSurface)this.getSurface();
        this.addTriggerCommand(Commands.COMMAND_SCALES, 18, new ScaleButtonCommand(this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_METRONOME, 19, new MetronomeCommand(this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_PLAY, 11, new Kontrol1PlayCommand(this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_RECORD, 10, new RecordCommand(this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_STOP, 9, new StopCommand(this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_REWIND, 23, new WindCommand(this.model, surface, false));
        this.addTriggerCommand(Commands.COMMAND_FORWARD, 24, new WindCommand(this.model, surface, true));
        this.addTriggerCommand(Commands.COMMAND_LOOP, 20, new ToggleLoopCommand(this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_PAGE_LEFT, 22, new ModeMultiSelectCommand(this.model, surface, Modes.MODE_PARAMS, Modes.MODE_VOLUME, Modes.MODE_TRACK));
        this.addTriggerCommand(Commands.COMMAND_PAGE_RIGHT, 21, new ModeMultiSelectCommand(this.model, surface, Modes.MODE_TRACK, Modes.MODE_VOLUME, Modes.MODE_PARAMS));
        this.addTriggerCommand(Commands.COMMAND_MASTERTRACK, 1, new MainEncoderButtonCommand(this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_ARROW_DOWN, 13, new Kontrol1CursorCommand(CursorCommand.Direction.DOWN, this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_ARROW_UP, 16, new Kontrol1CursorCommand(CursorCommand.Direction.UP, this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_ARROW_LEFT, 14, new Kontrol1CursorCommand(CursorCommand.Direction.LEFT, this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_ARROW_RIGHT, 12, new Kontrol1CursorCommand(CursorCommand.Direction.RIGHT, this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_MUTE, 15, new BackButtonCommand(this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_SOLO, 3, new EnterButtonCommand(this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_BROWSE, 5, new BrowserCommand(Modes.MODE_BROWSER, this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_FADER_TOUCH_1, 25, new KnobRowTouchModeCommand(0, this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_FADER_TOUCH_2, 26, new KnobRowTouchModeCommand(1, this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_FADER_TOUCH_3, 27, new KnobRowTouchModeCommand(2, this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_FADER_TOUCH_4, 28, new KnobRowTouchModeCommand(3, this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_FADER_TOUCH_5, 29, new KnobRowTouchModeCommand(4, this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_FADER_TOUCH_6, 30, new KnobRowTouchModeCommand(5, this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_FADER_TOUCH_7, 31, new KnobRowTouchModeCommand(6, this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_FADER_TOUCH_8, 32, new KnobRowTouchModeCommand(7, this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_ROW1_1, 33, new NopCommand(this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_ROW1_2, 6, new NopCommand(this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_ROW1_3, 2, new NopCommand(this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_ROW1_4, 4, new NopCommand(this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_SHIFT, 17, new NopCommand(this.model, surface));
    }

    @Override
    protected void registerContinuousCommands() {
        Kontrol1ControlSurface surface = (Kontrol1ControlSurface)this.getSurface();
        for (int i = 0; i < 8; ++i) {
            this.addContinuousCommand(Commands.CONT_COMMAND_KNOB1 + i, 40 + i, new KnobRowModeCommand(i, this.model, surface));
        }
        this.addContinuousCommand(Commands.CONT_COMMAND_MASTER_KNOB, 48, new MainEncoderCommand(this.model, surface));
    }

    @Override
    public void startup() {
        Kontrol1ControlSurface surface = (Kontrol1ControlSurface)this.getSurface();
        surface.getViewManager().setActiveView(Views.VIEW_CONTROL);
        surface.getModeManager().setActiveMode(Modes.MODE_TRACK);
        this.usbDevice.pollUI();
    }

    @Override
    public void flush() {
        this.flushSurfaces();
    }
}

