/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.kontrol.osc.mkii.protocol;

import de.mossgrabers.controller.kontrol.osc.mkii.KontrolOSCConfiguration;
import de.mossgrabers.controller.kontrol.osc.mkii.TrackType;
import de.mossgrabers.framework.controller.IValueChanger;
import de.mossgrabers.framework.daw.IChannelBank;
import de.mossgrabers.framework.daw.ICursorDevice;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.ISceneBank;
import de.mossgrabers.framework.daw.ITrackBank;
import de.mossgrabers.framework.daw.ITransport;
import de.mossgrabers.framework.daw.data.EmptyTrackData;
import de.mossgrabers.framework.daw.data.IMasterTrack;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.osc.AbstractOpenSoundControlWriter;
import de.mossgrabers.framework.osc.IOpenSoundControlServer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class KontrolOSCWriter
extends AbstractOpenSoundControlWriter {
    private static final List<Object> DOUBLE_TRUE = new ArrayList<Object>();
    private final boolean is16;
    private final String daw;

    public KontrolOSCWriter(IHost host, IModel model, IOpenSoundControlServer oscServer, boolean is16, KontrolOSCConfiguration configuration) {
        super(host, model, oscServer, configuration);
        this.is16 = is16;
        this.daw = is16 ? "/dawctrl/" : "/live/";
    }

    @Override
    public void flush(boolean dump) {
        ArrayList ps;
        int trackType;
        if (!this.isConnected()) {
            return;
        }
        ITransport trans = this.model.getTransport();
        ITrackBank tb = this.model.getTrackBank();
        IChannelBank tbe = this.model.getEffectTrackBank();
        IMasterTrack masterTrack = this.model.getMasterTrack();
        ISceneBank sceneBank = this.model.getSceneBank();
        this.sendOSC(this.daw + "loop", trans.isLoop(), dump);
        this.sendOSC(this.daw + "undo_redo", DOUBLE_TRUE, dump);
        if (this.is16) {
            this.sendOSC(this.daw + "play", trans.isPlaying(), dump);
            this.sendOSC(this.daw + "record", trans.isRecording(), dump);
            this.sendOSC(this.daw + "session_record", trans.isLauncherOverdub(), dump);
            this.sendOSC(this.daw + "metronome", trans.isMetronomeOn(), dump);
        } else {
            this.sendOSC(this.daw + "play", trans.isPlaying() ? 2 : 1, dump);
            this.sendOSC(this.daw + "record", trans.isRecording() ? 2 : 1, dump);
            this.sendOSC(this.daw + "session_record", trans.isLauncherOverdub() ? 2 : 1, dump);
            this.sendOSC(this.daw + "metronome", (Object)(trans.isMetronomeOn() ? 2 : 1), dump);
        }
        this.sendOSC(this.daw + "session_automation_record", trans.isWritingClipLauncherAutomation(), dump);
        this.sendOSC(this.daw + "tempo", trans.getTempo(), dump);
        if (this.is16) {
            this.sendOSC(this.daw + "automation", trans.isWritingArrangerAutomation(), dump);
        }
        int trackCount = tb.getTrackCount();
        ArrayList params = new ArrayList();
        Collections.addAll(params, trackCount, sceneBank == null ? 0 : sceneBank.getSceneCount(), tbe == null ? 0 : tbe.getTrackCount());
        this.sendOSC(this.daw + "size", params, dump);
        ITrack selTrack = tb.getSelectedTrack();
        if (selTrack != null) {
            trackType = TrackType.toTrackType(selTrack.getType());
            ps = new ArrayList();
            Collections.addAll(ps, trackType, selTrack.getIndex(), "");
            if (this.is16) {
                this.sendOSC(this.daw + "track/view", ps, dump);
            } else {
                this.sendOSC(this.daw + "track", ps, dump);
            }
        }
        if (tbe != null && (selTrack = tbe.getSelectedTrack()) != null) {
            trackType = TrackType.toTrackType(selTrack.getType());
            ps = new ArrayList();
            if (this.is16) {
                Collections.addAll(ps, trackType, selTrack.getIndex(), "");
                this.sendOSC(this.daw + "track/view", ps, dump);
            } else {
                Collections.addAll(ps, trackType, selTrack.getIndex(), "");
                this.sendOSC(this.daw + "track", ps, dump);
            }
        }
        if (masterTrack.isSelected()) {
            ArrayList ps2 = new ArrayList();
            if (this.is16) {
                Collections.addAll(ps2, 4, 0, "");
                this.sendOSC(this.daw + "track/view", ps2, dump);
            } else {
                Collections.addAll(ps2, 4, 0, "");
                this.sendOSC(this.daw + "track", ps2, dump);
            }
        }
        this.sendTrackBank(this.is16, tb, trackCount, dump);
        if (tbe != null) {
            this.sendTrackBank(this.is16, tbe, trackCount, dump);
        }
        this.sendTrack(this.is16, 0, masterTrack, dump);
        if (this.is16) {
            this.sendOSC(this.daw + "track/device/instance-name", this.getKompleteInstance(), dump);
        } else {
            this.sendOSC("/track/device/instance-name", this.getKompleteInstance(), dump);
        }
        this.flush();
    }

    private void sendTrackBank(boolean is16, IChannelBank bank, int trackCount, boolean dump) {
        for (int i = 0; i < Math.min(trackCount, bank.getNumTracks()); ++i) {
            this.sendTrack(is16, i, bank.getTrack(i), dump);
        }
    }

    private void sendTrack(boolean is16, int trackIndex, ITrack track, boolean dump) {
        int trackType = TrackType.toTrackType(track.getType());
        IValueChanger valueChanger = this.model.getValueChanger();
        if (is16) {
            this.sendTrackOSC(this.daw + "track/volume", KontrolOSCWriter.createTrackValueParameter(trackType, trackIndex, Float.valueOf((float)valueChanger.toNormalizedValue(track.getVolume()))), dump);
            this.sendTrackOSC(this.daw + "track/pan", KontrolOSCWriter.createTrackValueParameter(trackType, trackIndex, Float.valueOf((float)(valueChanger.toNormalizedValue(track.getPan()) * 2.0 - 1.0))), dump);
            this.sendTrackVuOSC(this.daw + "track/meter", KontrolOSCWriter.createTrackValueParameter(trackType, trackIndex, 0, Float.valueOf((float)valueChanger.toNormalizedValue(track.getVuLeft()))), dump);
            this.sendTrackVuOSC(this.daw + "track/meter", KontrolOSCWriter.createTrackValueParameter(trackType, trackIndex, 1, Float.valueOf((float)valueChanger.toNormalizedValue(track.getVuRight()))), dump);
            this.sendTrackOSC(this.daw + "track/arm", KontrolOSCWriter.createTrackValueParameter(trackType, trackIndex, track.isRecArm() ? 1 : 0), dump);
            this.sendTrackOSC(this.daw + "track/mute", KontrolOSCWriter.createTrackValueParameter(trackType, trackIndex, track.isMute() ? 1 : 0), dump);
            this.sendTrackOSC(this.daw + "track/solo", KontrolOSCWriter.createTrackValueParameter(trackType, trackIndex, track.isSolo() ? 1 : 0), dump);
        } else {
            this.sendTrackOSC(this.daw + "volume", KontrolOSCWriter.createTrackValueParameter(trackType, trackIndex, Float.valueOf((float)valueChanger.toNormalizedValue(track.getVolume()))), dump);
            this.sendTrackOSC(this.daw + "pan", KontrolOSCWriter.createTrackValueParameter(trackType, trackIndex, Float.valueOf((float)(valueChanger.toNormalizedValue(track.getPan()) * 2.0 - 1.0))), dump);
            this.sendTrackVuOSC(this.daw + "meter", KontrolOSCWriter.createTrackValueParameter(trackIndex, trackType, 0, Float.valueOf((float)valueChanger.toNormalizedValue(track.getVuLeft()))), dump);
            this.sendTrackVuOSC(this.daw + "meter", KontrolOSCWriter.createTrackValueParameter(trackIndex, trackType, 1, Float.valueOf((float)valueChanger.toNormalizedValue(track.getVuRight()))), dump);
            this.sendTrackOSC(this.daw + "arm", KontrolOSCWriter.createTrackValueParameter(trackType, trackIndex, track.isRecArm() ? 1 : 0), dump);
            this.sendTrackOSC(this.daw + "mute", KontrolOSCWriter.createTrackValueParameter(trackType, trackIndex, track.isMute() ? 1 : 0), dump);
            this.sendTrackOSC(this.daw + "solo", KontrolOSCWriter.createTrackValueParameter(trackType, trackIndex, track.isSolo() ? 1 : 0), dump);
        }
        String cacheAddress = "/trackname/" + trackType + "/" + trackIndex;
        String name = track.getName();
        if (!KontrolOSCWriter.compareValues(this.oldValues.get(cacheAddress), name)) {
            this.oldValues.put(cacheAddress, name);
            this.sendTrackInfo(trackType, trackIndex);
        }
    }

    public void shutdown() {
        try {
            this.oscServer.sendMessage(this.host.createOSCMessage(this.daw + "shutdown", Collections.emptyList()));
        }
        catch (IOException ex) {
            this.model.getHost().error("Could not send shutdown message.", ex);
        }
    }

    public void sendTrackInfo(int trackType, int trackIndex) {
        if (trackIndex >= 0) {
            this.fastSendOSC(this.daw + "track/info", this.fillTrackInfoParameters(trackIndex, this.getTrack(trackType, trackIndex)));
        }
    }

    public ITrack getTrack(int trackType, int trackIndex) {
        switch (trackType) {
            case 4: {
                return this.model.getMasterTrack();
            }
            case 6: {
                break;
            }
            case 3: {
                IChannelBank effectTrackBank = this.model.getEffectTrackBank();
                if (effectTrackBank == null) break;
                int numTracks = effectTrackBank.getNumTracks();
                if (trackIndex >= numTracks) {
                    this.model.getHost().error("Track is outside of supported number of tracks (" + numTracks + "): " + trackIndex);
                    break;
                }
                return effectTrackBank.getTrack(trackIndex);
            }
            default: {
                ITrackBank trackBank = this.model.getTrackBank();
                if (trackBank == null) break;
                int numTracks = trackBank.getNumTracks();
                if (trackIndex >= numTracks) {
                    this.model.getHost().error("Track is outside of supported number of tracks (" + numTracks + "): " + trackIndex);
                    break;
                }
                return trackBank.getTrack(trackIndex);
            }
        }
        return EmptyTrackData.INSTANCE;
    }

    private void sendTrackVuOSC(String address, List<Object> values, boolean dump) {
        ArrayList<Object> testValues = new ArrayList<Object>(values);
        String cacheAddress = address + "/" + testValues.remove(0) + "/" + testValues.remove(0) + "/" + testValues.remove(0);
        this.sendOSC(cacheAddress, address, testValues, values, dump);
    }

    private void sendTrackOSC(String address, List<Object> values, boolean dump) {
        ArrayList<Object> testValues = new ArrayList<Object>(values);
        String cacheAddress = address + "/" + testValues.remove(0) + "/" + testValues.remove(0);
        this.sendOSC(cacheAddress, address, testValues, values, dump);
    }

    private String getKompleteInstance() {
        ICursorDevice instrumentDevice = this.model.getPrimaryDevice();
        if (instrumentDevice.doesExist() && instrumentDevice.getName().startsWith("Komplete Kontrol")) {
            return "NIKB00";
        }
        return "";
    }

    private List<Object> fillTrackInfoParameters(int trackIndex, ITrack track) {
        IValueChanger valueChanger = this.model.getValueChanger();
        ArrayList<Object> parameters = new ArrayList<Object>();
        parameters.add(TrackType.toTrackType(track.getType()));
        parameters.add(trackIndex);
        parameters.add(track.getName());
        parameters.add(1);
        parameters.add(track.isRecArm() ? 1 : 0);
        parameters.add(track.isSolo() ? 1 : 0);
        parameters.add(track.isMute() ? 1 : 0);
        parameters.add(Float.valueOf((float)valueChanger.toNormalizedValue(track.getVolume())));
        parameters.add(Float.valueOf((float)(valueChanger.toNormalizedValue(track.getPan()) * 2.0 - 1.0)));
        return parameters;
    }

    private static List<Object> createTrackValueParameter(int trackType, int trackIndex, Object ... values) {
        ArrayList<Object> parameters = new ArrayList<Object>();
        parameters.add(trackType);
        parameters.add(trackIndex);
        Collections.addAll(parameters, values);
        return parameters;
    }

    @Override
    protected boolean isHeartbeatMessage(String address) {
        return address.contains("pong");
    }

    static {
        Collections.addAll(DOUBLE_TRUE, 1, 1);
    }
}

