/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.kontrol.osc.mkii.protocol;

import de.mossgrabers.controller.kontrol.osc.mkii.KontrolOSCConfiguration;
import de.mossgrabers.controller.kontrol.osc.mkii.protocol.KontrolOSCWriter;
import de.mossgrabers.framework.command.trigger.clip.NewCommand;
import de.mossgrabers.framework.controller.DummyControlSurface;
import de.mossgrabers.framework.daw.IChannelBank;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.ITrackBank;
import de.mossgrabers.framework.daw.data.ISlot;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.osc.AbstractOpenSoundControlParser;
import de.mossgrabers.framework.osc.IOpenSoundControlConfiguration;
import de.mossgrabers.framework.osc.IOpenSoundControlMessage;
import de.mossgrabers.framework.osc.IOpenSoundControlWriter;
import de.mossgrabers.framework.utils.ButtonEvent;
import java.util.Collections;
import java.util.LinkedList;

public class KontrolOSCParser
extends AbstractOpenSoundControlParser {
    private static final int[] DOUBLE_TRUE = new int[]{1, 1};
    private final String daw;
    private boolean is16;
    private DummyControlSurface<KontrolOSCConfiguration> surface;

    public KontrolOSCParser(IHost host, DummyControlSurface<KontrolOSCConfiguration> surface, IModel model, IOpenSoundControlConfiguration configuration, IOpenSoundControlWriter writer, boolean is16) {
        super(host, model, null, configuration, writer);
        this.surface = surface;
        this.is16 = is16;
        this.daw = is16 ? "dawctrl" : "live";
        this.model.getCurrentTrackBank().setIndication(true);
    }

    @Override
    public void handle(IOpenSoundControlMessage message) {
        LinkedList<String> oscParts = KontrolOSCParser.parseAddress(message.getAddress());
        if (oscParts.isEmpty()) {
            return;
        }
        this.logMessage(message);
        String command = oscParts.removeFirst();
        if ("script".equals(command)) {
            this.parseHostCommands(oscParts);
        } else if (this.daw.equals(command)) {
            this.parseDAWCommands(message, oscParts, message.getValues());
        } else {
            this.host.println("Unknown OSC Command: " + message.getAddress());
        }
    }

    private void parseHostCommands(LinkedList<String> oscParts) {
        String subCommand;
        if (oscParts.isEmpty()) {
            this.host.error("Missing Script subcommand.");
            return;
        }
        switch (subCommand = oscParts.get(0)) {
            case "ping": {
                this.writer.fastSendOSC("/script/pong");
                break;
            }
            case "init": {
                this.host.println("Init received...");
                this.writer.flush(true);
                break;
            }
            default: {
                this.host.error("Unknown Script subcommand: " + subCommand);
            }
        }
    }

    private void parseDAWCommands(IOpenSoundControlMessage message, LinkedList<String> oscParts, Object[] objects) {
        if (oscParts.isEmpty()) {
            this.host.error("Missing DAW subcommand.");
            return;
        }
        String subCommand = oscParts.removeFirst();
        if (this.parseTransportCommands(subCommand, oscParts, objects)) {
            return;
        }
        if (this.parseGlobalCommands(subCommand)) {
            return;
        }
        switch (subCommand) {
            case "ping": {
                this.writer.fastSendOSC("/dawctrl/pong");
                break;
            }
            case "init": {
                this.host.println("Init received...");
                this.writer.flush(true);
                break;
            }
            case "volume": 
            case "pan": 
            case "arm": 
            case "mute": 
            case "solo": {
                this.parseTrackCommands(subCommand, objects);
                break;
            }
            case "track": {
                if (oscParts.isEmpty()) {
                    this.host.error("Missing Track command.");
                    return;
                }
                this.parseTrackCommands(oscParts.removeFirst(), objects);
                break;
            }
            case "return": {
                if (oscParts.isEmpty()) {
                    this.host.error("Missing Track Return command.");
                    return;
                }
                if (!"view".equals(oscParts.removeFirst())) break;
                int trackIndex = KontrolOSCParser.toIntValue(objects);
                IChannelBank effectTrackBank = this.model.getEffectTrackBank();
                if (effectTrackBank == null) break;
                effectTrackBank.getTrack(trackIndex).selectAndMakeVisible();
                break;
            }
            case "master": {
                if (oscParts.isEmpty()) {
                    this.host.error("Missing Master command.");
                    return;
                }
                if (!"view".equals(oscParts.removeFirst())) break;
                this.model.getMasterTrack().selectAndMakeVisible();
                break;
            }
            case "scene": {
                if (oscParts.isEmpty()) {
                    this.host.error("Missing Scene command.");
                    return;
                }
                this.parseSceneCommands(oscParts.removeFirst(), objects);
                break;
            }
            default: {
                this.host.println("Unknown DAW Subcommand: " + message.getAddress());
            }
        }
    }

    private boolean parseGlobalCommands(String command) {
        switch (command) {
            case "undo": {
                this.model.getApplication().undo();
                this.sendOSC("undo_redo", DOUBLE_TRUE);
                return true;
            }
            case "redo": {
                this.model.getApplication().redo();
                this.sendOSC("undo_redo", DOUBLE_TRUE);
                return true;
            }
        }
        return false;
    }

    private boolean parseTransportCommands(String command, LinkedList<String> oscParts, Object[] objects) {
        int numValue = KontrolOSCParser.toIntValue(objects);
        switch (command) {
            case "play": {
                String subCommand;
                if (oscParts.isEmpty()) {
                    if (!this.transport.isPlaying()) {
                        this.transport.play();
                    }
                    return true;
                }
                switch (subCommand = oscParts.remove()) {
                    case "scene": {
                        this.model.getSceneBank().launchScene(KontrolOSCParser.toIntValue(0, objects));
                        break;
                    }
                    case "clipslot": 
                    case "clip": {
                        IChannelBank tb = this.model.getCurrentTrackBank();
                        if (tb == null) break;
                        int trackIndex = KontrolOSCParser.toIntValue(0, objects);
                        int sceneIndex = KontrolOSCParser.toIntValue(1, objects);
                        tb.getTrack(trackIndex).getSlot(sceneIndex).launch();
                        break;
                    }
                    default: {
                        this.host.error("Unknown Play sub-command: " + subCommand);
                    }
                }
                return true;
            }
            case "record": {
                if (numValue > 0) {
                    this.handleShiftedRecordButton();
                }
                return true;
            }
            case "session_record": {
                if (numValue > 0) {
                    this.handleRecordButton();
                }
                return true;
            }
            case "automation": {
                if (numValue == 0 && this.transport.isWritingArrangerAutomation()) {
                    this.transport.toggleWriteArrangerAutomation();
                    return true;
                }
                if (numValue == 1 && !this.transport.isWritingArrangerAutomation()) {
                    this.transport.toggleWriteArrangerAutomation();
                    return true;
                }
                return true;
            }
            case "session_automation_record": {
                if (numValue == 0 && this.transport.isWritingClipLauncherAutomation()) {
                    this.transport.toggleWriteClipLauncherAutomation();
                    return true;
                }
                if (numValue == 1 && !this.transport.isWritingClipLauncherAutomation()) {
                    this.transport.toggleWriteClipLauncherAutomation();
                    return true;
                }
                return true;
            }
            case "stop": {
                String cmd;
                if (oscParts.isEmpty()) {
                    if (this.transport.isPlaying()) {
                        this.transport.play();
                    } else {
                        this.transport.stopAndRewind();
                    }
                    return true;
                }
                switch (cmd = oscParts.remove()) {
                    case "all_clips": {
                        this.model.getCurrentTrackBank().stop();
                        break;
                    }
                    case "track": {
                        this.model.getCurrentTrackBank().getTrack(KontrolOSCParser.toIntValue(0, objects)).stop();
                        break;
                    }
                    case "clip": {
                        this.model.getCurrentTrackBank().getTrack(KontrolOSCParser.toIntValue(0, objects)).stop();
                        break;
                    }
                    default: {
                        this.host.error("Unknown Stop sub-command: " + cmd);
                    }
                }
                return true;
            }
            case "loop": {
                this.transport.setLoop(numValue > 0);
                return true;
            }
            case "metronome": {
                this.transport.setMetronome(numValue > 0);
                return true;
            }
            case "tap_tempo": {
                this.transport.tapTempo();
                return true;
            }
            case "clip": {
                if (!oscParts.isEmpty() && oscParts.poll().equals("quantize")) {
                    this.model.getCursorClip(8, 8).quantize(1.0);
                }
                return true;
            }
            case "scrub": {
                this.transport.changePosition(numValue > 0);
                return true;
            }
            case "midi_arm_exclusive": {
                return true;
            }
        }
        return false;
    }

    private void handleShiftedRecordButton() {
        this.handleRecord(((KontrolOSCConfiguration)this.configuration).getShiftedRecordButtonFunction());
    }

    private void handleRecordButton() {
        this.handleRecord(((KontrolOSCConfiguration)this.configuration).getRecordButtonFunction());
    }

    private void handleRecord(int recordMode) {
        switch (recordMode) {
            case 0: {
                this.transport.record();
                break;
            }
            case 1: {
                ISlot selectedSlot = this.model.getSelectedSlot();
                if (selectedSlot == null) break;
                selectedSlot.record();
                break;
            }
            case 2: {
                new NewCommand(this.model, this.surface).executeNormal(ButtonEvent.DOWN);
                break;
            }
            case 3: {
                this.transport.toggleOverdub();
                break;
            }
            case 4: {
                this.transport.toggleLauncherOverdub();
                break;
            }
        }
    }

    private void parseTrackCommands(String command, Object[] values) {
        switch (command) {
            case "info": {
                int[] vs = KontrolOSCParser.toIntValues(values);
                if (vs.length != 2) {
                    return;
                }
                ((KontrolOSCWriter)this.writer).sendTrackInfo(vs[0], vs[1]);
                break;
            }
            case "view": {
                ITrackBank tb = this.model.getTrackBank();
                if (this.is16) {
                    int trackPosition = KontrolOSCParser.toIntValue(1, values);
                    if (trackPosition < 0) {
                        int trackIndex = tb.getTrackCount() + trackPosition;
                        tb.getTrack(trackIndex).selectAndMakeVisible();
                        break;
                    }
                    IChannelBank tbe = this.model.getEffectTrackBank();
                    if (tbe != null && trackPosition < tbe.getTrackCount()) {
                        tbe.getTrack(trackPosition).selectAndMakeVisible();
                        break;
                    }
                    this.model.getMasterTrack().selectAndMakeVisible();
                    break;
                }
                int trackIndex = KontrolOSCParser.toIntValue(values);
                tb.getTrack(trackIndex).selectAndMakeVisible();
                break;
            }
            case "arm": {
                this.getTrack(values).setRecArm(KontrolOSCParser.toIntValue(2, values) > 0);
                break;
            }
            case "mute": {
                this.getTrack(values).setMute(KontrolOSCParser.toIntValue(2, values) > 0);
                break;
            }
            case "solo": {
                this.getTrack(values).setSolo(KontrolOSCParser.toIntValue(2, values) > 0);
                break;
            }
            case "volume": {
                this.getTrack(values).setVolume(this.model.getValueChanger().fromNormalizedValue(KontrolOSCParser.toNumValue(2, values).doubleValue()));
                break;
            }
            case "pan": {
                this.getTrack(values).setPan(this.model.getValueChanger().fromNormalizedValue((KontrolOSCParser.toNumValue(2, values).doubleValue() + 1.0) / 2.0));
                break;
            }
            default: {
                this.host.println("Unknown Track Command: " + command);
            }
        }
    }

    private void parseSceneCommands(String command, Object[] values) {
        switch (command) {
            case "view": {
                ITrack selectedTrack = this.model.getSelectedTrack();
                if (selectedTrack == null) {
                    return;
                }
                int sceneIndex = KontrolOSCParser.toIntValue(values);
                selectedTrack.getSlot(sceneIndex).select();
                this.sendOSC("scene", new int[]{sceneIndex});
                break;
            }
            default: {
                this.host.println("Unknown Scene Command: " + command);
            }
        }
    }

    private ITrack getTrack(Object[] values) {
        return ((KontrolOSCWriter)this.writer).getTrack(KontrolOSCParser.toIntValue(0, values), KontrolOSCParser.toIntValue(1, values));
    }

    private void sendOSC(String command, int[] numbers) {
        this.writer.fastSendOSC("/" + this.daw + '/' + command, numbers);
    }

    private static LinkedList<String> parseAddress(String address) {
        LinkedList<String> oscParts = new LinkedList<String>();
        Collections.addAll(oscParts, address.split("/"));
        oscParts.removeFirst();
        return oscParts;
    }

    private static int toIntValue(Object[] objects) {
        return KontrolOSCParser.toNumValue(0, objects).intValue();
    }

    private static int toIntValue(int index, Object[] values) {
        return KontrolOSCParser.toNumValue(index, values).intValue();
    }

    private static Number toNumValue(int index, Object[] objects) {
        return objects != null && index < objects.length ? (Number)KontrolOSCParser.toNumber(objects[index]) : (Number)-1;
    }

    private static int[] toIntValues(Object[] values) {
        int[] result = new int[values.length];
        for (int i = 0; i < values.length; ++i) {
            result[i] = KontrolOSCParser.toNumber(values[i]).intValue();
        }
        return result;
    }

    private static Number toNumber(Object value) {
        return value == null || !(value instanceof Number) ? (Number)-1 : (Number)((Number)value);
    }

    @Override
    protected boolean isHeartbeatMessage(String address) {
        return address.contains("ping");
    }
}

