/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.kontrol.osc.mkii;

import de.mossgrabers.framework.daw.resource.ChannelType;

public class TrackType {
    public static final int GENERIC = 5;
    public static final int AUDIO = 1;
    public static final int MIDI = 0;
    public static final int GROUP = 2;
    public static final int RETURN_BUS = 3;
    public static final int MASTER = 4;
    public static final int EMPTY = 6;

    private TrackType() {
    }

    public static ChannelType toChannelType(int trackType) {
        switch (trackType) {
            case 5: {
                return ChannelType.HYBRID;
            }
            case 1: {
                return ChannelType.AUDIO;
            }
            case 0: {
                return ChannelType.INSTRUMENT;
            }
            case 2: {
                return ChannelType.GROUP;
            }
            case 3: {
                return ChannelType.EFFECT;
            }
            case 4: {
                return ChannelType.MASTER;
            }
        }
        return ChannelType.UNKNOWN;
    }

    public static int toTrackType(ChannelType channelType) {
        switch (channelType) {
            case HYBRID: {
                return 5;
            }
            case AUDIO: {
                return 1;
            }
            case INSTRUMENT: {
                return 0;
            }
            case GROUP: {
                return 2;
            }
            case EFFECT: {
                return 3;
            }
            case MASTER: {
                return 4;
            }
        }
        return 6;
    }
}

