/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.kontrol.osc.mkii;

import de.mossgrabers.controller.kontrol.osc.mkii.KontrolOSCConfiguration;
import de.mossgrabers.controller.kontrol.osc.mkii.protocol.KontrolOSCParser;
import de.mossgrabers.controller.kontrol.osc.mkii.protocol.KontrolOSCWriter;
import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.configuration.ISettingsUI;
import de.mossgrabers.framework.controller.AbstractControllerSetup;
import de.mossgrabers.framework.controller.DefaultValueChanger;
import de.mossgrabers.framework.controller.DummyControlSurface;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.controller.ISetupFactory;
import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.osc.IOpenSoundControlConfiguration;
import de.mossgrabers.framework.osc.IOpenSoundControlServer;
import de.mossgrabers.framework.scale.Scales;

public class KontrolOSCControllerSetup
extends AbstractControllerSetup<IControlSurface<KontrolOSCConfiguration>, KontrolOSCConfiguration> {
    public static final boolean IS_16 = false;
    private KontrolOSCWriter writer;

    public KontrolOSCControllerSetup(IHost host, ISetupFactory factory, ISettingsUI settings) {
        super(factory, host, settings);
        this.colorManager = new ColorManager();
        this.valueChanger = new DefaultValueChanger(128, 1, 0.5);
        this.configuration = new KontrolOSCConfiguration(this.valueChanger);
    }

    @Override
    public void flush() {
        this.writer.flush(false);
    }

    @Override
    protected void createScales() {
        this.scales = new Scales(this.valueChanger, 0, 128, 128, 1);
        this.scales.setChromatic(true);
    }

    @Override
    protected void createModel() {
        this.model = this.factory.createModel(this.colorManager, this.valueChanger, this.scales, 128, 128, 0, 0, 0, true, 0, 0, 0, 0);
    }

    @Override
    protected void createSurface() {
        this.factory.createMidiAccess().createInput("Kontrol OSC Midi", new String[0]);
        DummyControlSurface<Configuration> surface = new DummyControlSurface<Configuration>(this.model.getHost(), this.colorManager, this.configuration);
        this.surfaces.add(surface);
        IOpenSoundControlServer oscServer = this.host.connectToOSCServer(((KontrolOSCConfiguration)this.configuration).getSendHost(), ((KontrolOSCConfiguration)this.configuration).getSendPort());
        this.writer = new KontrolOSCWriter(this.host, this.model, oscServer, false, (KontrolOSCConfiguration)this.configuration);
        this.host.createOSCServer(new KontrolOSCParser(this.host, surface, this.model, (IOpenSoundControlConfiguration)((Object)this.configuration), this.writer, false), ((KontrolOSCConfiguration)this.configuration).getReceivePort());
    }

    @Override
    public void startup() {
        this.host.scheduleTask(() -> this.writer.flush(true), 1000L);
    }

    @Override
    public void exit() {
        this.writer.shutdown();
        super.exit();
    }
}

