/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.kontrol.osc.mkii;

import de.mossgrabers.framework.configuration.IEnumSetting;
import de.mossgrabers.framework.configuration.ISettingsUI;
import de.mossgrabers.framework.controller.IValueChanger;
import de.mossgrabers.framework.osc.AbstractOpenSoundControlConfiguration;

public class KontrolOSCConfiguration
extends AbstractOpenSoundControlConfiguration {
    public static final int RECORD_ARRANGER = 0;
    public static final int RECORD_CLIP = 1;
    public static final int NEW_CLIP = 2;
    public static final int TOGGLE_ARRANGER_OVERDUB = 3;
    public static final int TOGGLE_CLIP_OVERDUB = 4;
    private static final int DEFAULT_SEND_PORT = 7575;
    private static final int DEFAULT_RECEIVE_PORT = 7576;
    private static final String[] RECORD_OPTIONS = new String[]{"Record arranger", "Record clip", "New clip", "Toggle arranger overdub", "Toggle clip overdub"};
    private static final Integer RECORD_BUTTON_FUNCTION = 50;
    private static final Integer SHIFTED_RECORD_BUTTON_FUNCTION = 51;
    private int receivePort = 7576;
    private String sendHost = "127.0.0.1";
    private int sendPort = 7575;
    private int recordButtonFunction = 0;
    private int shiftedRecordButtonFunction = 1;

    public KontrolOSCConfiguration(IValueChanger valueChanger) {
        super(valueChanger);
    }

    @Override
    public void init(ISettingsUI settingsUI) {
        IEnumSetting recordButtonSetting = settingsUI.getEnumSetting("Record button", "Transport", RECORD_OPTIONS, RECORD_OPTIONS[1]);
        recordButtonSetting.addValueObserver(value -> {
            for (int i = 0; i < RECORD_OPTIONS.length; ++i) {
                if (!RECORD_OPTIONS[i].equals(value)) continue;
                this.recordButtonFunction = i;
            }
            this.notifyObservers(RECORD_BUTTON_FUNCTION);
        });
        IEnumSetting shiftedRecordButtonSetting = settingsUI.getEnumSetting("Shift + Record button", "Transport", RECORD_OPTIONS, RECORD_OPTIONS[0]);
        shiftedRecordButtonSetting.addValueObserver(value -> {
            for (int i = 0; i < RECORD_OPTIONS.length; ++i) {
                if (!RECORD_OPTIONS[i].equals(value)) continue;
                this.shiftedRecordButtonFunction = i;
            }
            this.notifyObservers(SHIFTED_RECORD_BUTTON_FUNCTION);
        });
        this.activateOSCLogging(settingsUI);
    }

    public int getReceivePort() {
        return this.receivePort;
    }

    public String getSendHost() {
        return this.sendHost;
    }

    public int getSendPort() {
        return this.sendPort;
    }

    public int getRecordButtonFunction() {
        return this.recordButtonFunction;
    }

    public int getShiftedRecordButtonFunction() {
        return this.shiftedRecordButtonFunction;
    }
}

