/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.generic;

import de.mossgrabers.controller.generic.GenericFlexiConfiguration;
import de.mossgrabers.controller.generic.controller.GenericFlexiControlSurface;
import de.mossgrabers.framework.configuration.ISettingsUI;
import de.mossgrabers.framework.controller.AbstractControllerSetup;
import de.mossgrabers.framework.controller.DefaultValueChanger;
import de.mossgrabers.framework.controller.ISetupFactory;
import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.controller.display.DummyDisplay;
import de.mossgrabers.framework.daw.ICursorDevice;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.midi.IMidiAccess;
import de.mossgrabers.framework.daw.midi.IMidiInput;
import de.mossgrabers.framework.daw.midi.IMidiOutput;
import de.mossgrabers.framework.scale.Scales;

public class GenericFlexiControllerSetup
extends AbstractControllerSetup<GenericFlexiControlSurface, GenericFlexiConfiguration> {
    public GenericFlexiControllerSetup(IHost host, ISetupFactory factory, ISettingsUI settings) {
        super(factory, host, settings);
        this.colorManager = new ColorManager();
        this.valueChanger = new DefaultValueChanger(128, 1, 0.5);
        this.configuration = new GenericFlexiConfiguration(this.valueChanger);
    }

    @Override
    public void flush() {
        this.flushSurfaces();
    }

    @Override
    protected void createScales() {
        this.scales = new Scales(this.valueChanger, 36, 100, 8, 8);
    }

    @Override
    protected void createModel() {
        this.model = this.factory.createModel(this.colorManager, this.valueChanger, this.scales, 8, 8, 8, 16, 16, true, -1, -1, -1, -1);
        this.model.getTrackBank().setIndication(true);
        ICursorDevice cursorDevice = this.model.getCursorDevice();
        for (int i = 0; i < cursorDevice.getNumParameters(); ++i) {
            cursorDevice.getFXParam(i).setIndication(true);
        }
    }

    @Override
    protected void createSurface() {
        IMidiAccess midiAccess = this.factory.createMidiAccess();
        IMidiOutput output = midiAccess.createOutput();
        IMidiInput input = midiAccess.createInput("Generic Flexi", new String[0]);
        GenericFlexiControlSurface surface = new GenericFlexiControlSurface(this.model.getHost(), this.model, this.colorManager, (GenericFlexiConfiguration)this.configuration, output, input);
        this.surfaces.add(surface);
        surface.setDisplay(new DummyDisplay(this.host));
    }

    @Override
    public void startup() {
        this.host.scheduleTask(() -> ((GenericFlexiControlSurface)this.getSurface()).updateKeyTranslation(), 2000L);
    }
}

