/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.generic;

import de.mossgrabers.controller.generic.CommandSlot;
import de.mossgrabers.controller.generic.controller.FlexiCommand;
import de.mossgrabers.framework.configuration.AbstractConfiguration;
import de.mossgrabers.framework.configuration.IEnumSetting;
import de.mossgrabers.framework.configuration.ISettingsUI;
import de.mossgrabers.framework.configuration.IStringSetting;
import de.mossgrabers.framework.controller.IValueChanger;
import de.mossgrabers.framework.scale.Scales;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Properties;

public class GenericFlexiConfiguration
extends AbstractConfiguration {
    public static final Integer BUTTON_EXPORT = 50;
    public static final Integer BUTTON_IMPORT = 51;
    public static final int NUM_SLOTS = 200;
    private IStringSetting fileSetting;
    private IEnumSetting addTypeSetting;
    private IEnumSetting addNumberSetting;
    private IEnumSetting addMidiChannelSetting;
    private CommandSlot[] commandSlots = new CommandSlot[200];
    private String filename;
    private int addTypeValue;
    private int addNumberValue;
    private int addMidiChannel;
    private Object syncMapUpdate = new Object();
    private int[] keyMap;

    public GenericFlexiConfiguration(IValueChanger valueChanger) {
        super(valueChanger);
    }

    @Override
    public void init(ISettingsUI settingsUI) {
        String category = "Ex-/Import";
        this.fileSetting = settingsUI.getStringSetting("Filename to ex-/import:", category, -1, "");
        this.fileSetting.addValueObserver(value -> {
            this.filename = value;
        });
        if (!GraphicsEnvironment.isHeadless()) {
            settingsUI.getSignalSetting(" ", category, "Select").addValueObserver(Void2 -> {
                FileDialog fileDialog = new FileDialog((Frame)null);
                fileDialog.setVisible(true);
                String fn = fileDialog.getFile();
                if (fn == null) {
                    return;
                }
                File file = new File(fileDialog.getDirectory(), fn);
                this.fileSetting.set(file.getAbsolutePath());
            });
        }
        settingsUI.getSignalSetting("  ", category, "Export").addValueObserver(Void2 -> this.notifyObservers(BUTTON_EXPORT));
        settingsUI.getSignalSetting("   ", category, "Import").addValueObserver(Void2 -> this.notifyObservers(BUTTON_IMPORT));
        category = "Use a knob/fader/button to set, then click add...";
        this.addTypeSetting = settingsUI.getEnumSetting("Type:", category, CommandSlot.OPTIONS_TYPE, CommandSlot.OPTIONS_TYPE[0]);
        this.addTypeSetting.addValueObserver(value -> {
            this.addTypeValue = GenericFlexiConfiguration.lookupIndex(CommandSlot.OPTIONS_TYPE, value);
        });
        this.addNumberSetting = settingsUI.getEnumSetting("Number:", category, CommandSlot.OPTIONS_NUMBER, CommandSlot.OPTIONS_NUMBER[0]);
        this.addNumberSetting.addValueObserver(value -> {
            this.addNumberValue = Integer.parseInt(value);
        });
        this.addMidiChannelSetting = settingsUI.getEnumSetting("Midi channel:", category, CommandSlot.OPTIONS_MIDI_CHANNEL, CommandSlot.OPTIONS_MIDI_CHANNEL[0]);
        this.addMidiChannelSetting.addValueObserver(value -> {
            this.addMidiChannel = GenericFlexiConfiguration.lookupIndex(CommandSlot.OPTIONS_MIDI_CHANNEL, value);
        });
        settingsUI.getSignalSetting(" ", category, "Add").addValueObserver(Void2 -> {
            CommandSlot slot = this.findEmptySlot();
            if (slot == null) {
                return;
            }
            slot.set(this.addTypeValue, this.addNumberValue, this.addMidiChannel);
            slot.setVisibility(true);
        });
        for (int i = 0; i < 200; ++i) {
            this.commandSlots[i] = new CommandSlot("Slot " + (i + 1), settingsUI);
            this.commandSlots[i].addTypeValueObserver(v -> {
                Object object = this.syncMapUpdate;
                synchronized (object) {
                    this.keyMap = null;
                }
            });
        }
    }

    private CommandSlot findEmptySlot() {
        for (CommandSlot commandSlot : this.commandSlots) {
            if (commandSlot.getCommand() != FlexiCommand.OFF) continue;
            return commandSlot;
        }
        return null;
    }

    public void setAddValues(String type, int number, int midiChannel) {
        this.addTypeSetting.set(type);
        this.addNumberSetting.set(Integer.toString(number));
        this.addMidiChannelSetting.set(Integer.toString(midiChannel + 1));
    }

    public int getSlotCommand(int type, int number, int midiChannel) {
        for (int i = 0; i < this.commandSlots.length; ++i) {
            CommandSlot slot = this.commandSlots[i];
            if (slot.getCommand() == FlexiCommand.OFF || slot.getType() != type || slot.getMidiChannel() != midiChannel || slot.getNumber() != number) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getNoteMap() {
        Object object = this.syncMapUpdate;
        synchronized (object) {
            if (this.keyMap == null) {
                this.keyMap = Scales.getIdentityMatrix();
                for (CommandSlot slot : this.commandSlots) {
                    if (slot.getCommand() == FlexiCommand.OFF || slot.getType() != CommandSlot.TYPE_NOTE) continue;
                    this.keyMap[slot.getNumber()] = -1;
                }
            }
            return this.keyMap;
        }
    }

    public CommandSlot[] getCommandSlots() {
        return this.commandSlots;
    }

    public String getFilename() {
        return this.filename;
    }

    public void exportTo(File exportFile) throws IOException {
        Properties props = new Properties();
        for (int i = 0; i < this.commandSlots.length; ++i) {
            String slotName = "SLOT" + i + "_";
            CommandSlot slot = this.commandSlots[i];
            props.put(slotName + "TYPE", Integer.toString(slot.getType()));
            props.put(slotName + "NUMBER", Integer.toString(slot.getNumber()));
            props.put(slotName + "MIDI_CHANNEL", Integer.toString(slot.getMidiChannel()));
            props.put(slotName + "KNOB_MODE", Integer.toString(slot.getKnobMode()));
            props.put(slotName + "COMMAND", slot.getCommand().getName());
            props.put(slotName + "SEND_VALUE", Boolean.toString(slot.isSendValue()));
        }
        try (FileWriter writer = new FileWriter(exportFile);){
            props.store(writer, "Generic Flexi");
        }
    }

    public void importFrom(File importFile) throws IOException {
        Properties props = new Properties();
        try (FileReader reader = new FileReader(importFile);){
            props.load(reader);
        }
        for (int i = 0; i < this.commandSlots.length; ++i) {
            String slotName = "SLOT" + i + "_";
            CommandSlot slot = this.commandSlots[i];
            slot.setType(props.getProperty(slotName + "TYPE"));
            slot.setNumber(props.getProperty(slotName + "NUMBER"));
            slot.setMidiChannel(props.getProperty(slotName + "MIDI_CHANNEL"));
            slot.setKnobMode(props.getProperty(slotName + "KNOB_MODE"));
            slot.setCommand(props.getProperty(slotName + "COMMAND"));
            slot.setSendValue(props.getProperty(slotName + "SEND_VALUE"));
        }
    }
}

