/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.generic;

import de.mossgrabers.controller.generic.controller.FlexiCommand;
import de.mossgrabers.framework.configuration.AbstractConfiguration;
import de.mossgrabers.framework.configuration.IEnumSetting;
import de.mossgrabers.framework.configuration.ISettingsUI;
import de.mossgrabers.framework.configuration.IValueObserver;

public class CommandSlot {
    private static final String[] OPTIONS_KNOBMODE;
    public static final String[] OPTIONS_TYPE;
    public static int TYPE_CC;
    public static int TYPE_NOTE;
    public static int TYPE_PROGRAM_CHANGE;
    public static final String[] OPTIONS_NUMBER;
    public static final String[] OPTIONS_MIDI_CHANNEL;
    private static final String[] NAMES;
    private final IEnumSetting typeSetting;
    private final IEnumSetting numberSetting;
    private final IEnumSetting midiChannelSetting;
    private final IEnumSetting functionSetting;
    private final IEnumSetting knobModeSetting;
    private final IEnumSetting sendValueSetting;
    private int type = 0;
    private int number = 0;
    private int midiChannel = 0;
    private int knobMode = 0;
    private FlexiCommand command = FlexiCommand.OFF;
    private boolean sendValue;

    public CommandSlot(String category, ISettingsUI settingsUI) {
        this.typeSetting = settingsUI.getEnumSetting("Type:", category, OPTIONS_TYPE, OPTIONS_TYPE[0]);
        this.numberSetting = settingsUI.getEnumSetting("Number:", category, OPTIONS_NUMBER, OPTIONS_NUMBER[0]);
        this.midiChannelSetting = settingsUI.getEnumSetting("Midi Channel:", category, OPTIONS_MIDI_CHANNEL, OPTIONS_MIDI_CHANNEL[0]);
        this.knobModeSetting = settingsUI.getEnumSetting("Knob Mode:", category, OPTIONS_KNOBMODE, OPTIONS_KNOBMODE[0]);
        this.functionSetting = settingsUI.getEnumSetting("Function:", category, NAMES, NAMES[0]);
        this.sendValueSetting = settingsUI.getEnumSetting("Send value to device:", category, AbstractConfiguration.ON_OFF_OPTIONS, AbstractConfiguration.ON_OFF_OPTIONS[1]);
        this.numberSetting.addValueObserver(value -> {
            this.number = AbstractConfiguration.lookupIndex(OPTIONS_NUMBER, value);
        });
        this.midiChannelSetting.addValueObserver(value -> {
            this.midiChannel = AbstractConfiguration.lookupIndex(OPTIONS_MIDI_CHANNEL, value);
        });
        this.knobModeSetting.addValueObserver(value -> {
            int km;
            this.knobMode = km = AbstractConfiguration.lookupIndex(OPTIONS_KNOBMODE, value);
            if (this.command.isTrigger() && km > 0) {
                this.knobMode = 0;
                this.knobModeSetting.set(OPTIONS_KNOBMODE[0]);
            }
        });
        this.typeSetting.addValueObserver(value -> {
            this.type = AbstractConfiguration.lookupIndex(OPTIONS_TYPE, value);
            this.sendValueSetting.setVisible(this.type == TYPE_CC);
        });
        this.functionSetting.addValueObserver(value -> {
            this.setVisibility(!NAMES[0].equals(value));
            this.command = FlexiCommand.lookupByName(value);
            if (this.command.isTrigger() && this.knobMode > 0) {
                this.knobMode = 0;
                this.knobModeSetting.set(OPTIONS_KNOBMODE[0]);
            }
        });
        this.sendValueSetting.addValueObserver(value -> {
            this.sendValue = AbstractConfiguration.lookupIndex(AbstractConfiguration.ON_OFF_OPTIONS, value) > 0;
        });
    }

    public void setVisibility(boolean visible) {
        this.typeSetting.setVisible(visible);
        this.numberSetting.setVisible(visible);
        this.functionSetting.setVisible(visible);
        this.midiChannelSetting.setVisible(visible);
        this.knobModeSetting.setVisible(visible);
        this.sendValueSetting.setVisible(visible);
    }

    public FlexiCommand getCommand() {
        return this.command;
    }

    public int getMidiChannel() {
        return this.midiChannel;
    }

    public int getType() {
        return this.type;
    }

    public int getNumber() {
        return this.number;
    }

    public int getKnobMode() {
        return this.knobMode;
    }

    public void addTypeValueObserver(IValueObserver<String> observer) {
        this.typeSetting.addValueObserver(observer);
    }

    public boolean isSendValue() {
        return this.sendValue;
    }

    public void set(int type, int number, int midiChannel) {
        this.typeSetting.set(OPTIONS_TYPE[type]);
        this.numberSetting.set(OPTIONS_NUMBER[number]);
        this.midiChannelSetting.set(OPTIONS_MIDI_CHANNEL[midiChannel]);
    }

    public void setType(String value) {
        this.typeSetting.set(OPTIONS_TYPE[Integer.parseInt(value)]);
    }

    public void setNumber(String value) {
        this.numberSetting.set(OPTIONS_NUMBER[Integer.parseInt(value)]);
    }

    public void setMidiChannel(String value) {
        this.midiChannelSetting.set(OPTIONS_MIDI_CHANNEL[Integer.parseInt(value)]);
    }

    public void setKnobMode(String value) {
        this.knobModeSetting.set(OPTIONS_KNOBMODE[Integer.parseInt(value)]);
    }

    public void setCommand(String value) {
        this.functionSetting.set(value);
    }

    public void setSendValue(String value) {
        this.sendValueSetting.set(AbstractConfiguration.ON_OFF_OPTIONS[Boolean.parseBoolean(value) ? 1 : 0]);
    }

    static {
        int i;
        OPTIONS_KNOBMODE = new String[]{"Absolute", "Relative (1-64 increments, 127-65 decrements)", "Relative (65-127 increments, 63-0 decrements)", "Relative (1-63 increments, 65-127 decrements)"};
        OPTIONS_TYPE = new String[]{"CC", "Note", "Program Change"};
        TYPE_CC = 0;
        TYPE_NOTE = 1;
        TYPE_PROGRAM_CHANGE = 2;
        OPTIONS_NUMBER = new String[128];
        OPTIONS_MIDI_CHANNEL = new String[16];
        for (i = 0; i < OPTIONS_NUMBER.length; ++i) {
            CommandSlot.OPTIONS_NUMBER[i] = Integer.toString(i);
        }
        for (i = 0; i < OPTIONS_MIDI_CHANNEL.length; ++i) {
            CommandSlot.OPTIONS_MIDI_CHANNEL[i] = Integer.toString(i + 1);
        }
        NAMES = FlexiCommand.getNames();
    }
}

