/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.beatstep.view;

import de.mossgrabers.controller.beatstep.BeatstepConfiguration;
import de.mossgrabers.controller.beatstep.controller.BeatstepControlSurface;
import de.mossgrabers.controller.beatstep.view.BeatstepView;
import de.mossgrabers.controller.beatstep.view.TrackEditing;
import de.mossgrabers.framework.controller.grid.PadGrid;
import de.mossgrabers.framework.daw.IChannelBank;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.ITrackBank;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.view.AbstractView;

public class TrackView
extends AbstractView<BeatstepControlSurface, BeatstepConfiguration>
implements BeatstepView {
    private TrackEditing extensions;

    public TrackView(BeatstepControlSurface surface, IModel model) {
        super("Track", surface, model);
        this.extensions = new TrackEditing(surface, model);
    }

    @Override
    public void onKnob(int index, int value) {
        if (index < 12) {
            this.extensions.onTrackKnob(index, value);
            return;
        }
        IChannelBank tb = this.model.getCurrentTrackBank();
        ITrack selectedTrack = tb.getSelectedTrack();
        if (selectedTrack == null) {
            return;
        }
        switch (index) {
            case 12: 
            case 13: {
                if (!(tb instanceof ITrackBank)) break;
                selectedTrack.getSend(index - 8).changeValue(value);
                break;
            }
            case 14: {
                break;
            }
            case 15: {
                this.model.getTransport().changeCrossfade(value);
            }
        }
    }

    @Override
    public void onGridNote(int note, int velocity) {
        if (velocity == 0) {
            return;
        }
        IChannelBank tb = this.model.getCurrentTrackBank();
        switch (note - 36) {
            case 0: {
                ITrack selectedTrack = tb.getSelectedTrack();
                if (selectedTrack == null) break;
                selectedTrack.toggleIsActivated();
                break;
            }
            case 1: {
                int index;
                ITrack sel = tb.getSelectedTrack();
                int n = index = sel == null ? 0 : sel.getIndex() - 1;
                if (index == -1 || ((BeatstepControlSurface)this.surface).isShiftPressed()) {
                    if (!tb.canScrollTracksUp()) {
                        return;
                    }
                    tb.scrollTracksPageUp();
                    int newSel = index == -1 || sel == null ? 7 : sel.getIndex();
                    ((BeatstepControlSurface)this.surface).scheduleTask(() -> this.selectTrack(newSel), 75L);
                    return;
                }
                this.selectTrack(index);
                break;
            }
            case 2: {
                int index;
                ITrack sel = tb.getSelectedTrack();
                int n = index = sel == null ? 0 : sel.getIndex() + 1;
                if (index == 8 || ((BeatstepControlSurface)this.surface).isShiftPressed()) {
                    if (!tb.canScrollTracksDown()) {
                        return;
                    }
                    tb.scrollTracksPageDown();
                    int newSel = index == 8 || sel == null ? 0 : sel.getIndex();
                    ((BeatstepControlSurface)this.surface).scheduleTask(() -> this.selectTrack(newSel), 75L);
                    return;
                }
                this.selectTrack(index);
                break;
            }
            case 3: {
                if (!(tb instanceof ITrackBank)) break;
                ((ITrackBank)tb).selectChildren();
                break;
            }
            case 4: {
                if (!(tb instanceof ITrackBank)) break;
                ((ITrackBank)tb).selectParent();
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                this.scrollTracksLeft();
                break;
            }
            case 7: {
                this.scrollTracksRight();
                break;
            }
            default: {
                int track = note - 36 - 8;
                this.selectTrack(track);
            }
        }
    }

    @Override
    public void drawGrid() {
        IChannelBank tb = this.model.getCurrentTrackBank();
        PadGrid padGrid = ((BeatstepControlSurface)this.surface).getPadGrid();
        for (int i = 0; i < 8; ++i) {
            padGrid.light(44 + i, tb.getTrack(i).isSelected() ? 16 : 0);
        }
        ITrack sel = tb.getSelectedTrack();
        padGrid.light(36, sel != null && sel.isActivated() ? 1 : 0);
        padGrid.light(37, 16);
        padGrid.light(38, 16);
        padGrid.light(39, 1);
        padGrid.light(40, 1);
        padGrid.light(41, 0);
        padGrid.light(42, 16);
        padGrid.light(43, 16);
    }

    private void scrollTracksLeft() {
        IChannelBank tb = this.model.getCurrentTrackBank();
        if (!tb.canScrollTracksUp()) {
            return;
        }
        ITrack sel = tb.getSelectedTrack();
        int index = sel == null ? 0 : sel.getIndex() - 1;
        tb.scrollTracksPageUp();
        int newSel = index == -1 || sel == null ? 7 : sel.getIndex();
        ((BeatstepControlSurface)this.surface).scheduleTask(() -> this.selectTrack(newSel), 100L);
    }

    private void scrollTracksRight() {
        IChannelBank tb = this.model.getCurrentTrackBank();
        if (!tb.canScrollTracksDown()) {
            return;
        }
        ITrack sel = tb.getSelectedTrack();
        int index = sel == null ? 0 : sel.getIndex() + 1;
        tb.scrollTracksPageDown();
        int newSel = index == 8 || sel == null ? 0 : sel.getIndex();
        ((BeatstepControlSurface)this.surface).scheduleTask(() -> this.selectTrack(newSel), 100L);
    }
}

