/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.beatstep.view;

import de.mossgrabers.controller.beatstep.controller.BeatstepControlSurface;
import de.mossgrabers.framework.daw.IChannelBank;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.ITrackBank;
import de.mossgrabers.framework.daw.data.ITrack;

public class TrackEditing {
    private BeatstepControlSurface surface;
    private IModel model;

    public TrackEditing(BeatstepControlSurface surface, IModel model) {
        this.surface = surface;
        this.model = model;
    }

    public void onTrackKnob(int index, int value) {
        if (value == 64) {
            return;
        }
        IChannelBank tb = this.model.getCurrentTrackBank();
        ITrack selectedTrack = tb.getSelectedTrack();
        if (selectedTrack == null) {
            return;
        }
        switch (index) {
            case 0: {
                selectedTrack.changeVolume(value);
                break;
            }
            case 1: {
                selectedTrack.changePan(value);
                break;
            }
            case 2: {
                selectedTrack.setMute(value > 64);
                break;
            }
            case 3: {
                selectedTrack.setSolo(value > 64);
                break;
            }
            case 4: {
                selectedTrack.changeCrossfadeModeAsNumber(value);
                break;
            }
            case 5: {
                this.model.getTransport().changeTempo(value >= 65);
                break;
            }
            case 6: {
                this.model.getTransport().changePosition(value >= 65, this.surface.isShiftPressed());
                break;
            }
            case 7: {
                this.model.getMasterTrack().changeVolume(value);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                if (!(tb instanceof ITrackBank)) break;
                selectedTrack.getSend(index - 8).changeValue(value);
            }
        }
    }
}

