/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.beatstep.view;

import de.mossgrabers.controller.beatstep.BeatstepConfiguration;
import de.mossgrabers.controller.beatstep.controller.BeatstepControlSurface;
import de.mossgrabers.controller.beatstep.view.BeatstepView;
import de.mossgrabers.controller.beatstep.view.Views;
import de.mossgrabers.framework.command.trigger.transport.PlayCommand;
import de.mossgrabers.framework.controller.grid.PadGrid;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.ITransport;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.AbstractView;
import de.mossgrabers.framework.view.View;
import de.mossgrabers.framework.view.ViewManager;

public class ShiftView
extends AbstractView<BeatstepControlSurface, BeatstepConfiguration>
implements BeatstepView {
    private PlayCommand<BeatstepControlSurface, BeatstepConfiguration> playCommand;

    public ShiftView(BeatstepControlSurface surface, IModel model) {
        super("Shift", surface, model);
        this.playCommand = new PlayCommand(model, surface);
    }

    @Override
    public void drawGrid() {
        boolean hasClips = this.model.getHost().hasClips();
        ITransport t = this.model.getTransport();
        PadGrid padGrid = ((BeatstepControlSurface)this.surface).getPadGrid();
        padGrid.light(36, t.isPlaying() ? 17 : 16);
        padGrid.light(37, t.isRecording() ? 17 : 1);
        padGrid.light(38, t.isLoop() ? 17 : 0);
        padGrid.light(39, t.isMetronomeOn() ? 17 : 0);
        padGrid.light(40, 0);
        padGrid.light(41, 1);
        padGrid.light(42, 1);
        padGrid.light(43, 1);
        padGrid.light(44, 1);
        padGrid.light(45, 1);
        padGrid.light(46, 17);
        padGrid.light(47, hasClips ? 17 : 0);
        padGrid.light(48, hasClips ? 17 : 0);
        padGrid.light(49, hasClips ? 16 : 0);
        padGrid.light(50, 0);
        padGrid.light(51, 17);
    }

    @Override
    public void onGridNote(int note, int velocity) {
        if (velocity == 0) {
            return;
        }
        switch (note - 36) {
            case 0: {
                this.playCommand.executeNormal(ButtonEvent.DOWN);
                break;
            }
            case 1: {
                this.model.getTransport().record();
                break;
            }
            case 2: {
                this.model.getTransport().toggleLoop();
                break;
            }
            case 3: {
                this.model.getTransport().toggleMetronome();
                break;
            }
            case 4: {
                this.model.getTransport().tapTempo();
                break;
            }
            case 5: {
                this.model.getBrowser().browseToInsertBeforeDevice();
                this.activateBrowserView();
                break;
            }
            case 6: {
                this.model.getBrowser().browseToInsertAfterDevice();
                this.activateBrowserView();
                break;
            }
            case 7: {
                this.model.getBrowser().browseForPresets();
                this.activateBrowserView();
                break;
            }
            case 15: {
                this.model.getCursorDevice().toggleWindowOpen();
                break;
            }
            default: {
                int viewIndex = note - 44;
                if (viewIndex < 0 || viewIndex >= (this.model.getHost().hasClips() ? 6 : 3)) {
                    return;
                }
                ViewManager viewManager = ((BeatstepControlSurface)this.surface).getViewManager();
                Integer viewId = viewIndex;
                viewManager.setPreviousView(viewId);
                View view = viewManager.getView(viewId);
                ((BeatstepControlSurface)this.surface).getDisplay().notify(view.getName());
            }
        }
    }

    @Override
    public void onKnob(int index, int value) {
    }

    private void activateBrowserView() {
        ViewManager viewManager = ((BeatstepControlSurface)this.surface).getViewManager();
        Integer previousViewId = viewManager.getPreviousViewId();
        viewManager.setActiveView(Views.VIEW_BROWSER);
        viewManager.setPreviousView(previousViewId);
    }
}

