/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.beatstep.view;

import de.mossgrabers.controller.beatstep.BeatstepConfiguration;
import de.mossgrabers.controller.beatstep.controller.BeatstepControlSurface;
import de.mossgrabers.controller.beatstep.view.BeatstepView;
import de.mossgrabers.controller.beatstep.view.TrackEditing;
import de.mossgrabers.framework.controller.grid.PadGrid;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.view.AbstractView;

public class SessionView
extends AbstractView<BeatstepControlSurface, BeatstepConfiguration>
implements BeatstepView {
    private TrackEditing extensions;

    public SessionView(BeatstepControlSurface surface, IModel model) {
        super("Session", surface, model);
        this.extensions = new TrackEditing(surface, model);
    }

    @Override
    public void onKnob(int index, int value) {
        if (index < 12) {
            this.extensions.onTrackKnob(index, value);
            return;
        }
    }

    @Override
    public void onGridNote(int note, int velocity) {
        if (velocity == 0) {
            return;
        }
        int index = note - 36;
        switch (index) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                this.model.getCurrentTrackBank().scrollScenesPageUp();
                break;
            }
            case 7: {
                this.model.getCurrentTrackBank().scrollScenesPageDown();
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                this.model.getCurrentTrackBank().launchScene(index - 8);
            }
        }
    }

    @Override
    public void drawGrid() {
        int i;
        PadGrid padGrid = ((BeatstepControlSurface)this.surface).getPadGrid();
        for (i = 0; i < 6; ++i) {
            padGrid.light(36 + i, 0);
        }
        for (i = 6; i < 8; ++i) {
            padGrid.light(36 + i, 16);
        }
        for (i = 8; i < 16; ++i) {
            padGrid.light(36 + i, 16);
        }
    }
}

