/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.beatstep.view;

import de.mossgrabers.controller.beatstep.controller.BeatstepControlSurface;
import de.mossgrabers.controller.beatstep.view.BaseSequencerView;
import de.mossgrabers.framework.controller.grid.PadGrid;
import de.mossgrabers.framework.daw.ICursorClip;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.ITrackBank;
import de.mossgrabers.framework.scale.Scales;

public class SequencerView
extends BaseSequencerView {
    private static final int NUM_DISPLAY_COLS = 16;
    private static final int START_KEY = 36;

    public SequencerView(BeatstepControlSurface surface, IModel model) {
        super("Sequencer", surface, model, 128, 16);
        this.offsetY = 36;
        ITrackBank tb = model.getTrackBank();
        tb.addNoteObserver((note, velocity) -> {
            for (int i = 0; i < 128; ++i) {
                if (this.noteMap[i] != note) continue;
                this.pressedKeys[i] = velocity;
            }
        });
        tb.addTrackSelectionObserver((index, isSelected) -> this.clearPressedKeys());
    }

    @Override
    public void onKnob(int index, int value) {
        if (index < 12) {
            this.extensions.onTrackKnob(index, value);
            return;
        }
        boolean isInc = value >= 65;
        switch (index) {
            case 12: {
                this.changeScrollPosition(value);
                break;
            }
            case 13: {
                this.changeResolution(value);
                ((BeatstepControlSurface)this.surface).getDisplay().notify(RESOLUTION_TEXTS[this.selectedIndex]);
                break;
            }
            case 14: {
                this.clearPressedKeys();
                if (isInc) {
                    this.scales.incDrumOctave();
                    this.model.getPrimaryDevice().scrollDrumPadsPageDown();
                } else {
                    this.scales.decDrumOctave();
                    this.model.getPrimaryDevice().scrollDrumPadsPageUp();
                }
                this.offsetY = 36 + this.scales.getDrumOctave() * 16;
                this.updateNoteMapping();
                ((BeatstepControlSurface)this.surface).getDisplay().notify(this.scales.getDrumRangeText());
                break;
            }
            case 15: {
                this.isPlayMode = !this.isPlayMode;
                ((BeatstepControlSurface)this.surface).getDisplay().notify(this.isPlayMode ? "Play/Select" : "Sequence");
                this.updateNoteMapping();
            }
        }
    }

    @Override
    public void onGridNote(int note, int velocity) {
        if (!this.model.canSelectedTrackHoldNotes()) {
            return;
        }
        int index = note - 36;
        if (this.isPlayMode) {
            this.selectedPad = index;
            for (int i = 0; i < 128; ++i) {
                if (this.noteMap[note] != this.noteMap[i]) continue;
                this.pressedKeys[i] = velocity;
            }
        } else if (velocity != 0) {
            this.getClip().toggleStep(index < 8 ? index + 8 : index - 8, this.offsetY + this.selectedPad, this.configuration.isAccentActive() ? this.configuration.getFixedAccentValue() : velocity);
        }
    }

    @Override
    public void updateNoteMapping() {
        this.noteMap = this.model.canSelectedTrackHoldNotes() && this.isPlayMode ? this.scales.getNoteMatrix() : Scales.getEmptyMatrix();
        ((BeatstepControlSurface)this.surface).setKeyTranslationTable(this.noteMap);
    }

    @Override
    public void drawGrid() {
        PadGrid padGrid = ((BeatstepControlSurface)this.surface).getPadGrid();
        if (!this.model.canSelectedTrackHoldNotes()) {
            padGrid.turnOff();
            return;
        }
        if (this.isPlayMode) {
            for (int i = 36; i < 52; ++i) {
                padGrid.light(i, this.pressedKeys[i] > 0 || this.selectedPad == i - 36 ? 17 : this.model.getColorManager().getColor(this.scales.getColor(this.noteMap, i)));
            }
        } else {
            ICursorClip clip = this.getClip();
            int step = clip.getCurrentStep();
            int hiStep = this.isInXRange(step) ? step % 16 : -1;
            for (int col = 0; col < 16; ++col) {
                int isSet = clip.getStep(col, this.offsetY + this.selectedPad);
                boolean hilite = col == hiStep;
                int x = col % 8;
                int y = col / 8;
                padGrid.lightEx(x, 1 - y, isSet > 0 ? (hilite ? 17 : 16) : (hilite ? 17 : 0));
            }
        }
    }
}

