/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.beatstep.view;

import de.mossgrabers.controller.beatstep.BeatstepConfiguration;
import de.mossgrabers.controller.beatstep.controller.BeatstepControlSurface;
import de.mossgrabers.controller.beatstep.view.BeatstepView;
import de.mossgrabers.controller.beatstep.view.TrackEditing;
import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.controller.grid.PadGrid;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.scale.Scales;
import de.mossgrabers.framework.view.AbstractPlayView;

public class PlayView
extends AbstractPlayView<BeatstepControlSurface, BeatstepConfiguration>
implements BeatstepView {
    private TrackEditing extensions;

    public PlayView(BeatstepControlSurface surface, IModel model) {
        super("Play", surface, model, false);
        this.extensions = new TrackEditing(surface, model);
    }

    @Override
    public void onKnob(int index, int value) {
        if (index < 12) {
            this.extensions.onTrackKnob(index, value);
            return;
        }
        boolean isInc = value >= 65;
        switch (index) {
            case 12: {
                this.scales.setChromatic(!isInc);
                ((BeatstepConfiguration)((BeatstepControlSurface)this.surface).getConfiguration()).setScaleInKey(isInc);
                ((BeatstepControlSurface)this.surface).getDisplay().notify(isInc ? "In Key" : "Chromatic");
                break;
            }
            case 13: {
                this.scales.changeScaleOffset(value);
                String scaleBase = Scales.BASES[this.scales.getScaleOffset()];
                ((BeatstepControlSurface)this.surface).getDisplay().notify(scaleBase);
                ((BeatstepConfiguration)((BeatstepControlSurface)this.surface).getConfiguration()).setScaleBase(scaleBase);
                break;
            }
            case 14: {
                if (isInc) {
                    this.scales.nextScale();
                } else {
                    this.scales.prevScale();
                }
                String scale = this.scales.getScale().getName();
                ((BeatstepConfiguration)((BeatstepControlSurface)this.surface).getConfiguration()).setScale(scale);
                ((BeatstepControlSurface)this.surface).getDisplay().notify(scale);
                break;
            }
            case 15: {
                this.clearPressedKeys();
                if (isInc) {
                    this.scales.incOctave();
                } else {
                    this.scales.decOctave();
                }
                ((BeatstepControlSurface)this.surface).getDisplay().notify("Octave " + (this.scales.getOctave() > 0 ? "+" : "") + this.scales.getOctave() + " (" + this.scales.getRangeText() + ")");
            }
        }
        this.updateNoteMapping();
    }

    @Override
    public void onGridNote(int note, int velocity) {
        if (!this.model.canSelectedTrackHoldNotes()) {
            return;
        }
        for (int i = 0; i < 128; ++i) {
            if (this.noteMap[note] != this.noteMap[i]) continue;
            this.pressedKeys[i] = velocity;
        }
    }

    @Override
    public void updateNoteMapping() {
        this.noteMap = this.model.canSelectedTrackHoldNotes() ? this.scales.getNoteMatrix() : Scales.getEmptyMatrix();
        ((BeatstepControlSurface)this.surface).scheduleTask(() -> ((BeatstepControlSurface)this.surface).setKeyTranslationTable(this.noteMap), 100L);
    }

    @Override
    public void drawGrid() {
        boolean isKeyboardEnabled = this.model.canSelectedTrackHoldNotes();
        PadGrid padGrid = ((BeatstepControlSurface)this.surface).getPadGrid();
        ColorManager colorManager = this.model.getColorManager();
        for (int i = 36; i < 52; ++i) {
            padGrid.light(i, isKeyboardEnabled ? (this.pressedKeys[i] > 0 ? 17 : colorManager.getColor(this.scales.getColor(this.noteMap, i))) : 0);
        }
    }
}

