/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.beatstep.view;

import de.mossgrabers.controller.beatstep.controller.BeatstepControlSurface;
import de.mossgrabers.controller.beatstep.view.BaseSequencerView;
import de.mossgrabers.framework.controller.grid.PadGrid;
import de.mossgrabers.framework.daw.ICursorClip;
import de.mossgrabers.framework.daw.ICursorDevice;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.ITrackBank;
import de.mossgrabers.framework.daw.data.IDrumPad;
import de.mossgrabers.framework.scale.Scales;

public class DrumView
extends BaseSequencerView {
    private static final int NUM_DISPLAY_COLS = 16;

    public DrumView(BeatstepControlSurface surface, IModel model) {
        super("Drum", surface, model, 128, 16);
        this.offsetY = 36;
        ITrackBank tb = model.getTrackBank();
        tb.addNoteObserver((note, velocity) -> {
            this.pressedKeys[note] = velocity;
        });
        tb.addTrackSelectionObserver((index, isSelected) -> this.clearPressedKeys());
    }

    @Override
    public void onKnob(int index, int value) {
        if (index < 12) {
            this.extensions.onTrackKnob(index, value);
            return;
        }
        boolean isInc = value >= 65;
        switch (index) {
            case 12: {
                this.changeScrollPosition(value);
                break;
            }
            case 13: {
                this.changeResolution(value);
                ((BeatstepControlSurface)this.surface).getDisplay().notify(RESOLUTION_TEXTS[this.selectedIndex]);
                break;
            }
            case 14: {
                this.clearPressedKeys();
                if (isInc) {
                    this.scales.incDrumOctave();
                    this.model.getPrimaryDevice().scrollDrumPadsPageDown();
                } else {
                    this.scales.decDrumOctave();
                    this.model.getPrimaryDevice().scrollDrumPadsPageUp();
                }
                this.offsetY = 36 + this.scales.getDrumOctave() * 16;
                this.updateNoteMapping();
                ((BeatstepControlSurface)this.surface).getDisplay().notify(this.scales.getDrumRangeText());
                break;
            }
            case 15: {
                this.isPlayMode = !this.isPlayMode;
                ((BeatstepControlSurface)this.surface).getDisplay().notify(this.isPlayMode ? "Play/Select" : "Sequence");
                this.updateNoteMapping();
            }
        }
    }

    @Override
    public void onGridNote(int note, int velocity) {
        if (!this.model.canSelectedTrackHoldNotes()) {
            return;
        }
        int index = note - 36;
        if (this.isPlayMode) {
            this.selectedPad = index;
            this.pressedKeys[this.offsetY + this.selectedPad] = velocity;
        } else if (velocity != 0) {
            this.getClip().toggleStep(index < 8 ? index + 8 : index - 8, this.offsetY + this.selectedPad, this.configuration.isAccentActive() ? this.configuration.getFixedAccentValue() : velocity);
        }
    }

    @Override
    public void updateNoteMapping() {
        this.noteMap = this.model.canSelectedTrackHoldNotes() && this.isPlayMode ? this.scales.getDrumMatrix() : Scales.getEmptyMatrix();
        ((BeatstepControlSurface)this.surface).setKeyTranslationTable(this.noteMap);
    }

    @Override
    public void drawGrid() {
        PadGrid padGrid = ((BeatstepControlSurface)this.surface).getPadGrid();
        if (!this.model.canSelectedTrackHoldNotes()) {
            padGrid.turnOff();
            return;
        }
        if (this.isPlayMode) {
            ICursorDevice primary = this.model.getPrimaryDevice();
            boolean hasDrumPads = primary.hasDrumPads();
            boolean isSoloed = false;
            if (hasDrumPads) {
                for (int i = 0; i < 16; ++i) {
                    if (!primary.getDrumPad(i).isSolo()) continue;
                    isSoloed = true;
                    break;
                }
            }
            for (int y = 0; y < 2; ++y) {
                for (int x = 0; x < 8; ++x) {
                    int index = 8 * y + x;
                    padGrid.lightEx(x, y, this.getPadColor(index, primary, isSoloed));
                }
            }
        } else {
            ICursorClip clip = this.getClip();
            int step = clip.getCurrentStep();
            int hiStep = this.isInXRange(step) ? step % 16 : -1;
            for (int col = 0; col < 16; ++col) {
                int isSet = clip.getStep(col, this.offsetY + this.selectedPad);
                boolean hilite = col == hiStep;
                int x = col % 8;
                int y = col / 8;
                padGrid.lightEx(x, 1 - y, isSet > 0 ? (hilite ? 17 : 16) : (hilite ? 17 : 0));
            }
        }
    }

    private int getPadColor(int index, ICursorDevice primary, boolean isSoloed) {
        if (this.pressedKeys[this.offsetY + index] > 0) {
            return 17;
        }
        if (this.selectedPad == index) {
            return 1;
        }
        IDrumPad drumPad = primary.getDrumPad(index);
        if (!drumPad.doesExist() || !drumPad.isActivated()) {
            return 0;
        }
        if (drumPad.isMute() || isSoloed && !drumPad.isSolo()) {
            return 0;
        }
        return 16;
    }
}

