/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.beatstep.view;

import de.mossgrabers.controller.beatstep.BeatstepConfiguration;
import de.mossgrabers.controller.beatstep.controller.BeatstepControlSurface;
import de.mossgrabers.controller.beatstep.view.BeatstepView;
import de.mossgrabers.controller.beatstep.view.TrackEditing;
import de.mossgrabers.framework.controller.grid.PadGrid;
import de.mossgrabers.framework.daw.ICursorDevice;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IChannel;
import de.mossgrabers.framework.view.AbstractView;

public class DeviceView
extends AbstractView<BeatstepControlSurface, BeatstepConfiguration>
implements BeatstepView {
    private TrackEditing extensions;
    private boolean isLayer;

    public DeviceView(BeatstepControlSurface surface, IModel model) {
        super("Device", surface, model);
        this.extensions = new TrackEditing(surface, model);
        this.isLayer = false;
    }

    @Override
    public void onKnob(int index, int value) {
        ICursorDevice cd = this.model.getCursorDevice();
        if (index < 8) {
            this.extensions.onTrackKnob(index, value);
            return;
        }
        cd.changeParameter(index - 8, value);
    }

    @Override
    public void onGridNote(int note, int velocity) {
        if (velocity == 0) {
            return;
        }
        if (!this.model.hasSelectedDevice()) {
            return;
        }
        ICursorDevice cd = this.model.getCursorDevice();
        switch (note - 36) {
            case 0: {
                cd.toggleEnabledState();
                break;
            }
            case 1: {
                if (this.isLayer) {
                    IChannel sel = cd.getSelectedLayer();
                    int index = sel == null || sel.getIndex() == 0 ? 0 : sel.getIndex() - 1;
                    cd.selectLayer(index);
                    break;
                }
                cd.selectPrevious();
                break;
            }
            case 2: {
                if (this.isLayer) {
                    IChannel sel = cd.getSelectedLayer();
                    int index = sel == null ? 0 : sel.getIndex() + 1;
                    cd.selectLayer(index > 7 ? 7 : index);
                    break;
                }
                cd.selectNext();
                break;
            }
            case 3: {
                if (!cd.hasLayers()) {
                    return;
                }
                IChannel dl = cd.getSelectedLayerOrDrumPad();
                if (this.isLayer) {
                    if (dl != null) {
                        cd.enterLayerOrDrumPad(dl.getIndex());
                        cd.selectFirstDeviceInLayerOrDrumPad(dl.getIndex());
                    }
                } else if (dl == null) {
                    cd.selectLayerOrDrumPad(0);
                }
                this.isLayer = !this.isLayer;
                break;
            }
            case 4: {
                if (this.isLayer) {
                    this.isLayer = false;
                    break;
                }
                if (!cd.isNested()) break;
                cd.selectParent();
                cd.selectChannel();
                this.isLayer = true;
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                cd.setSelectedParameterPage(Math.max(cd.getSelectedParameterPage() - 8, 0));
                break;
            }
            case 7: {
                cd.setSelectedParameterPage(Math.min(cd.getSelectedParameterPage() + 8, cd.getParameterPageNames().length - 1));
                break;
            }
            default: {
                int bank = note - 36 - 8;
                int offset = cd.getSelectedParameterPage() / 8 * 8;
                cd.setSelectedParameterPage(offset + bank);
            }
        }
    }

    @Override
    public void drawGrid() {
        ICursorDevice cd = this.model.getCursorDevice();
        int offset = cd.getSelectedParameterPage() / 8 * 8;
        PadGrid padGrid = ((BeatstepControlSurface)this.surface).getPadGrid();
        for (int i = 0; i < 8; ++i) {
            padGrid.light(44 + i, offset + i == cd.getSelectedParameterPage() ? 16 : 0);
        }
        padGrid.light(36, cd.isEnabled() ? 1 : 0);
        padGrid.light(37, 16);
        padGrid.light(38, 16);
        padGrid.light(39, 1);
        padGrid.light(40, 1);
        padGrid.light(41, 0);
        padGrid.light(42, 16);
        padGrid.light(43, 16);
    }
}

