/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.beatstep.view;

import de.mossgrabers.controller.beatstep.BeatstepConfiguration;
import de.mossgrabers.controller.beatstep.controller.BeatstepControlSurface;
import de.mossgrabers.controller.beatstep.view.BeatstepView;
import de.mossgrabers.controller.beatstep.view.TrackEditing;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.scale.Scales;
import de.mossgrabers.framework.view.AbstractSequencerView;
import java.util.Arrays;

public abstract class BaseSequencerView
extends AbstractSequencerView<BeatstepControlSurface, BeatstepConfiguration>
implements BeatstepView {
    protected TrackEditing extensions;
    protected int[] pressedKeys;
    protected int selectedPad;
    protected boolean isPlayMode = true;

    public BaseSequencerView(String name, BeatstepControlSurface surface, IModel model, int rows, int cols) {
        super(name, surface, model, rows, cols);
        this.extensions = new TrackEditing(surface, model);
        this.noteMap = Scales.getEmptyMatrix();
        this.pressedKeys = new int[128];
        Arrays.fill(this.pressedKeys, 0);
    }

    protected void changeScrollPosition(int value) {
        boolean isInc;
        boolean bl = isInc = value >= 65;
        if (isInc) {
            this.getClip().scrollStepsPageForward();
        } else {
            this.getClip().scrollStepsPageBackwards();
        }
    }

    protected void changeResolution(int value) {
        boolean isInc = value >= 65;
        this.selectedIndex = Math.max(0, Math.min(RESOLUTIONS.length - 1, isInc ? this.selectedIndex + 1 : this.selectedIndex - 1));
        this.getClip().setStepLength(RESOLUTIONS[this.selectedIndex]);
    }

    protected void clearPressedKeys() {
        for (int i = 0; i < 128; ++i) {
            this.pressedKeys[i] = 0;
        }
    }

    @Override
    public void updateSceneButtons() {
    }
}

