/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.beatstep.controller;

import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.controller.grid.PadGridImpl;
import de.mossgrabers.framework.daw.midi.IMidiOutput;
import de.mossgrabers.framework.utils.StringUtils;

public class BeatstepPadGrid
extends PadGridImpl {
    private int columns = 8;

    public BeatstepPadGrid(ColorManager colorManager, IMidiOutput output) {
        super(colorManager, output);
    }

    @Override
    public void lightEx(int x, int y, int color, int blinkColor, boolean fast) {
        this.setLight(36 + x + 8 * y, color, blinkColor, fast);
    }

    @Override
    protected void sendNoteState(int note, int color) {
        int n = note - 36;
        int pad = n < this.columns ? 120 + n : 112 + n - this.columns;
        String data = "F0 00 20 6B 7F 42 02 00 10 " + StringUtils.toHexStr(new int[]{pad, color}) + "F7";
        this.output.sendSysex(data);
    }

    @Override
    public void flush() {
        for (int i = 36; i < 52; ++i) {
            int note = this.translateToController(i);
            if (this.currentButtonColors[i] == this.buttonColors[i]) continue;
            this.currentButtonColors[i] = this.buttonColors[i];
            this.sendNoteState(note, this.buttonColors[i]);
        }
    }
}

