/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.beatstep.controller;

import de.mossgrabers.controller.beatstep.BeatstepConfiguration;
import de.mossgrabers.controller.beatstep.controller.BeatstepPadGrid;
import de.mossgrabers.controller.beatstep.view.Views;
import de.mossgrabers.framework.controller.AbstractControlSurface;
import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.midi.IMidiInput;
import de.mossgrabers.framework.daw.midi.IMidiOutput;

public class BeatstepControlSurface
extends AbstractControlSurface<BeatstepConfiguration> {
    public static final int BEATSTEP_KNOB_1 = 20;
    public static final int BEATSTEP_KNOB_2 = 21;
    public static final int BEATSTEP_KNOB_3 = 22;
    public static final int BEATSTEP_KNOB_4 = 23;
    public static final int BEATSTEP_KNOB_5 = 24;
    public static final int BEATSTEP_KNOB_6 = 25;
    public static final int BEATSTEP_KNOB_7 = 26;
    public static final int BEATSTEP_KNOB_8 = 27;
    public static final int BEATSTEP_KNOB_9 = 30;
    public static final int BEATSTEP_KNOB_10 = 31;
    public static final int BEATSTEP_KNOB_11 = 32;
    public static final int BEATSTEP_KNOB_12 = 33;
    public static final int BEATSTEP_KNOB_13 = 34;
    public static final int BEATSTEP_KNOB_14 = 35;
    public static final int BEATSTEP_KNOB_15 = 36;
    public static final int BEATSTEP_KNOB_16 = 37;
    public static final int BEATSTEP_KNOB_MAIN = 40;
    public static final int BEATSTEP_PRO_STEP1 = 50;
    public static final int BEATSTEP_PRO_STEP2 = 51;
    public static final int BEATSTEP_PRO_STEP3 = 52;
    public static final int BEATSTEP_PRO_STEP4 = 53;
    public static final int BEATSTEP_PRO_STEP5 = 54;
    public static final int BEATSTEP_PRO_STEP6 = 55;
    public static final int BEATSTEP_PRO_STEP7 = 56;
    public static final int BEATSTEP_PRO_STEP8 = 57;
    public static final int BEATSTEP_PRO_STEP9 = 58;
    public static final int BEATSTEP_PRO_STEP10 = 59;
    public static final int BEATSTEP_PRO_STEP11 = 60;
    public static final int BEATSTEP_PRO_STEP12 = 61;
    public static final int BEATSTEP_PRO_STEP13 = 62;
    public static final int BEATSTEP_PRO_STEP14 = 63;
    public static final int BEATSTEP_PRO_STEP15 = 64;
    public static final int BEATSTEP_PRO_STEP16 = 65;
    public static final int BEATSTEP_PAD_1 = 112;
    public static final int BEATSTEP_PAD_2 = 113;
    public static final int BEATSTEP_PAD_3 = 114;
    public static final int BEATSTEP_PAD_4 = 115;
    public static final int BEATSTEP_PAD_5 = 116;
    public static final int BEATSTEP_PAD_6 = 117;
    public static final int BEATSTEP_PAD_7 = 118;
    public static final int BEATSTEP_PAD_8 = 119;
    public static final int BEATSTEP_PAD_9 = 120;
    public static final int BEATSTEP_PAD_10 = 121;
    public static final int BEATSTEP_PAD_11 = 122;
    public static final int BEATSTEP_PAD_12 = 123;
    public static final int BEATSTEP_PAD_13 = 124;
    public static final int BEATSTEP_PAD_14 = 125;
    public static final int BEATSTEP_PAD_15 = 126;
    public static final int BEATSTEP_PAD_16 = 127;
    private static final int[] BEATSTEP_BUTTONS_ALL = new int[]{50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65};
    static final String SYSEX_HEADER = "F0 00 20 6B 7F 42 02 00 10 ";
    static final String SYSEX_END = "F7";
    private boolean isPro;
    private boolean isShift;

    public BeatstepControlSurface(IHost host, ColorManager colorManager, BeatstepConfiguration configuration, IMidiOutput output, IMidiInput input, boolean isPro) {
        super(host, configuration, colorManager, output, input, BEATSTEP_BUTTONS_ALL);
        this.isPro = isPro;
        this.pads = new BeatstepPadGrid(colorManager, output);
        this.output.sendIdentityRequest();
    }

    @Override
    public void shutdown() {
        this.pads.turnOff();
    }

    @Override
    public boolean isShiftPressed() {
        return this.isShift;
    }

    public boolean isPro() {
        return this.isPro;
    }

    @Override
    protected void handleMidi(int status, int data1, int data2) {
        int code = status & 0xF0;
        int channel = status & 0xF;
        if (this.isPro && channel != 2) {
            return;
        }
        super.handleMidi(code, data1, data2);
    }

    @Override
    protected void handleGridNote(int note, int velocity) {
        super.handleGridNote(note, velocity);
        if (note < 36 || note > 51) {
            return;
        }
        this.scheduleTask(() -> this.pads.forceFlush(note), 100L);
    }

    @Override
    protected void handleNoteEvent(int note, int velocity) {
        if (note != 7) {
            return;
        }
        boolean bl = this.isShift = velocity == 127;
        if (this.isShift) {
            this.getViewManager().setActiveView(Views.VIEW_SHIFT);
        } else {
            if (this.getViewManager().isActiveView(Views.VIEW_SHIFT)) {
                this.getViewManager().restoreView();
            }
            this.getPadGrid().forceFlush();
        }
    }

    @Override
    public void setButtonEx(int button, int channel, int state) {
        this.output.sendCC(button, state);
    }
}

