/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.beatstep;

import de.mossgrabers.controller.beatstep.BeatstepConfiguration;
import de.mossgrabers.controller.beatstep.command.continuous.BeatstepPlayPositionCommand;
import de.mossgrabers.controller.beatstep.command.continuous.KnobRowViewCommand;
import de.mossgrabers.controller.beatstep.command.trigger.StepCommand;
import de.mossgrabers.controller.beatstep.controller.BeatstepColors;
import de.mossgrabers.controller.beatstep.controller.BeatstepControlSurface;
import de.mossgrabers.controller.beatstep.view.BrowserView;
import de.mossgrabers.controller.beatstep.view.DeviceView;
import de.mossgrabers.controller.beatstep.view.DrumView;
import de.mossgrabers.controller.beatstep.view.PlayView;
import de.mossgrabers.controller.beatstep.view.SequencerView;
import de.mossgrabers.controller.beatstep.view.SessionView;
import de.mossgrabers.controller.beatstep.view.ShiftView;
import de.mossgrabers.controller.beatstep.view.TrackView;
import de.mossgrabers.controller.beatstep.view.Views;
import de.mossgrabers.framework.command.Commands;
import de.mossgrabers.framework.command.aftertouch.AftertouchAbstractPlayViewCommand;
import de.mossgrabers.framework.configuration.ISettingsUI;
import de.mossgrabers.framework.controller.AbstractControllerSetup;
import de.mossgrabers.framework.controller.ISetupFactory;
import de.mossgrabers.framework.controller.Relative3ValueChanger;
import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.controller.display.DummyDisplay;
import de.mossgrabers.framework.daw.IChannelBank;
import de.mossgrabers.framework.daw.ICursorDevice;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.ITrackBank;
import de.mossgrabers.framework.daw.data.IMasterTrack;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.midi.IMidiAccess;
import de.mossgrabers.framework.daw.midi.IMidiInput;
import de.mossgrabers.framework.daw.midi.IMidiOutput;
import de.mossgrabers.framework.scale.Scales;
import de.mossgrabers.framework.view.ViewManager;

public class BeatstepControllerSetup
extends AbstractControllerSetup<BeatstepControlSurface, BeatstepConfiguration> {
    private static final int[] DRUM_MATRIX = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    private final boolean isPro;

    public BeatstepControllerSetup(IHost host, ISetupFactory factory, ISettingsUI settings, boolean isPro) {
        super(factory, host, settings);
        this.isPro = isPro;
        this.colorManager = new ColorManager();
        BeatstepColors.addColors(this.colorManager);
        this.valueChanger = new Relative3ValueChanger(128, 1, 0.5);
        this.configuration = new BeatstepConfiguration(this.valueChanger, isPro);
    }

    @Override
    public void flush() {
        this.flushSurfaces();
    }

    @Override
    protected void createScales() {
        this.scales = new Scales(this.valueChanger, 36, 52, 8, 2);
        this.scales.setDrumMatrix(DRUM_MATRIX);
        this.scales.setDrumNoteEnd(52);
    }

    @Override
    protected void createModel() {
        this.model = this.factory.createModel(this.colorManager, this.valueChanger, this.scales, 8, 8, 8, 16, 16, true, -1, -1, -1, -1);
        this.model.getTrackBank().addTrackSelectionObserver(this::handleTrackChange);
    }

    @Override
    protected void createSurface() {
        IMidiAccess midiAccess = this.factory.createMidiAccess();
        IMidiOutput output = midiAccess.createOutput();
        IMidiInput input = midiAccess.createInput("Control", "82????", "92????", "A2????", "B2????");
        input.createNoteInput("Seq. 1", "90????", "80????");
        if (this.isPro) {
            input.createNoteInput("Seq. 2", "91????", "81????");
            input.createNoteInput("Drums", "99????", "89????");
        }
        BeatstepControlSurface surface = new BeatstepControlSurface(this.model.getHost(), this.colorManager, (BeatstepConfiguration)this.configuration, output, input, this.isPro);
        this.surfaces.add(surface);
        surface.setDisplay(new DummyDisplay(this.host));
    }

    @Override
    protected void createObservers() {
        ((BeatstepControlSurface)this.getSurface()).getViewManager().addViewChangeListener((previousViewId, activeViewId) -> this.updateIndication());
        this.createScaleObservers(this.configuration);
    }

    @Override
    protected void createViews() {
        BeatstepControlSurface surface = (BeatstepControlSurface)this.getSurface();
        ViewManager viewManager = surface.getViewManager();
        viewManager.registerView(Views.VIEW_TRACK, new TrackView(surface, this.model));
        viewManager.registerView(Views.VIEW_DEVICE, new DeviceView(surface, this.model));
        viewManager.registerView(Views.VIEW_PLAY, new PlayView(surface, this.model));
        if (this.host.hasClips()) {
            viewManager.registerView(Views.VIEW_DRUM, new DrumView(surface, this.model));
            viewManager.registerView(Views.VIEW_SEQUENCER, new SequencerView(surface, this.model));
            viewManager.registerView(Views.VIEW_SESSION, new SessionView(surface, this.model));
        }
        viewManager.registerView(Views.VIEW_BROWSER, new BrowserView(surface, this.model));
        viewManager.registerView(Views.VIEW_SHIFT, new ShiftView(surface, this.model));
    }

    @Override
    protected void registerTriggerCommands() {
        if (!this.isPro) {
            return;
        }
        BeatstepControlSurface surface = (BeatstepControlSurface)this.getSurface();
        for (int i = 0; i < 16; ++i) {
            this.addTriggerCommand(Commands.COMMAND_ROW1_1 + i, 50 + i, new StepCommand(i, this.model, surface));
        }
    }

    @Override
    protected void registerContinuousCommands() {
        BeatstepControlSurface surface = (BeatstepControlSurface)this.getSurface();
        ViewManager viewManager = surface.getViewManager();
        for (int i = 0; i < 8; ++i) {
            this.addContinuousCommand(Commands.CONT_COMMAND_KNOB1 + i, 20 + i, new KnobRowViewCommand(i, this.model, surface));
            this.addContinuousCommand(Commands.CONT_COMMAND_DEVICE_KNOB1 + i, 30 + i, new KnobRowViewCommand(i + 8, this.model, surface));
        }
        this.addContinuousCommand(Commands.CONT_COMMAND_MASTER_KNOB, 40, new BeatstepPlayPositionCommand(this.model, surface));
        PlayView playView = (PlayView)viewManager.getView(Views.VIEW_PLAY);
        playView.registerAftertouchCommand(new AftertouchAbstractPlayViewCommand<BeatstepControlSurface, BeatstepConfiguration>(playView, this.model, surface));
    }

    @Override
    public void startup() {
        BeatstepControlSurface surface = (BeatstepControlSurface)this.getSurface();
        surface.getOutput().sendSysex("F0 00 20 6B 7F 42 02 00 01 5E 09 F7");
        surface.getViewManager().setActiveView(Views.VIEW_TRACK);
    }

    private void updateIndication() {
        BeatstepControlSurface surface = (BeatstepControlSurface)this.getSurface();
        ViewManager viewManager = surface.getViewManager();
        boolean isTrack = viewManager.isActiveView(Views.VIEW_TRACK);
        boolean isDevice = viewManager.isActiveView(Views.VIEW_DEVICE);
        boolean isSession = viewManager.isActiveView(Views.VIEW_SESSION);
        IMasterTrack mt = this.model.getMasterTrack();
        mt.setVolumeIndication(!isDevice);
        ITrackBank tb = this.model.getTrackBank();
        ITrack selectedTrack = tb.getSelectedTrack();
        IChannelBank tbe = this.model.getEffectTrackBank();
        ICursorDevice cursorDevice = this.model.getCursorDevice();
        boolean isEffect = this.model.isEffectTrackBankActive();
        tb.setIndication(!isEffect && isSession);
        if (tbe != null) {
            tbe.setIndication(isEffect && isSession);
        }
        for (int i = 0; i < 8; ++i) {
            boolean hasTrackSel = selectedTrack != null && selectedTrack.getIndex() == i;
            ITrack track = tb.getTrack(i);
            track.setVolumeIndication(!isEffect && hasTrackSel && !isDevice);
            track.setPanIndication(!isEffect && hasTrackSel && !isDevice);
            for (int j = 0; j < 6; ++j) {
                track.getSend(j).setIndication(!isEffect && hasTrackSel && isTrack);
            }
            if (tbe != null) {
                ITrack selectedFXTrack = tbe.getSelectedTrack();
                boolean hasFXTrackSel = selectedFXTrack != null && selectedFXTrack.getIndex() == i;
                ITrack fxTrack = tbe.getTrack(i);
                fxTrack.setVolumeIndication(isEffect && hasFXTrackSel && isTrack);
                fxTrack.setPanIndication(isEffect && hasFXTrackSel && isTrack);
            }
            cursorDevice.indicateParameter(i, isDevice);
        }
    }

    private void handleTrackChange(int index, boolean isSelected) {
        if (!isSelected) {
            return;
        }
        ViewManager viewManager = ((BeatstepControlSurface)this.getSurface()).getViewManager();
        if (viewManager.isActiveView(Views.VIEW_PLAY)) {
            viewManager.getActiveView().updateNoteMapping();
        }
        this.scales.setDrumOctave(0);
        if (viewManager.isActiveView(Views.VIEW_DRUM)) {
            viewManager.getView(Views.VIEW_DRUM).updateNoteMapping();
        }
    }
}

