/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.apcmini.view;

import de.mossgrabers.controller.apcmini.controller.APCminiControlSurface;
import de.mossgrabers.framework.daw.IChannelBank;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.utils.ButtonEvent;

public class TrackButtons {
    private APCminiControlSurface surface;
    private IModel model;

    public TrackButtons(APCminiControlSurface surface, IModel model) {
        this.surface = surface;
        this.model = model;
    }

    public void updateTrackButtons() {
        IChannelBank tb = this.model.getCurrentTrackBank();
        int trackState = this.surface.getTrackState();
        block7: for (int i = 0; i < 8; ++i) {
            switch (trackState) {
                case 0: {
                    this.surface.updateButton(64 + i, this.surface.isPressed(64 + i) ? 1 : 0);
                    continue block7;
                }
                case 1: {
                    this.surface.updateButton(64 + i, tb.getTrack(i).isSolo() ? 1 : 0);
                    continue block7;
                }
                case 2: {
                    this.surface.updateButton(64 + i, tb.getTrack(i).isRecArm() ? 1 : 0);
                    continue block7;
                }
                case 3: {
                    this.surface.updateButton(64 + i, !tb.getTrack(i).isMute() ? 1 : 0);
                    continue block7;
                }
                case 4: {
                    this.surface.updateButton(64 + i, tb.getTrack(i).isSelected() ? 1 : 0);
                }
            }
        }
    }

    public void onSelectTrack(int index, ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        int trackState = this.surface.getTrackState();
        ITrack track = this.model.getCurrentTrackBank().getTrack(index);
        switch (trackState) {
            case 0: {
                track.stop();
                break;
            }
            case 1: {
                track.toggleSolo();
                break;
            }
            case 2: {
                track.toggleRecArm();
                break;
            }
            case 3: {
                track.toggleMute();
                break;
            }
            case 4: {
                this.surface.getViewManager().getActiveView().selectTrack(index);
            }
        }
    }
}

