/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.apcmini.view;

import de.mossgrabers.controller.apcmini.APCminiConfiguration;
import de.mossgrabers.controller.apcmini.controller.APCminiControlSurface;
import de.mossgrabers.controller.apcmini.mode.Modes;
import de.mossgrabers.controller.apcmini.view.APCminiView;
import de.mossgrabers.controller.apcmini.view.Views;
import de.mossgrabers.framework.command.trigger.transport.PlayCommand;
import de.mossgrabers.framework.controller.grid.PadGrid;
import de.mossgrabers.framework.daw.IChannelBank;
import de.mossgrabers.framework.daw.ICursorDevice;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.ITransport;
import de.mossgrabers.framework.daw.data.ISlot;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.mode.ModeManager;
import de.mossgrabers.framework.scale.Scales;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.AbstractView;
import de.mossgrabers.framework.view.SceneView;
import de.mossgrabers.framework.view.ViewManager;

public class ShiftView
extends AbstractView<APCminiControlSurface, APCminiConfiguration>
implements SceneView,
APCminiView {
    private static final int[] TRANSLATE = new int[]{0, 2, 4, 6, 1, 3, 5, -1, -1, 10, 8, -1, 11, 9, 7, -1};
    final PlayCommand<APCminiControlSurface, APCminiConfiguration> playCommand;

    public ShiftView(APCminiControlSurface surface, IModel model) {
        super("Shift", surface, model);
        this.scales = this.model.getScales();
        this.playCommand = new PlayCommand(this.model, this.surface);
    }

    @Override
    public void drawGrid() {
        int i;
        int scaleOffset = this.scales.getScaleOffset();
        PadGrid padGrid = ((APCminiControlSurface)this.surface).getPadGrid();
        for (i = 7; i < 64; ++i) {
            padGrid.light(36 + i, 0);
        }
        padGrid.light(36, scaleOffset == 0 ? 1 : 5);
        padGrid.light(37, scaleOffset == 2 ? 1 : 5);
        padGrid.light(38, scaleOffset == 4 ? 1 : 5);
        padGrid.light(39, scaleOffset == 6 ? 1 : 5);
        padGrid.light(40, scaleOffset == 1 ? 1 : 5);
        padGrid.light(41, scaleOffset == 3 ? 1 : 5);
        padGrid.light(42, scaleOffset == 5 ? 1 : 5);
        padGrid.light(45, scaleOffset == 10 ? 1 : 3);
        padGrid.light(46, scaleOffset == 8 ? 1 : 3);
        padGrid.light(48, scaleOffset == 11 ? 1 : 3);
        padGrid.light(49, scaleOffset == 9 ? 1 : 3);
        padGrid.light(50, scaleOffset == 7 ? 1 : 3);
        padGrid.light(60, 5);
        padGrid.light(61, 5);
        padGrid.light(68, 1);
        padGrid.light(69, 1);
        padGrid.light(71, 3);
        padGrid.light(72, 3);
        padGrid.light(63, 1);
        if (this.model.getHost().hasClips()) {
            Integer previousViewId = ((APCminiControlSurface)this.surface).getViewManager().getPreviousViewId();
            padGrid.light(92, previousViewId == Views.VIEW_SESSION ? 1 : 5);
            padGrid.light(93, previousViewId == Views.VIEW_PLAY ? 1 : 5);
            padGrid.light(94, previousViewId == Views.VIEW_DRUM ? 1 : 5);
            padGrid.light(95, previousViewId == Views.VIEW_SEQUENCER ? 1 : 5);
            padGrid.light(96, previousViewId == Views.VIEW_RAINDROPS ? 1 : 5);
        } else {
            for (i = 56; i <= 60; ++i) {
                padGrid.light(36 + i, 0);
            }
        }
        ITransport transport = this.model.getTransport();
        padGrid.light(99, transport.isPlaying() ? 2 : 1);
        padGrid.light(91, transport.isRecording() ? 4 : 3);
        padGrid.light(83, 5);
        padGrid.light(75, 5);
        padGrid.light(98, 5);
        padGrid.light(90, transport.isLauncherOverdub() ? 4 : 3);
        padGrid.light(82, 5);
        padGrid.light(74, 5);
    }

    @Override
    public void onGridNote(int note, int velocity) {
        if (velocity == 0) {
            return;
        }
        ICursorDevice cursorDevice = this.model.getCursorDevice();
        int n = ((APCminiControlSurface)this.surface).getPadGrid().translateToController(note);
        switch (n) {
            case 56: {
                this.switchToView(Views.VIEW_SESSION);
                break;
            }
            case 57: {
                this.switchToView(Views.VIEW_PLAY);
                break;
            }
            case 58: {
                this.switchToView(Views.VIEW_DRUM);
                break;
            }
            case 59: {
                this.switchToView(Views.VIEW_SEQUENCER);
                break;
            }
            case 60: {
                this.switchToView(Views.VIEW_RAINDROPS);
                break;
            }
            case 63: {
                this.playCommand.executeNormal(ButtonEvent.DOWN);
                ((APCminiControlSurface)this.surface).getDisplay().notify("Start/Stop");
                break;
            }
            case 55: {
                this.model.getTransport().record();
                ((APCminiControlSurface)this.surface).getDisplay().notify("Record");
                break;
            }
            case 47: {
                this.model.getTransport().toggleLoop();
                ((APCminiControlSurface)this.surface).getDisplay().notify("Toggle Loop");
                break;
            }
            case 39: {
                this.model.getTransport().toggleMetronome();
                ((APCminiControlSurface)this.surface).getDisplay().notify("Toggle Click");
                break;
            }
            case 62: {
                this.onNew();
                ((APCminiControlSurface)this.surface).getDisplay().notify("New clip");
                break;
            }
            case 54: {
                this.model.getTransport().toggleLauncherOverdub();
                ((APCminiControlSurface)this.surface).getDisplay().notify("Toggle Launcher Overdub");
                break;
            }
            case 46: {
                this.model.getCursorClip().quantize((double)((APCminiConfiguration)((APCminiControlSurface)this.surface).getConfiguration()).getQuantizeAmount() / 100.0);
                ((APCminiControlSurface)this.surface).getDisplay().notify("Quantize");
                break;
            }
            case 38: {
                this.model.getApplication().undo();
                ((APCminiControlSurface)this.surface).getDisplay().notify("Undo");
                break;
            }
            case 24: {
                if (!cursorDevice.hasPreviousParameterPage()) break;
                cursorDevice.previousParameterPage();
                ((APCminiControlSurface)this.surface).getDisplay().notify("Bank: " + cursorDevice.getSelectedParameterPageName());
                break;
            }
            case 25: {
                if (!cursorDevice.hasNextParameterPage()) break;
                cursorDevice.nextParameterPage();
                ((APCminiControlSurface)this.surface).getDisplay().notify("Bank: " + cursorDevice.getSelectedParameterPageName());
                break;
            }
            case 32: {
                if (!cursorDevice.canSelectPreviousFX()) break;
                cursorDevice.selectPrevious();
                ((APCminiControlSurface)this.surface).getDisplay().notify("Device: " + cursorDevice.getName());
                break;
            }
            case 33: {
                if (!cursorDevice.canSelectNextFX()) break;
                cursorDevice.selectNext();
                ((APCminiControlSurface)this.surface).getDisplay().notify("Device: " + cursorDevice.getName());
                break;
            }
            case 35: {
                this.scales.prevScale();
                String name = this.scales.getScale().getName();
                ((APCminiConfiguration)((APCminiControlSurface)this.surface).getConfiguration()).setScale(name);
                ((APCminiControlSurface)this.surface).getDisplay().notify(name);
                break;
            }
            case 36: {
                this.scales.nextScale();
                String name2 = this.scales.getScale().getName();
                ((APCminiConfiguration)((APCminiControlSurface)this.surface).getConfiguration()).setScale(name2);
                ((APCminiControlSurface)this.surface).getDisplay().notify(name2);
                break;
            }
            case 27: {
                this.scales.toggleChromatic();
                ((APCminiControlSurface)this.surface).getDisplay().notify(this.scales.isChromatic() ? "Chromatc" : "In Key");
                break;
            }
            default: {
                if (n > 15) {
                    return;
                }
                int pos = TRANSLATE[n];
                if (pos == -1) {
                    return;
                }
                this.scales.setScaleOffset(pos);
                ((APCminiConfiguration)((APCminiControlSurface)this.surface).getConfiguration()).setScaleBase(Scales.BASES[pos]);
                ((APCminiControlSurface)this.surface).getDisplay().notify(Scales.BASES[pos]);
                ((APCminiControlSurface)this.surface).getViewManager().getActiveView().updateNoteMapping();
            }
        }
    }

    @Override
    public void onSelectTrack(int index, ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        IChannelBank tb = this.model.getCurrentTrackBank();
        ModeManager modeManager = ((APCminiControlSurface)this.surface).getModeManager();
        switch (index) {
            case 0: {
                tb.scrollScenesPageUp();
                break;
            }
            case 1: {
                tb.scrollScenesPageDown();
                break;
            }
            case 2: {
                tb.scrollTracksPageUp();
                break;
            }
            case 3: {
                tb.scrollTracksPageDown();
                break;
            }
            case 4: {
                modeManager.setActiveMode(Modes.MODE_VOLUME);
                ((APCminiConfiguration)((APCminiControlSurface)this.surface).getConfiguration()).setFaderCtrl("Volume");
                ((APCminiControlSurface)this.surface).getDisplay().notify("Volume");
                break;
            }
            case 5: {
                modeManager.setActiveMode(Modes.MODE_PAN);
                ((APCminiConfiguration)((APCminiControlSurface)this.surface).getConfiguration()).setFaderCtrl("Pan");
                ((APCminiControlSurface)this.surface).getDisplay().notify("Pan");
                break;
            }
            case 6: {
                if (this.model.isEffectTrackBankActive()) {
                    return;
                }
                Integer mode = modeManager.getActiveModeId() + 1;
                if (!Modes.isSendMode(mode)) {
                    mode = Modes.MODE_SEND1;
                }
                if (Modes.isSendMode(mode) && tb.canEditSend(mode - Modes.MODE_SEND1)) {
                    mode = Modes.MODE_SEND1;
                }
                modeManager.setActiveMode(mode);
                String name = "Send " + (mode - Modes.MODE_SEND1 + 1);
                ((APCminiConfiguration)((APCminiControlSurface)this.surface).getConfiguration()).setFaderCtrl(name);
                ((APCminiControlSurface)this.surface).getDisplay().notify(name);
                break;
            }
            case 7: {
                if (modeManager.isActiveMode(Modes.MODE_DEVICE)) {
                    this.model.getBrowser().browseForPresets();
                    ViewManager viewManager = ((APCminiControlSurface)this.surface).getViewManager();
                    Integer previousViewId = viewManager.getPreviousViewId();
                    viewManager.setActiveView(Views.VIEW_BROWSER);
                    viewManager.setPreviousView(previousViewId);
                    break;
                }
                modeManager.setActiveMode(Modes.MODE_DEVICE);
                ((APCminiConfiguration)((APCminiControlSurface)this.surface).getConfiguration()).setFaderCtrl("Device");
                ((APCminiControlSurface)this.surface).getDisplay().notify("Device");
            }
        }
    }

    @Override
    public void onScene(int index, ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        switch (index) {
            case 5: {
                ModeManager modeManager;
                this.model.toggleCurrentTrackBank();
                boolean isEffectTrackBank = this.model.isEffectTrackBankActive();
                if (isEffectTrackBank && Modes.isSendMode((modeManager = ((APCminiControlSurface)this.surface).getModeManager()).getActiveModeId())) {
                    modeManager.setActiveMode(Modes.MODE_VOLUME);
                }
                ((APCminiControlSurface)this.surface).getDisplay().notify(isEffectTrackBank ? "Effect Tracks" : "Instrument/Audio Tracks");
                break;
            }
            case 6: {
                this.model.getCursorDevice().toggleWindowOpen();
                break;
            }
            case 7: {
                this.model.getCurrentTrackBank().stop();
                break;
            }
            default: {
                ((APCminiControlSurface)this.surface).setTrackState(index);
                ((APCminiConfiguration)((APCminiControlSurface)this.surface).getConfiguration()).setSoftKeys(APCminiConfiguration.SOFT_KEYS_OPTIONS[index]);
                ((APCminiControlSurface)this.surface).getDisplay().notify(APCminiConfiguration.SOFT_KEYS_OPTIONS[index]);
            }
        }
    }

    @Override
    public void updateSceneButtons() {
        int trackState = ((APCminiControlSurface)this.surface).getTrackState();
        ((APCminiControlSurface)this.surface).updateButton(82, trackState == 0 ? 1 : 0);
        ((APCminiControlSurface)this.surface).updateButton(83, trackState == 1 ? 1 : 0);
        ((APCminiControlSurface)this.surface).updateButton(84, trackState == 2 ? 1 : 0);
        ((APCminiControlSurface)this.surface).updateButton(85, trackState == 3 ? 1 : 0);
        ((APCminiControlSurface)this.surface).updateButton(86, trackState == 4 ? 1 : 0);
        ((APCminiControlSurface)this.surface).updateButton(87, this.model.isEffectTrackBankActive() ? 1 : 0);
        ((APCminiControlSurface)this.surface).updateButton(88, 0);
        ((APCminiControlSurface)this.surface).updateButton(89, 0);
        IChannelBank tb = this.model.getCurrentTrackBank();
        ((APCminiControlSurface)this.surface).updateButton(64, tb.canScrollScenesUp() ? 1 : 0);
        ((APCminiControlSurface)this.surface).updateButton(65, tb.canScrollScenesDown() ? 1 : 0);
        ((APCminiControlSurface)this.surface).updateButton(66, tb.canScrollTracksUp() ? 1 : 0);
        ((APCminiControlSurface)this.surface).updateButton(67, tb.canScrollTracksDown() ? 1 : 0);
        Integer mode = ((APCminiControlSurface)this.surface).getModeManager().getActiveModeId();
        ((APCminiControlSurface)this.surface).updateButton(68, Modes.MODE_VOLUME.equals(mode) ? 1 : 0);
        ((APCminiControlSurface)this.surface).updateButton(69, Modes.MODE_PAN.equals(mode) ? 1 : 0);
        ((APCminiControlSurface)this.surface).updateButton(70, Modes.isSendMode(mode) ? 1 : 0);
        ((APCminiControlSurface)this.surface).updateButton(71, Modes.MODE_DEVICE.equals(mode) ? 1 : 0);
    }

    private void onNew() {
        ISlot[] slotIndexes;
        ITrack t = this.model.getSelectedTrack();
        if (t != null && (slotIndexes = t.getSelectedSlots()).length > 0) {
            int slotIndex = slotIndexes[0].getIndex();
            for (int i = 0; i < 8; ++i) {
                int sIndex = (slotIndex + i) % 8;
                ISlot s = t.getSlot(sIndex);
                if (s.hasContent()) continue;
                this.model.createClip(s, ((APCminiConfiguration)((APCminiControlSurface)this.surface).getConfiguration()).getNewClipLength());
                if (slotIndex != sIndex) {
                    s.select();
                }
                s.launch();
                this.model.getTransport().setLauncherOverdub(true);
                return;
            }
        }
        ((APCminiControlSurface)this.surface).getDisplay().notify("In the current selected grid view there is no empty slot. Please scroll down.");
    }

    private void switchToView(Integer viewID) {
        if (!this.model.getHost().hasClips()) {
            return;
        }
        ViewManager viewManager = ((APCminiControlSurface)this.surface).getViewManager();
        viewManager.setPreviousView(viewID);
        ((APCminiControlSurface)this.surface).getDisplay().notify(viewManager.getView(viewID).getName());
    }
}

