/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.apcmini.view;

import de.mossgrabers.controller.apcmini.APCminiConfiguration;
import de.mossgrabers.controller.apcmini.controller.APCminiControlSurface;
import de.mossgrabers.controller.apcmini.view.APCminiView;
import de.mossgrabers.controller.apcmini.view.TrackButtons;
import de.mossgrabers.framework.daw.IChannelBank;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ISlot;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.AbstractSessionView;

public class SessionView
extends AbstractSessionView<APCminiControlSurface, APCminiConfiguration>
implements APCminiView {
    private final TrackButtons extensions;

    public SessionView(APCminiControlSurface surface, IModel model) {
        super("Session", surface, model, 8, 8, false);
        this.extensions = new TrackButtons(surface, model);
    }

    @Override
    public boolean doSelectClipOnLaunch() {
        return ((APCminiConfiguration)((APCminiControlSurface)this.surface).getConfiguration()).isSelectClipOnLaunch();
    }

    @Override
    public void drawGrid() {
        IChannelBank tb = this.model.getCurrentTrackBank();
        for (int x = 0; x < 8; ++x) {
            ITrack t = tb.getTrack(x);
            for (int y = 0; y < 8; ++y) {
                this.drawPad(t.getSlot(y), x, y, t.isRecArm());
            }
        }
    }

    @Override
    public void drawPad(ISlot slot, int x, int y, boolean isArmed) {
        int color = 0;
        if (slot.isRecording()) {
            color = 3;
        } else if (slot.isRecordingQueued()) {
            color = 4;
        } else if (slot.isPlaying()) {
            color = 1;
        } else if (slot.isPlayingQueued()) {
            color = 2;
        } else if (slot.hasContent()) {
            color = 5;
        }
        ((APCminiControlSurface)this.surface).getPadGrid().light(36 + (7 - y) * 8 + x, color);
    }

    @Override
    public void updateSceneButtons() {
        for (int i = 82; i <= 89; ++i) {
            ((APCminiControlSurface)this.surface).updateButton(i, ((APCminiControlSurface)this.surface).getNoteVelocity(i) > 0 ? 1 : 0);
        }
        this.extensions.updateTrackButtons();
    }

    @Override
    public void onSelectTrack(int index, ButtonEvent event) {
        this.extensions.onSelectTrack(index, event);
    }
}

