/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.apcmini.view;

import de.mossgrabers.controller.apcmini.APCminiConfiguration;
import de.mossgrabers.controller.apcmini.controller.APCminiControlSurface;
import de.mossgrabers.controller.apcmini.view.APCminiView;
import de.mossgrabers.framework.daw.ICursorClip;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.AbstractNoteSequencerView;

public class SequencerView
extends AbstractNoteSequencerView<APCminiControlSurface, APCminiConfiguration>
implements APCminiView {
    public SequencerView(APCminiControlSurface surface, IModel model) {
        super("Sequencer", surface, model, false);
    }

    @Override
    public void onSelectTrack(int index, ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        switch (index) {
            case 0: {
                this.onOctaveUp(event);
                break;
            }
            case 1: {
                this.onOctaveDown(event);
                break;
            }
            case 2: {
                this.onLeft(event);
                break;
            }
            case 3: {
                this.onRight(event);
            }
        }
        this.updateScale();
    }

    @Override
    public void updateSceneButtons() {
        boolean isKeyboardEnabled = this.model.canSelectedTrackHoldNotes();
        for (int i = 0; i < 8; ++i) {
            ((APCminiControlSurface)this.surface).updateButton(82 + i, isKeyboardEnabled && i == 7 - this.selectedIndex ? 1 : 0);
        }
        int octave = this.scales.getOctave();
        ((APCminiControlSurface)this.surface).updateButton(64, octave < 4 ? 1 : 0);
        ((APCminiControlSurface)this.surface).updateButton(65, octave > -4 ? 1 : 0);
        ICursorClip clip = this.getClip();
        ((APCminiControlSurface)this.surface).updateButton(66, clip != null && clip.canScrollStepsBackwards() ? 1 : 0);
        ((APCminiControlSurface)this.surface).updateButton(67, clip != null && clip.canScrollStepsForwards() ? 1 : 0);
        for (int i = 0; i < 4; ++i) {
            ((APCminiControlSurface)this.surface).updateButton(68 + i, 0);
        }
    }
}

