/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.apcmini.view;

import de.mossgrabers.controller.apcmini.APCminiConfiguration;
import de.mossgrabers.controller.apcmini.controller.APCminiControlSurface;
import de.mossgrabers.controller.apcmini.view.APCminiView;
import de.mossgrabers.controller.apcmini.view.TrackButtons;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.AbstractPlayView;
import de.mossgrabers.framework.view.SceneView;

public class PlayView
extends AbstractPlayView<APCminiControlSurface, APCminiConfiguration>
implements APCminiView,
SceneView {
    private TrackButtons extensions;

    public PlayView(APCminiControlSurface surface, IModel model) {
        super(surface, model, false);
        this.extensions = new TrackButtons(surface, model);
    }

    @Override
    public void onSelectTrack(int index, ButtonEvent event) {
        this.extensions.onSelectTrack(index, event);
    }

    @Override
    public void updateSceneButtons() {
        for (int i = 0; i < 8; ++i) {
            ((APCminiControlSurface)this.surface).updateButton(82 + i, i == 2 ? 0 : 1);
        }
        this.extensions.updateTrackButtons();
    }

    @Override
    public void onScene(int scene, ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        if (!this.model.canSelectedTrackHoldNotes()) {
            return;
        }
        switch (scene) {
            case 0: {
                this.scales.nextScaleLayout();
                this.updateScaleLayout();
                break;
            }
            case 1: {
                this.scales.prevScaleLayout();
                this.updateScaleLayout();
                break;
            }
            case 3: {
                this.scales.prevScale();
                this.updateScale();
                break;
            }
            case 4: {
                this.scales.nextScale();
                this.updateScale();
                break;
            }
            case 5: {
                this.scales.toggleChromatic();
                boolean isChromatic = this.scales.isChromatic();
                ((APCminiConfiguration)((APCminiControlSurface)this.surface).getConfiguration()).setScaleInKey(!isChromatic);
                ((APCminiControlSurface)this.surface).getDisplay().notify(isChromatic ? "Chromatic" : "In Key");
                break;
            }
            case 6: {
                this.onOctaveUp(event);
                break;
            }
            case 7: {
                this.onOctaveDown(event);
            }
        }
        this.updateNoteMapping();
    }

    private void updateScaleLayout() {
        this.updateNoteMapping();
        String name = this.scales.getScaleLayout().getName();
        ((APCminiConfiguration)((APCminiControlSurface)this.surface).getConfiguration()).setScaleLayout(name);
        ((APCminiControlSurface)this.surface).getDisplay().notify(name);
    }

    private void updateScale() {
        String name = this.scales.getScale().getName();
        ((APCminiConfiguration)((APCminiControlSurface)this.surface).getConfiguration()).setScale(name);
        ((APCminiControlSurface)this.surface).getDisplay().notify(name);
    }
}

