/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.apcmini.view;

import de.mossgrabers.controller.apcmini.APCminiConfiguration;
import de.mossgrabers.controller.apcmini.controller.APCminiControlSurface;
import de.mossgrabers.controller.apcmini.view.APCminiView;
import de.mossgrabers.framework.daw.ICursorClip;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IChannel;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.AbstractDrumView;

public class DrumView
extends AbstractDrumView<APCminiControlSurface, APCminiConfiguration>
implements APCminiView {
    public DrumView(APCminiControlSurface surface, IModel model) {
        super("Drum", surface, model, 4, 4);
    }

    @Override
    protected String getPadContentColor(IChannel drumPad) {
        return "COLOR_PAD_HAS_CONTENT";
    }

    @Override
    public void onSelectTrack(int index, ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        switch (index) {
            case 0: {
                this.onOctaveUp(event);
                break;
            }
            case 1: {
                this.onOctaveDown(event);
                break;
            }
            case 2: {
                this.onLeft(event);
                break;
            }
            case 3: {
                this.onRight(event);
            }
        }
    }

    @Override
    public void updateSceneButtons() {
        boolean isKeyboardEnabled = this.model.canSelectedTrackHoldNotes();
        for (int i = 0; i < 8; ++i) {
            ((APCminiControlSurface)this.surface).updateButton(82 + i, isKeyboardEnabled && i == 7 - this.selectedIndex ? 1 : 0);
        }
        int octave = this.scales.getDrumOctave();
        ((APCminiControlSurface)this.surface).updateButton(64, octave < 4 ? 1 : 0);
        ((APCminiControlSurface)this.surface).updateButton(65, octave > -2 ? 1 : 0);
        ICursorClip clip = this.getClip();
        ((APCminiControlSurface)this.surface).updateButton(66, clip != null && clip.canScrollStepsBackwards() ? 1 : 0);
        ((APCminiControlSurface)this.surface).updateButton(67, clip != null && clip.canScrollStepsForwards() ? 1 : 0);
        for (int i = 0; i < 4; ++i) {
            ((APCminiControlSurface)this.surface).updateButton(68 + i, 0);
        }
    }
}

