/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.apcmini.view;

import de.mossgrabers.controller.apcmini.APCminiConfiguration;
import de.mossgrabers.controller.apcmini.controller.APCminiControlSurface;
import de.mossgrabers.controller.apcmini.view.APCminiView;
import de.mossgrabers.controller.apcmini.view.Views;
import de.mossgrabers.framework.controller.grid.PadGrid;
import de.mossgrabers.framework.daw.IBrowser;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.AbstractView;
import de.mossgrabers.framework.view.SceneView;
import de.mossgrabers.framework.view.ViewManager;

public class BrowserView
extends AbstractView<APCminiControlSurface, APCminiConfiguration>
implements SceneView,
APCminiView {
    private static final int[] COLUMN_COLORS = new int[]{1, 3, 1, 3, 1, 3, 0, 5};

    public BrowserView(APCminiControlSurface surface, IModel model) {
        super("Browser", surface, model);
    }

    @Override
    public void drawGrid() {
        int i;
        PadGrid padGrid = ((APCminiControlSurface)this.surface).getPadGrid();
        padGrid.light(36, 4);
        padGrid.light(37, 0);
        for (i = 38; i < 42; ++i) {
            padGrid.light(i, 5);
        }
        padGrid.light(42, 0);
        padGrid.light(43, 2);
        for (i = 44; i < 52; ++i) {
            padGrid.light(i, 0);
        }
        for (i = 52; i < 60; ++i) {
            padGrid.light(i, COLUMN_COLORS[i - 52]);
        }
        for (i = 60; i < 68; ++i) {
            padGrid.light(i, COLUMN_COLORS[i - 60]);
        }
        for (i = 68; i < 76; ++i) {
            padGrid.light(i, COLUMN_COLORS[i - 68]);
        }
        for (i = 76; i < 84; ++i) {
            padGrid.light(i, COLUMN_COLORS[i - 76]);
        }
        for (i = 84; i < 100; ++i) {
            padGrid.light(i, 0);
        }
    }

    @Override
    public void onGridNote(int note, int velocity) {
        IBrowser browser = this.model.getBrowser();
        ViewManager viewManager = ((APCminiControlSurface)this.surface).getViewManager();
        if (!browser.isActive()) {
            if (viewManager.isActiveView(Views.VIEW_BROWSER)) {
                viewManager.restoreView();
            }
            return;
        }
        int n = ((APCminiControlSurface)this.surface).getPadGrid().translateToController(note);
        switch (n) {
            case 0: {
                if (velocity == 0) {
                    return;
                }
                this.model.getBrowser().stopBrowsing(false);
                viewManager.restoreView();
                break;
            }
            case 7: {
                if (velocity == 0) {
                    return;
                }
                this.model.getBrowser().stopBrowsing(true);
                viewManager.restoreView();
                break;
            }
            case 2: {
                ((APCminiControlSurface)this.surface).sendMidiEvent(144, 48, velocity);
                break;
            }
            case 3: {
                ((APCminiControlSurface)this.surface).sendMidiEvent(144, 60, velocity);
                break;
            }
            case 4: {
                ((APCminiControlSurface)this.surface).sendMidiEvent(144, 72, velocity);
                break;
            }
            case 5: {
                ((APCminiControlSurface)this.surface).sendMidiEvent(144, 84, velocity);
            }
        }
        if (velocity == 0) {
            return;
        }
        if (n >= 16 && n < 48) {
            int row = (n -= 16) / 8;
            int col = n % 8;
            switch (col) {
                case 6: {
                    return;
                }
                case 7: {
                    if (row == 0) {
                        browser.selectNextResult();
                        break;
                    }
                    if (row == 1) {
                        for (int i = 0; i < 8; ++i) {
                            browser.selectNextResult();
                        }
                        break;
                    }
                    if (row == 2) {
                        for (int i = 0; i < 8; ++i) {
                            browser.selectPreviousResult();
                        }
                        break;
                    }
                    if (row != 3) break;
                    browser.selectPreviousResult();
                    break;
                }
                default: {
                    if (row == 0) {
                        browser.selectNextFilterItem(col);
                        break;
                    }
                    if (row == 1) {
                        for (int i = 0; i < 8; ++i) {
                            browser.selectNextFilterItem(col);
                        }
                        break;
                    }
                    if (row == 2) {
                        for (int i = 0; i < 8; ++i) {
                            browser.selectPreviousFilterItem(col);
                        }
                        break;
                    }
                    if (row != 3) break;
                    browser.selectPreviousFilterItem(col);
                }
            }
        }
    }

    @Override
    public void onScene(int scene, ButtonEvent event) {
    }

    @Override
    public void onSelectTrack(int index, ButtonEvent event) {
    }

    @Override
    public void updateSceneButtons() {
        for (int i = 0; i < 8; ++i) {
            ((APCminiControlSurface)this.surface).updateButton(82 + i, 0);
            ((APCminiControlSurface)this.surface).updateButton(64 + i, 0);
        }
    }
}

